/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.library.google.inject.internal;

import com.exsoloscript.challonge.library.google.inject.Provider;
import com.exsoloscript.challonge.library.google.inject.ProvisionException;
import com.exsoloscript.challonge.library.google.inject.internal.ContextualCallable;
import com.exsoloscript.challonge.library.google.inject.internal.Errors;
import com.exsoloscript.challonge.library.google.inject.internal.ErrorsException;
import com.exsoloscript.challonge.library.google.inject.internal.InjectorImpl;
import com.exsoloscript.challonge.library.google.inject.internal.InternalContext;
import com.exsoloscript.challonge.library.google.inject.internal.InternalFactory;
import com.exsoloscript.challonge.library.google.inject.spi.Dependency;

final class ProviderToInternalFactoryAdapter<T>
implements Provider<T> {
    private final InjectorImpl injector;
    private final InternalFactory<? extends T> internalFactory;

    public ProviderToInternalFactoryAdapter(InjectorImpl injector, InternalFactory<? extends T> internalFactory) {
        this.injector = injector;
        this.internalFactory = internalFactory;
    }

    @Override
    public T get() {
        final Errors errors = new Errors();
        try {
            Object t = this.injector.callInContext(new ContextualCallable<T>(){

                @Override
                public T call(InternalContext context) throws ErrorsException {
                    Dependency<?> dependency = context.getDependency();
                    return ProviderToInternalFactoryAdapter.this.internalFactory.get(errors, context, dependency, true);
                }
            });
            errors.throwIfNewErrors(0);
            return t;
        }
        catch (ErrorsException e) {
            throw new ProvisionException(errors.merge(e.getErrors()).getMessages());
        }
    }

    public String toString() {
        return this.internalFactory.toString();
    }
}

