/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.model;

import com.exsoloscript.challonge.library.google.gson.annotations.SerializedName;
import com.exsoloscript.challonge.model.Match;
import com.exsoloscript.challonge.model.Participant;
import com.exsoloscript.challonge.model.enumeration.RankedBy;
import com.exsoloscript.challonge.model.enumeration.TournamentState;
import com.exsoloscript.challonge.model.enumeration.TournamentType;
import com.exsoloscript.challonge.model.enumeration.query.GrandFinalsModifier;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

public class Tournament {
    private final String name;
    @SerializedName(value="tournament_type")
    private final TournamentType tournamentType;
    private final String url;
    private final String subdomain;
    private final String description;
    @SerializedName(value="open_signup")
    private final Boolean openSignup;
    @SerializedName(value="hold_third_place_match")
    private final Boolean holdThirdPlaceMatch;
    @SerializedName(value="pts_for_match_win")
    private final Float pointsForMatchWin;
    @SerializedName(value="pts_for_match_tie")
    private final Float pointsForMatchTie;
    @SerializedName(value="pts_for_game_win")
    private final Float pointsForGameWin;
    @SerializedName(value="pts_for_game_tie")
    private final Float pointsForGameTie;
    @SerializedName(value="pts_for_bye")
    private final Float pointsForBye;
    @SerializedName(value="swiss_rounds")
    private final Integer swissRounds;
    @SerializedName(value="ranked_by")
    private final RankedBy rankedBy;
    @SerializedName(value="rr_pts_for_game_win")
    private final Float roundRobinPointsForGameWin;
    @SerializedName(value="rr_pts_for_game_tie")
    private final Float roundRobinPointsForGameTie;
    @SerializedName(value="rr_pts_for_match_win")
    private final Float roundRobinPointsForMatchWin;
    @SerializedName(value="rr_pts_for_match_tie")
    private final Float roundRobinPointsForMatchTie;
    @SerializedName(value="accept_attachments")
    private final Boolean acceptAttachments;
    @SerializedName(value="hide_forum")
    private final Boolean hideForum;
    @SerializedName(value="show_rounds")
    private final Boolean showRounds;
    @SerializedName(value="private")
    private final Boolean _private;
    @SerializedName(value="notify_users_when_the_tournament_ends")
    private final Boolean notifyUsersWhenTheTournamentEnds;
    @SerializedName(value="sequential_pairings")
    private final Boolean sequentialPairings;
    @SerializedName(value="signup_cap")
    private final Integer signupCap;
    @SerializedName(value="start_at")
    private final OffsetDateTime startAt;
    @SerializedName(value="check_in_duration")
    private final Integer checkInDuration;
    @SerializedName(value="allow_participant_match_reporting")
    private final Boolean allowParticipantMatchReporting;
    @SerializedName(value="anonymous_voting")
    private final Boolean anonymousVoting;
    private final String category;
    @SerializedName(value="completed_at")
    private final OffsetDateTime completedAt;
    @SerializedName(value="created_at")
    private final OffsetDateTime createdAt;
    @SerializedName(value="created_by_api")
    private final Boolean createdByApi;
    @SerializedName(value="credit_capped")
    private final Boolean creditCapped;
    @SerializedName(value="game_id")
    private final Integer gameId;
    @SerializedName(value="group_stages_enabled")
    private final Boolean groupStagesEnabled;
    @SerializedName(value="hide_seeds")
    private final Boolean hideSeeds;
    private final Integer id;
    @SerializedName(value="max_predictions_per_user")
    private final Integer maxPredictionsPerUser;
    @SerializedName(value="notify_users_when_matches_open")
    private final Boolean notifyUsersWhenMatchesOpen;
    @SerializedName(value="participants_count")
    private final Integer participantsCount;
    @SerializedName(value="prediction_method")
    private final Integer predictionMethod;
    @SerializedName(value="predictions_opened_at")
    private final OffsetDateTime predictionsOpenedAt;
    @SerializedName(value="progress_meter")
    private final Integer progressMeter;
    @SerializedName(value="quick_advance")
    private final Boolean quickAdvance;
    @SerializedName(value="require_score_agreement")
    private final Boolean requireScoreAgreement;
    @SerializedName(value="started_at")
    private final OffsetDateTime startedAt;
    @SerializedName(value="started_checking_in_at")
    private final OffsetDateTime startedCheckingInAt;
    private final TournamentState state;
    private final Boolean teams;
    @SerializedName(value="tie_breaks")
    private final String[] tieBreaks;
    @SerializedName(value="updated_at")
    private final OffsetDateTime updatedAt;
    @SerializedName(value="description_source")
    private final String descriptionSource;
    @SerializedName(value="full_challonge_url")
    private final String fullChallongeUrl;
    @SerializedName(value="live_image_url")
    private final String liveImageUrl;
    @SerializedName(value="sign_up_url")
    private final String signUpUrl;
    @SerializedName(value="review_before_finalizing")
    private final Boolean reviewBeforeFinalizing;
    @SerializedName(value="accepting_predictions")
    private final Boolean acceptingPredictions;
    @SerializedName(value="participants_locked")
    private final Boolean participantsLocked;
    @SerializedName(value="game_name")
    private final String gameName;
    @SerializedName(value="participants_swappable")
    private final Boolean participantsSwappable;
    @SerializedName(value="team_convertable")
    private final Boolean teamConvertable;
    @SerializedName(value="group_stages_were_started")
    private final Boolean groupStagesWereStarted;
    @SerializedName(value="locked_at")
    private final OffsetDateTime lockedAt;
    @SerializedName(value="event_id")
    private final Integer eventId;
    @SerializedName(value="public_predictions_before_start_time")
    private final Boolean publicPredictionsBeforeStartTime;
    @SerializedName(value="grand_finals_modifier")
    private final GrandFinalsModifier grandFinalsModifier;
    private final List<Participant> participants;
    private final List<Match> matches;

    @ConstructorProperties(value={"name", "tournamentType", "url", "subdomain", "description", "openSignup", "holdThirdPlaceMatch", "pointsForMatchWin", "pointsForMatchTie", "pointsForGameWin", "pointsForGameTie", "pointsForBye", "swissRounds", "rankedBy", "roundRobinPointsForGameWin", "roundRobinPointsForGameTie", "roundRobinPointsForMatchWin", "roundRobinPointsForMatchTie", "acceptAttachments", "hideForum", "showRounds", "_private", "notifyUsersWhenTheTournamentEnds", "sequentialPairings", "signupCap", "startAt", "checkInDuration", "allowParticipantMatchReporting", "anonymousVoting", "category", "completedAt", "createdAt", "createdByApi", "creditCapped", "gameId", "groupStagesEnabled", "hideSeeds", "id", "maxPredictionsPerUser", "notifyUsersWhenMatchesOpen", "participantsCount", "predictionMethod", "predictionsOpenedAt", "progressMeter", "quickAdvance", "requireScoreAgreement", "startedAt", "startedCheckingInAt", "state", "teams", "tieBreaks", "updatedAt", "descriptionSource", "fullChallongeUrl", "liveImageUrl", "signUpUrl", "reviewBeforeFinalizing", "acceptingPredictions", "participantsLocked", "gameName", "participantsSwappable", "teamConvertable", "groupStagesWereStarted", "lockedAt", "eventId", "publicPredictionsBeforeStartTime", "grandFinalsModifier", "participants", "matches"})
    public Tournament(String name, TournamentType tournamentType, String url, String subdomain, String description, Boolean openSignup, Boolean holdThirdPlaceMatch, Float pointsForMatchWin, Float pointsForMatchTie, Float pointsForGameWin, Float pointsForGameTie, Float pointsForBye, Integer swissRounds, RankedBy rankedBy, Float roundRobinPointsForGameWin, Float roundRobinPointsForGameTie, Float roundRobinPointsForMatchWin, Float roundRobinPointsForMatchTie, Boolean acceptAttachments, Boolean hideForum, Boolean showRounds, Boolean _private, Boolean notifyUsersWhenTheTournamentEnds, Boolean sequentialPairings, Integer signupCap, OffsetDateTime startAt, Integer checkInDuration, Boolean allowParticipantMatchReporting, Boolean anonymousVoting, String category, OffsetDateTime completedAt, OffsetDateTime createdAt, Boolean createdByApi, Boolean creditCapped, Integer gameId, Boolean groupStagesEnabled, Boolean hideSeeds, Integer id, Integer maxPredictionsPerUser, Boolean notifyUsersWhenMatchesOpen, Integer participantsCount, Integer predictionMethod, OffsetDateTime predictionsOpenedAt, Integer progressMeter, Boolean quickAdvance, Boolean requireScoreAgreement, OffsetDateTime startedAt, OffsetDateTime startedCheckingInAt, TournamentState state, Boolean teams, String[] tieBreaks, OffsetDateTime updatedAt, String descriptionSource, String fullChallongeUrl, String liveImageUrl, String signUpUrl, Boolean reviewBeforeFinalizing, Boolean acceptingPredictions, Boolean participantsLocked, String gameName, Boolean participantsSwappable, Boolean teamConvertable, Boolean groupStagesWereStarted, OffsetDateTime lockedAt, Integer eventId, Boolean publicPredictionsBeforeStartTime, GrandFinalsModifier grandFinalsModifier, List<Participant> participants, List<Match> matches) {
        this.name = name;
        this.tournamentType = tournamentType;
        this.url = url;
        this.subdomain = subdomain;
        this.description = description;
        this.openSignup = openSignup;
        this.holdThirdPlaceMatch = holdThirdPlaceMatch;
        this.pointsForMatchWin = pointsForMatchWin;
        this.pointsForMatchTie = pointsForMatchTie;
        this.pointsForGameWin = pointsForGameWin;
        this.pointsForGameTie = pointsForGameTie;
        this.pointsForBye = pointsForBye;
        this.swissRounds = swissRounds;
        this.rankedBy = rankedBy;
        this.roundRobinPointsForGameWin = roundRobinPointsForGameWin;
        this.roundRobinPointsForGameTie = roundRobinPointsForGameTie;
        this.roundRobinPointsForMatchWin = roundRobinPointsForMatchWin;
        this.roundRobinPointsForMatchTie = roundRobinPointsForMatchTie;
        this.acceptAttachments = acceptAttachments;
        this.hideForum = hideForum;
        this.showRounds = showRounds;
        this._private = _private;
        this.notifyUsersWhenTheTournamentEnds = notifyUsersWhenTheTournamentEnds;
        this.sequentialPairings = sequentialPairings;
        this.signupCap = signupCap;
        this.startAt = startAt;
        this.checkInDuration = checkInDuration;
        this.allowParticipantMatchReporting = allowParticipantMatchReporting;
        this.anonymousVoting = anonymousVoting;
        this.category = category;
        this.completedAt = completedAt;
        this.createdAt = createdAt;
        this.createdByApi = createdByApi;
        this.creditCapped = creditCapped;
        this.gameId = gameId;
        this.groupStagesEnabled = groupStagesEnabled;
        this.hideSeeds = hideSeeds;
        this.id = id;
        this.maxPredictionsPerUser = maxPredictionsPerUser;
        this.notifyUsersWhenMatchesOpen = notifyUsersWhenMatchesOpen;
        this.participantsCount = participantsCount;
        this.predictionMethod = predictionMethod;
        this.predictionsOpenedAt = predictionsOpenedAt;
        this.progressMeter = progressMeter;
        this.quickAdvance = quickAdvance;
        this.requireScoreAgreement = requireScoreAgreement;
        this.startedAt = startedAt;
        this.startedCheckingInAt = startedCheckingInAt;
        this.state = state;
        this.teams = teams;
        this.tieBreaks = tieBreaks;
        this.updatedAt = updatedAt;
        this.descriptionSource = descriptionSource;
        this.fullChallongeUrl = fullChallongeUrl;
        this.liveImageUrl = liveImageUrl;
        this.signUpUrl = signUpUrl;
        this.reviewBeforeFinalizing = reviewBeforeFinalizing;
        this.acceptingPredictions = acceptingPredictions;
        this.participantsLocked = participantsLocked;
        this.gameName = gameName;
        this.participantsSwappable = participantsSwappable;
        this.teamConvertable = teamConvertable;
        this.groupStagesWereStarted = groupStagesWereStarted;
        this.lockedAt = lockedAt;
        this.eventId = eventId;
        this.publicPredictionsBeforeStartTime = publicPredictionsBeforeStartTime;
        this.grandFinalsModifier = grandFinalsModifier;
        this.participants = participants;
        this.matches = matches;
    }

    public String name() {
        return this.name;
    }

    public TournamentType tournamentType() {
        return this.tournamentType;
    }

    public String url() {
        return this.url;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String description() {
        return this.description;
    }

    public Boolean openSignup() {
        return this.openSignup;
    }

    public Boolean holdThirdPlaceMatch() {
        return this.holdThirdPlaceMatch;
    }

    public Float pointsForMatchWin() {
        return this.pointsForMatchWin;
    }

    public Float pointsForMatchTie() {
        return this.pointsForMatchTie;
    }

    public Float pointsForGameWin() {
        return this.pointsForGameWin;
    }

    public Float pointsForGameTie() {
        return this.pointsForGameTie;
    }

    public Float pointsForBye() {
        return this.pointsForBye;
    }

    public Integer swissRounds() {
        return this.swissRounds;
    }

    public RankedBy rankedBy() {
        return this.rankedBy;
    }

    public Float roundRobinPointsForGameWin() {
        return this.roundRobinPointsForGameWin;
    }

    public Float roundRobinPointsForGameTie() {
        return this.roundRobinPointsForGameTie;
    }

    public Float roundRobinPointsForMatchWin() {
        return this.roundRobinPointsForMatchWin;
    }

    public Float roundRobinPointsForMatchTie() {
        return this.roundRobinPointsForMatchTie;
    }

    public Boolean acceptAttachments() {
        return this.acceptAttachments;
    }

    public Boolean hideForum() {
        return this.hideForum;
    }

    public Boolean showRounds() {
        return this.showRounds;
    }

    public Boolean _private() {
        return this._private;
    }

    public Boolean notifyUsersWhenTheTournamentEnds() {
        return this.notifyUsersWhenTheTournamentEnds;
    }

    public Boolean sequentialPairings() {
        return this.sequentialPairings;
    }

    public Integer signupCap() {
        return this.signupCap;
    }

    public OffsetDateTime startAt() {
        return this.startAt;
    }

    public Integer checkInDuration() {
        return this.checkInDuration;
    }

    public Boolean allowParticipantMatchReporting() {
        return this.allowParticipantMatchReporting;
    }

    public Boolean anonymousVoting() {
        return this.anonymousVoting;
    }

    public String category() {
        return this.category;
    }

    public OffsetDateTime completedAt() {
        return this.completedAt;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public Boolean createdByApi() {
        return this.createdByApi;
    }

    public Boolean creditCapped() {
        return this.creditCapped;
    }

    public Integer gameId() {
        return this.gameId;
    }

    public Boolean groupStagesEnabled() {
        return this.groupStagesEnabled;
    }

    public Boolean hideSeeds() {
        return this.hideSeeds;
    }

    public Integer id() {
        return this.id;
    }

    public Integer maxPredictionsPerUser() {
        return this.maxPredictionsPerUser;
    }

    public Boolean notifyUsersWhenMatchesOpen() {
        return this.notifyUsersWhenMatchesOpen;
    }

    public Integer participantsCount() {
        return this.participantsCount;
    }

    public Integer predictionMethod() {
        return this.predictionMethod;
    }

    public OffsetDateTime predictionsOpenedAt() {
        return this.predictionsOpenedAt;
    }

    public Integer progressMeter() {
        return this.progressMeter;
    }

    public Boolean quickAdvance() {
        return this.quickAdvance;
    }

    public Boolean requireScoreAgreement() {
        return this.requireScoreAgreement;
    }

    public OffsetDateTime startedAt() {
        return this.startedAt;
    }

    public OffsetDateTime startedCheckingInAt() {
        return this.startedCheckingInAt;
    }

    public TournamentState state() {
        return this.state;
    }

    public Boolean teams() {
        return this.teams;
    }

    public String[] tieBreaks() {
        return this.tieBreaks;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public String descriptionSource() {
        return this.descriptionSource;
    }

    public String fullChallongeUrl() {
        return this.fullChallongeUrl;
    }

    public String liveImageUrl() {
        return this.liveImageUrl;
    }

    public String signUpUrl() {
        return this.signUpUrl;
    }

    public Boolean reviewBeforeFinalizing() {
        return this.reviewBeforeFinalizing;
    }

    public Boolean acceptingPredictions() {
        return this.acceptingPredictions;
    }

    public Boolean participantsLocked() {
        return this.participantsLocked;
    }

    public String gameName() {
        return this.gameName;
    }

    public Boolean participantsSwappable() {
        return this.participantsSwappable;
    }

    public Boolean teamConvertable() {
        return this.teamConvertable;
    }

    public Boolean groupStagesWereStarted() {
        return this.groupStagesWereStarted;
    }

    public OffsetDateTime lockedAt() {
        return this.lockedAt;
    }

    public Integer eventId() {
        return this.eventId;
    }

    public Boolean publicPredictionsBeforeStartTime() {
        return this.publicPredictionsBeforeStartTime;
    }

    public GrandFinalsModifier grandFinalsModifier() {
        return this.grandFinalsModifier;
    }

    public List<Participant> participants() {
        return this.participants;
    }

    public List<Match> matches() {
        return this.matches;
    }

    public String toString() {
        return "Tournament(name=" + this.name() + ", tournamentType=" + (Object)((Object)this.tournamentType()) + ", url=" + this.url() + ", subdomain=" + this.subdomain() + ", description=" + this.description() + ", openSignup=" + this.openSignup() + ", holdThirdPlaceMatch=" + this.holdThirdPlaceMatch() + ", pointsForMatchWin=" + this.pointsForMatchWin() + ", pointsForMatchTie=" + this.pointsForMatchTie() + ", pointsForGameWin=" + this.pointsForGameWin() + ", pointsForGameTie=" + this.pointsForGameTie() + ", pointsForBye=" + this.pointsForBye() + ", swissRounds=" + this.swissRounds() + ", rankedBy=" + (Object)((Object)this.rankedBy()) + ", roundRobinPointsForGameWin=" + this.roundRobinPointsForGameWin() + ", roundRobinPointsForGameTie=" + this.roundRobinPointsForGameTie() + ", roundRobinPointsForMatchWin=" + this.roundRobinPointsForMatchWin() + ", roundRobinPointsForMatchTie=" + this.roundRobinPointsForMatchTie() + ", acceptAttachments=" + this.acceptAttachments() + ", hideForum=" + this.hideForum() + ", showRounds=" + this.showRounds() + ", _private=" + this._private() + ", notifyUsersWhenTheTournamentEnds=" + this.notifyUsersWhenTheTournamentEnds() + ", sequentialPairings=" + this.sequentialPairings() + ", signupCap=" + this.signupCap() + ", startAt=" + this.startAt() + ", checkInDuration=" + this.checkInDuration() + ", allowParticipantMatchReporting=" + this.allowParticipantMatchReporting() + ", anonymousVoting=" + this.anonymousVoting() + ", category=" + this.category() + ", completedAt=" + this.completedAt() + ", createdAt=" + this.createdAt() + ", createdByApi=" + this.createdByApi() + ", creditCapped=" + this.creditCapped() + ", gameId=" + this.gameId() + ", groupStagesEnabled=" + this.groupStagesEnabled() + ", hideSeeds=" + this.hideSeeds() + ", id=" + this.id() + ", maxPredictionsPerUser=" + this.maxPredictionsPerUser() + ", notifyUsersWhenMatchesOpen=" + this.notifyUsersWhenMatchesOpen() + ", participantsCount=" + this.participantsCount() + ", predictionMethod=" + this.predictionMethod() + ", predictionsOpenedAt=" + this.predictionsOpenedAt() + ", progressMeter=" + this.progressMeter() + ", quickAdvance=" + this.quickAdvance() + ", requireScoreAgreement=" + this.requireScoreAgreement() + ", startedAt=" + this.startedAt() + ", startedCheckingInAt=" + this.startedCheckingInAt() + ", state=" + (Object)((Object)this.state()) + ", teams=" + this.teams() + ", tieBreaks=" + Arrays.deepToString(this.tieBreaks()) + ", updatedAt=" + this.updatedAt() + ", descriptionSource=" + this.descriptionSource() + ", fullChallongeUrl=" + this.fullChallongeUrl() + ", liveImageUrl=" + this.liveImageUrl() + ", signUpUrl=" + this.signUpUrl() + ", reviewBeforeFinalizing=" + this.reviewBeforeFinalizing() + ", acceptingPredictions=" + this.acceptingPredictions() + ", participantsLocked=" + this.participantsLocked() + ", gameName=" + this.gameName() + ", participantsSwappable=" + this.participantsSwappable() + ", teamConvertable=" + this.teamConvertable() + ", groupStagesWereStarted=" + this.groupStagesWereStarted() + ", lockedAt=" + this.lockedAt() + ", eventId=" + this.eventId() + ", publicPredictionsBeforeStartTime=" + this.publicPredictionsBeforeStartTime() + ", grandFinalsModifier=" + (Object)((Object)this.grandFinalsModifier()) + ", participants=" + this.participants() + ", matches=" + this.matches() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tournament)) {
            return false;
        }
        Tournament other = (Tournament)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TournamentType this$tournamentType = this.tournamentType();
        TournamentType other$tournamentType = other.tournamentType();
        if (this$tournamentType == null ? other$tournamentType != null : !((Object)((Object)this$tournamentType)).equals((Object)other$tournamentType)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$subdomain = this.subdomain();
        String other$subdomain = other.subdomain();
        if (this$subdomain == null ? other$subdomain != null : !this$subdomain.equals(other$subdomain)) {
            return false;
        }
        String this$description = this.description();
        String other$description = other.description();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Boolean this$openSignup = this.openSignup();
        Boolean other$openSignup = other.openSignup();
        if (this$openSignup == null ? other$openSignup != null : !((Object)this$openSignup).equals(other$openSignup)) {
            return false;
        }
        Boolean this$holdThirdPlaceMatch = this.holdThirdPlaceMatch();
        Boolean other$holdThirdPlaceMatch = other.holdThirdPlaceMatch();
        if (this$holdThirdPlaceMatch == null ? other$holdThirdPlaceMatch != null : !((Object)this$holdThirdPlaceMatch).equals(other$holdThirdPlaceMatch)) {
            return false;
        }
        Float this$pointsForMatchWin = this.pointsForMatchWin();
        Float other$pointsForMatchWin = other.pointsForMatchWin();
        if (this$pointsForMatchWin == null ? other$pointsForMatchWin != null : !((Object)this$pointsForMatchWin).equals(other$pointsForMatchWin)) {
            return false;
        }
        Float this$pointsForMatchTie = this.pointsForMatchTie();
        Float other$pointsForMatchTie = other.pointsForMatchTie();
        if (this$pointsForMatchTie == null ? other$pointsForMatchTie != null : !((Object)this$pointsForMatchTie).equals(other$pointsForMatchTie)) {
            return false;
        }
        Float this$pointsForGameWin = this.pointsForGameWin();
        Float other$pointsForGameWin = other.pointsForGameWin();
        if (this$pointsForGameWin == null ? other$pointsForGameWin != null : !((Object)this$pointsForGameWin).equals(other$pointsForGameWin)) {
            return false;
        }
        Float this$pointsForGameTie = this.pointsForGameTie();
        Float other$pointsForGameTie = other.pointsForGameTie();
        if (this$pointsForGameTie == null ? other$pointsForGameTie != null : !((Object)this$pointsForGameTie).equals(other$pointsForGameTie)) {
            return false;
        }
        Float this$pointsForBye = this.pointsForBye();
        Float other$pointsForBye = other.pointsForBye();
        if (this$pointsForBye == null ? other$pointsForBye != null : !((Object)this$pointsForBye).equals(other$pointsForBye)) {
            return false;
        }
        Integer this$swissRounds = this.swissRounds();
        Integer other$swissRounds = other.swissRounds();
        if (this$swissRounds == null ? other$swissRounds != null : !((Object)this$swissRounds).equals(other$swissRounds)) {
            return false;
        }
        RankedBy this$rankedBy = this.rankedBy();
        RankedBy other$rankedBy = other.rankedBy();
        if (this$rankedBy == null ? other$rankedBy != null : !((Object)((Object)this$rankedBy)).equals((Object)other$rankedBy)) {
            return false;
        }
        Float this$roundRobinPointsForGameWin = this.roundRobinPointsForGameWin();
        Float other$roundRobinPointsForGameWin = other.roundRobinPointsForGameWin();
        if (this$roundRobinPointsForGameWin == null ? other$roundRobinPointsForGameWin != null : !((Object)this$roundRobinPointsForGameWin).equals(other$roundRobinPointsForGameWin)) {
            return false;
        }
        Float this$roundRobinPointsForGameTie = this.roundRobinPointsForGameTie();
        Float other$roundRobinPointsForGameTie = other.roundRobinPointsForGameTie();
        if (this$roundRobinPointsForGameTie == null ? other$roundRobinPointsForGameTie != null : !((Object)this$roundRobinPointsForGameTie).equals(other$roundRobinPointsForGameTie)) {
            return false;
        }
        Float this$roundRobinPointsForMatchWin = this.roundRobinPointsForMatchWin();
        Float other$roundRobinPointsForMatchWin = other.roundRobinPointsForMatchWin();
        if (this$roundRobinPointsForMatchWin == null ? other$roundRobinPointsForMatchWin != null : !((Object)this$roundRobinPointsForMatchWin).equals(other$roundRobinPointsForMatchWin)) {
            return false;
        }
        Float this$roundRobinPointsForMatchTie = this.roundRobinPointsForMatchTie();
        Float other$roundRobinPointsForMatchTie = other.roundRobinPointsForMatchTie();
        if (this$roundRobinPointsForMatchTie == null ? other$roundRobinPointsForMatchTie != null : !((Object)this$roundRobinPointsForMatchTie).equals(other$roundRobinPointsForMatchTie)) {
            return false;
        }
        Boolean this$acceptAttachments = this.acceptAttachments();
        Boolean other$acceptAttachments = other.acceptAttachments();
        if (this$acceptAttachments == null ? other$acceptAttachments != null : !((Object)this$acceptAttachments).equals(other$acceptAttachments)) {
            return false;
        }
        Boolean this$hideForum = this.hideForum();
        Boolean other$hideForum = other.hideForum();
        if (this$hideForum == null ? other$hideForum != null : !((Object)this$hideForum).equals(other$hideForum)) {
            return false;
        }
        Boolean this$showRounds = this.showRounds();
        Boolean other$showRounds = other.showRounds();
        if (this$showRounds == null ? other$showRounds != null : !((Object)this$showRounds).equals(other$showRounds)) {
            return false;
        }
        Boolean this$_private = this._private();
        Boolean other$_private = other._private();
        if (this$_private == null ? other$_private != null : !((Object)this$_private).equals(other$_private)) {
            return false;
        }
        Boolean this$notifyUsersWhenTheTournamentEnds = this.notifyUsersWhenTheTournamentEnds();
        Boolean other$notifyUsersWhenTheTournamentEnds = other.notifyUsersWhenTheTournamentEnds();
        if (this$notifyUsersWhenTheTournamentEnds == null ? other$notifyUsersWhenTheTournamentEnds != null : !((Object)this$notifyUsersWhenTheTournamentEnds).equals(other$notifyUsersWhenTheTournamentEnds)) {
            return false;
        }
        Boolean this$sequentialPairings = this.sequentialPairings();
        Boolean other$sequentialPairings = other.sequentialPairings();
        if (this$sequentialPairings == null ? other$sequentialPairings != null : !((Object)this$sequentialPairings).equals(other$sequentialPairings)) {
            return false;
        }
        Integer this$signupCap = this.signupCap();
        Integer other$signupCap = other.signupCap();
        if (this$signupCap == null ? other$signupCap != null : !((Object)this$signupCap).equals(other$signupCap)) {
            return false;
        }
        Integer this$checkInDuration = this.checkInDuration();
        Integer other$checkInDuration = other.checkInDuration();
        if (this$checkInDuration == null ? other$checkInDuration != null : !((Object)this$checkInDuration).equals(other$checkInDuration)) {
            return false;
        }
        Boolean this$allowParticipantMatchReporting = this.allowParticipantMatchReporting();
        Boolean other$allowParticipantMatchReporting = other.allowParticipantMatchReporting();
        if (this$allowParticipantMatchReporting == null ? other$allowParticipantMatchReporting != null : !((Object)this$allowParticipantMatchReporting).equals(other$allowParticipantMatchReporting)) {
            return false;
        }
        Boolean this$anonymousVoting = this.anonymousVoting();
        Boolean other$anonymousVoting = other.anonymousVoting();
        if (this$anonymousVoting == null ? other$anonymousVoting != null : !((Object)this$anonymousVoting).equals(other$anonymousVoting)) {
            return false;
        }
        String this$category = this.category();
        String other$category = other.category();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        Boolean this$createdByApi = this.createdByApi();
        Boolean other$createdByApi = other.createdByApi();
        if (this$createdByApi == null ? other$createdByApi != null : !((Object)this$createdByApi).equals(other$createdByApi)) {
            return false;
        }
        Boolean this$creditCapped = this.creditCapped();
        Boolean other$creditCapped = other.creditCapped();
        if (this$creditCapped == null ? other$creditCapped != null : !((Object)this$creditCapped).equals(other$creditCapped)) {
            return false;
        }
        Integer this$gameId = this.gameId();
        Integer other$gameId = other.gameId();
        if (this$gameId == null ? other$gameId != null : !((Object)this$gameId).equals(other$gameId)) {
            return false;
        }
        Boolean this$groupStagesEnabled = this.groupStagesEnabled();
        Boolean other$groupStagesEnabled = other.groupStagesEnabled();
        if (this$groupStagesEnabled == null ? other$groupStagesEnabled != null : !((Object)this$groupStagesEnabled).equals(other$groupStagesEnabled)) {
            return false;
        }
        Boolean this$hideSeeds = this.hideSeeds();
        Boolean other$hideSeeds = other.hideSeeds();
        if (this$hideSeeds == null ? other$hideSeeds != null : !((Object)this$hideSeeds).equals(other$hideSeeds)) {
            return false;
        }
        Integer this$id = this.id();
        Integer other$id = other.id();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$maxPredictionsPerUser = this.maxPredictionsPerUser();
        Integer other$maxPredictionsPerUser = other.maxPredictionsPerUser();
        if (this$maxPredictionsPerUser == null ? other$maxPredictionsPerUser != null : !((Object)this$maxPredictionsPerUser).equals(other$maxPredictionsPerUser)) {
            return false;
        }
        Boolean this$notifyUsersWhenMatchesOpen = this.notifyUsersWhenMatchesOpen();
        Boolean other$notifyUsersWhenMatchesOpen = other.notifyUsersWhenMatchesOpen();
        if (this$notifyUsersWhenMatchesOpen == null ? other$notifyUsersWhenMatchesOpen != null : !((Object)this$notifyUsersWhenMatchesOpen).equals(other$notifyUsersWhenMatchesOpen)) {
            return false;
        }
        Integer this$participantsCount = this.participantsCount();
        Integer other$participantsCount = other.participantsCount();
        if (this$participantsCount == null ? other$participantsCount != null : !((Object)this$participantsCount).equals(other$participantsCount)) {
            return false;
        }
        Integer this$predictionMethod = this.predictionMethod();
        Integer other$predictionMethod = other.predictionMethod();
        if (this$predictionMethod == null ? other$predictionMethod != null : !((Object)this$predictionMethod).equals(other$predictionMethod)) {
            return false;
        }
        Integer this$progressMeter = this.progressMeter();
        Integer other$progressMeter = other.progressMeter();
        if (this$progressMeter == null ? other$progressMeter != null : !((Object)this$progressMeter).equals(other$progressMeter)) {
            return false;
        }
        Boolean this$quickAdvance = this.quickAdvance();
        Boolean other$quickAdvance = other.quickAdvance();
        if (this$quickAdvance == null ? other$quickAdvance != null : !((Object)this$quickAdvance).equals(other$quickAdvance)) {
            return false;
        }
        Boolean this$requireScoreAgreement = this.requireScoreAgreement();
        Boolean other$requireScoreAgreement = other.requireScoreAgreement();
        if (this$requireScoreAgreement == null ? other$requireScoreAgreement != null : !((Object)this$requireScoreAgreement).equals(other$requireScoreAgreement)) {
            return false;
        }
        TournamentState this$state = this.state();
        TournamentState other$state = other.state();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Boolean this$teams = this.teams();
        Boolean other$teams = other.teams();
        if (this$teams == null ? other$teams != null : !((Object)this$teams).equals(other$teams)) {
            return false;
        }
        if (!Arrays.deepEquals(this.tieBreaks(), other.tieBreaks())) {
            return false;
        }
        String this$descriptionSource = this.descriptionSource();
        String other$descriptionSource = other.descriptionSource();
        if (this$descriptionSource == null ? other$descriptionSource != null : !this$descriptionSource.equals(other$descriptionSource)) {
            return false;
        }
        String this$fullChallongeUrl = this.fullChallongeUrl();
        String other$fullChallongeUrl = other.fullChallongeUrl();
        if (this$fullChallongeUrl == null ? other$fullChallongeUrl != null : !this$fullChallongeUrl.equals(other$fullChallongeUrl)) {
            return false;
        }
        String this$liveImageUrl = this.liveImageUrl();
        String other$liveImageUrl = other.liveImageUrl();
        if (this$liveImageUrl == null ? other$liveImageUrl != null : !this$liveImageUrl.equals(other$liveImageUrl)) {
            return false;
        }
        String this$signUpUrl = this.signUpUrl();
        String other$signUpUrl = other.signUpUrl();
        if (this$signUpUrl == null ? other$signUpUrl != null : !this$signUpUrl.equals(other$signUpUrl)) {
            return false;
        }
        Boolean this$reviewBeforeFinalizing = this.reviewBeforeFinalizing();
        Boolean other$reviewBeforeFinalizing = other.reviewBeforeFinalizing();
        if (this$reviewBeforeFinalizing == null ? other$reviewBeforeFinalizing != null : !((Object)this$reviewBeforeFinalizing).equals(other$reviewBeforeFinalizing)) {
            return false;
        }
        Boolean this$acceptingPredictions = this.acceptingPredictions();
        Boolean other$acceptingPredictions = other.acceptingPredictions();
        if (this$acceptingPredictions == null ? other$acceptingPredictions != null : !((Object)this$acceptingPredictions).equals(other$acceptingPredictions)) {
            return false;
        }
        Boolean this$participantsLocked = this.participantsLocked();
        Boolean other$participantsLocked = other.participantsLocked();
        if (this$participantsLocked == null ? other$participantsLocked != null : !((Object)this$participantsLocked).equals(other$participantsLocked)) {
            return false;
        }
        String this$gameName = this.gameName();
        String other$gameName = other.gameName();
        if (this$gameName == null ? other$gameName != null : !this$gameName.equals(other$gameName)) {
            return false;
        }
        Boolean this$participantsSwappable = this.participantsSwappable();
        Boolean other$participantsSwappable = other.participantsSwappable();
        if (this$participantsSwappable == null ? other$participantsSwappable != null : !((Object)this$participantsSwappable).equals(other$participantsSwappable)) {
            return false;
        }
        Boolean this$teamConvertable = this.teamConvertable();
        Boolean other$teamConvertable = other.teamConvertable();
        if (this$teamConvertable == null ? other$teamConvertable != null : !((Object)this$teamConvertable).equals(other$teamConvertable)) {
            return false;
        }
        Boolean this$groupStagesWereStarted = this.groupStagesWereStarted();
        Boolean other$groupStagesWereStarted = other.groupStagesWereStarted();
        if (this$groupStagesWereStarted == null ? other$groupStagesWereStarted != null : !((Object)this$groupStagesWereStarted).equals(other$groupStagesWereStarted)) {
            return false;
        }
        Integer this$eventId = this.eventId();
        Integer other$eventId = other.eventId();
        if (this$eventId == null ? other$eventId != null : !((Object)this$eventId).equals(other$eventId)) {
            return false;
        }
        Boolean this$publicPredictionsBeforeStartTime = this.publicPredictionsBeforeStartTime();
        Boolean other$publicPredictionsBeforeStartTime = other.publicPredictionsBeforeStartTime();
        if (this$publicPredictionsBeforeStartTime == null ? other$publicPredictionsBeforeStartTime != null : !((Object)this$publicPredictionsBeforeStartTime).equals(other$publicPredictionsBeforeStartTime)) {
            return false;
        }
        GrandFinalsModifier this$grandFinalsModifier = this.grandFinalsModifier();
        GrandFinalsModifier other$grandFinalsModifier = other.grandFinalsModifier();
        if (this$grandFinalsModifier == null ? other$grandFinalsModifier != null : !((Object)((Object)this$grandFinalsModifier)).equals((Object)other$grandFinalsModifier)) {
            return false;
        }
        List<Participant> this$participants = this.participants();
        List<Participant> other$participants = other.participants();
        if (this$participants == null ? other$participants != null : !((Object)this$participants).equals(other$participants)) {
            return false;
        }
        List<Match> this$matches = this.matches();
        List<Match> other$matches = other.matches();
        return !(this$matches == null ? other$matches != null : !((Object)this$matches).equals(other$matches));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tournament;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TournamentType $tournamentType = this.tournamentType();
        result = result * 59 + ($tournamentType == null ? 43 : ((Object)((Object)$tournamentType)).hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $subdomain = this.subdomain();
        result = result * 59 + ($subdomain == null ? 43 : $subdomain.hashCode());
        String $description = this.description();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Boolean $openSignup = this.openSignup();
        result = result * 59 + ($openSignup == null ? 43 : ((Object)$openSignup).hashCode());
        Boolean $holdThirdPlaceMatch = this.holdThirdPlaceMatch();
        result = result * 59 + ($holdThirdPlaceMatch == null ? 43 : ((Object)$holdThirdPlaceMatch).hashCode());
        Float $pointsForMatchWin = this.pointsForMatchWin();
        result = result * 59 + ($pointsForMatchWin == null ? 43 : ((Object)$pointsForMatchWin).hashCode());
        Float $pointsForMatchTie = this.pointsForMatchTie();
        result = result * 59 + ($pointsForMatchTie == null ? 43 : ((Object)$pointsForMatchTie).hashCode());
        Float $pointsForGameWin = this.pointsForGameWin();
        result = result * 59 + ($pointsForGameWin == null ? 43 : ((Object)$pointsForGameWin).hashCode());
        Float $pointsForGameTie = this.pointsForGameTie();
        result = result * 59 + ($pointsForGameTie == null ? 43 : ((Object)$pointsForGameTie).hashCode());
        Float $pointsForBye = this.pointsForBye();
        result = result * 59 + ($pointsForBye == null ? 43 : ((Object)$pointsForBye).hashCode());
        Integer $swissRounds = this.swissRounds();
        result = result * 59 + ($swissRounds == null ? 43 : ((Object)$swissRounds).hashCode());
        RankedBy $rankedBy = this.rankedBy();
        result = result * 59 + ($rankedBy == null ? 43 : ((Object)((Object)$rankedBy)).hashCode());
        Float $roundRobinPointsForGameWin = this.roundRobinPointsForGameWin();
        result = result * 59 + ($roundRobinPointsForGameWin == null ? 43 : ((Object)$roundRobinPointsForGameWin).hashCode());
        Float $roundRobinPointsForGameTie = this.roundRobinPointsForGameTie();
        result = result * 59 + ($roundRobinPointsForGameTie == null ? 43 : ((Object)$roundRobinPointsForGameTie).hashCode());
        Float $roundRobinPointsForMatchWin = this.roundRobinPointsForMatchWin();
        result = result * 59 + ($roundRobinPointsForMatchWin == null ? 43 : ((Object)$roundRobinPointsForMatchWin).hashCode());
        Float $roundRobinPointsForMatchTie = this.roundRobinPointsForMatchTie();
        result = result * 59 + ($roundRobinPointsForMatchTie == null ? 43 : ((Object)$roundRobinPointsForMatchTie).hashCode());
        Boolean $acceptAttachments = this.acceptAttachments();
        result = result * 59 + ($acceptAttachments == null ? 43 : ((Object)$acceptAttachments).hashCode());
        Boolean $hideForum = this.hideForum();
        result = result * 59 + ($hideForum == null ? 43 : ((Object)$hideForum).hashCode());
        Boolean $showRounds = this.showRounds();
        result = result * 59 + ($showRounds == null ? 43 : ((Object)$showRounds).hashCode());
        Boolean $_private = this._private();
        result = result * 59 + ($_private == null ? 43 : ((Object)$_private).hashCode());
        Boolean $notifyUsersWhenTheTournamentEnds = this.notifyUsersWhenTheTournamentEnds();
        result = result * 59 + ($notifyUsersWhenTheTournamentEnds == null ? 43 : ((Object)$notifyUsersWhenTheTournamentEnds).hashCode());
        Boolean $sequentialPairings = this.sequentialPairings();
        result = result * 59 + ($sequentialPairings == null ? 43 : ((Object)$sequentialPairings).hashCode());
        Integer $signupCap = this.signupCap();
        result = result * 59 + ($signupCap == null ? 43 : ((Object)$signupCap).hashCode());
        Integer $checkInDuration = this.checkInDuration();
        result = result * 59 + ($checkInDuration == null ? 43 : ((Object)$checkInDuration).hashCode());
        Boolean $allowParticipantMatchReporting = this.allowParticipantMatchReporting();
        result = result * 59 + ($allowParticipantMatchReporting == null ? 43 : ((Object)$allowParticipantMatchReporting).hashCode());
        Boolean $anonymousVoting = this.anonymousVoting();
        result = result * 59 + ($anonymousVoting == null ? 43 : ((Object)$anonymousVoting).hashCode());
        String $category = this.category();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        Boolean $createdByApi = this.createdByApi();
        result = result * 59 + ($createdByApi == null ? 43 : ((Object)$createdByApi).hashCode());
        Boolean $creditCapped = this.creditCapped();
        result = result * 59 + ($creditCapped == null ? 43 : ((Object)$creditCapped).hashCode());
        Integer $gameId = this.gameId();
        result = result * 59 + ($gameId == null ? 43 : ((Object)$gameId).hashCode());
        Boolean $groupStagesEnabled = this.groupStagesEnabled();
        result = result * 59 + ($groupStagesEnabled == null ? 43 : ((Object)$groupStagesEnabled).hashCode());
        Boolean $hideSeeds = this.hideSeeds();
        result = result * 59 + ($hideSeeds == null ? 43 : ((Object)$hideSeeds).hashCode());
        Integer $id = this.id();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $maxPredictionsPerUser = this.maxPredictionsPerUser();
        result = result * 59 + ($maxPredictionsPerUser == null ? 43 : ((Object)$maxPredictionsPerUser).hashCode());
        Boolean $notifyUsersWhenMatchesOpen = this.notifyUsersWhenMatchesOpen();
        result = result * 59 + ($notifyUsersWhenMatchesOpen == null ? 43 : ((Object)$notifyUsersWhenMatchesOpen).hashCode());
        Integer $participantsCount = this.participantsCount();
        result = result * 59 + ($participantsCount == null ? 43 : ((Object)$participantsCount).hashCode());
        Integer $predictionMethod = this.predictionMethod();
        result = result * 59 + ($predictionMethod == null ? 43 : ((Object)$predictionMethod).hashCode());
        Integer $progressMeter = this.progressMeter();
        result = result * 59 + ($progressMeter == null ? 43 : ((Object)$progressMeter).hashCode());
        Boolean $quickAdvance = this.quickAdvance();
        result = result * 59 + ($quickAdvance == null ? 43 : ((Object)$quickAdvance).hashCode());
        Boolean $requireScoreAgreement = this.requireScoreAgreement();
        result = result * 59 + ($requireScoreAgreement == null ? 43 : ((Object)$requireScoreAgreement).hashCode());
        TournamentState $state = this.state();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Boolean $teams = this.teams();
        result = result * 59 + ($teams == null ? 43 : ((Object)$teams).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.tieBreaks());
        String $descriptionSource = this.descriptionSource();
        result = result * 59 + ($descriptionSource == null ? 43 : $descriptionSource.hashCode());
        String $fullChallongeUrl = this.fullChallongeUrl();
        result = result * 59 + ($fullChallongeUrl == null ? 43 : $fullChallongeUrl.hashCode());
        String $liveImageUrl = this.liveImageUrl();
        result = result * 59 + ($liveImageUrl == null ? 43 : $liveImageUrl.hashCode());
        String $signUpUrl = this.signUpUrl();
        result = result * 59 + ($signUpUrl == null ? 43 : $signUpUrl.hashCode());
        Boolean $reviewBeforeFinalizing = this.reviewBeforeFinalizing();
        result = result * 59 + ($reviewBeforeFinalizing == null ? 43 : ((Object)$reviewBeforeFinalizing).hashCode());
        Boolean $acceptingPredictions = this.acceptingPredictions();
        result = result * 59 + ($acceptingPredictions == null ? 43 : ((Object)$acceptingPredictions).hashCode());
        Boolean $participantsLocked = this.participantsLocked();
        result = result * 59 + ($participantsLocked == null ? 43 : ((Object)$participantsLocked).hashCode());
        String $gameName = this.gameName();
        result = result * 59 + ($gameName == null ? 43 : $gameName.hashCode());
        Boolean $participantsSwappable = this.participantsSwappable();
        result = result * 59 + ($participantsSwappable == null ? 43 : ((Object)$participantsSwappable).hashCode());
        Boolean $teamConvertable = this.teamConvertable();
        result = result * 59 + ($teamConvertable == null ? 43 : ((Object)$teamConvertable).hashCode());
        Boolean $groupStagesWereStarted = this.groupStagesWereStarted();
        result = result * 59 + ($groupStagesWereStarted == null ? 43 : ((Object)$groupStagesWereStarted).hashCode());
        Integer $eventId = this.eventId();
        result = result * 59 + ($eventId == null ? 43 : ((Object)$eventId).hashCode());
        Boolean $publicPredictionsBeforeStartTime = this.publicPredictionsBeforeStartTime();
        result = result * 59 + ($publicPredictionsBeforeStartTime == null ? 43 : ((Object)$publicPredictionsBeforeStartTime).hashCode());
        GrandFinalsModifier $grandFinalsModifier = this.grandFinalsModifier();
        result = result * 59 + ($grandFinalsModifier == null ? 43 : ((Object)((Object)$grandFinalsModifier)).hashCode());
        List<Participant> $participants = this.participants();
        result = result * 59 + ($participants == null ? 43 : ((Object)$participants).hashCode());
        List<Match> $matches = this.matches();
        result = result * 59 + ($matches == null ? 43 : ((Object)$matches).hashCode());
        return result;
    }
}

