/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.block;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.common.UInt256;
import com.github.DNAProject.core.Inventory;
import com.github.DNAProject.core.InventoryType;
import com.github.DNAProject.core.payload.Bookkeeping;
import com.github.DNAProject.core.payload.DeployCode;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;

public class Block
extends Inventory {
    public int version;
    public UInt256 prevBlockHash;
    public UInt256 transactionsRoot;
    public UInt256 blockRoot;
    public int timestamp;
    public int height;
    public long consensusData;
    public byte[] consensusPayload;
    public Address nextBookkeeper;
    public String[] sigData;
    public byte[][] bookkeepers;
    public Transaction[] transactions;
    public UInt256 hash;
    private Block _header = null;

    public Block header() {
        if (this.isHeader()) {
            return this;
        }
        if (this._header == null) {
            this._header = new Block();
            this._header.prevBlockHash = this.prevBlockHash;
            this._header.transactionsRoot = this.transactionsRoot;
            this._header.blockRoot = this.blockRoot;
            this._header.timestamp = this.timestamp;
            this._header.height = this.height;
            this._header.consensusData = this.consensusData;
            this._header.nextBookkeeper = this.nextBookkeeper;
            this._header.sigData = this.sigData;
            this._header.bookkeepers = this.bookkeepers;
            this._header.transactions = new Transaction[0];
        }
        return this._header;
    }

    @Override
    public InventoryType inventoryType() {
        return InventoryType.Block;
    }

    public boolean isHeader() {
        return this.transactions.length == 0;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        int i;
        this.deserializeUnsigned(reader);
        int len = (int)reader.readVarInt();
        this.sigData = new String[len];
        for (i = 0; i < len; ++i) {
            this.sigData[i] = Helper.toHexString(reader.readVarBytes());
        }
        len = reader.readInt();
        this.transactions = new Transaction[len];
        for (i = 0; i < this.transactions.length; ++i) {
            this.transactions[i] = Transaction.deserializeFrom(reader);
        }
    }

    @Override
    public void deserializeUnsigned(BinaryReader reader) throws IOException {
        try {
            this.version = reader.readInt();
            this.prevBlockHash = reader.readSerializable(UInt256.class);
            this.transactionsRoot = reader.readSerializable(UInt256.class);
            this.blockRoot = reader.readSerializable(UInt256.class);
            this.timestamp = reader.readInt();
            this.height = reader.readInt();
            this.consensusData = reader.readLong();
            this.consensusPayload = reader.readVarBytes();
            this.nextBookkeeper = reader.readSerializable(Address.class);
            int len = (int)reader.readVarInt();
            this.bookkeepers = new byte[len][];
            for (int i = 0; i < len; ++i) {
                this.bookkeepers[i] = reader.readVarBytes();
            }
            this.transactions = new Transaction[0];
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        int i;
        this.serializeUnsigned(writer);
        writer.writeVarInt(this.bookkeepers.length);
        for (i = 0; i < this.bookkeepers.length; ++i) {
            writer.writeVarBytes(this.bookkeepers[i]);
        }
        writer.writeVarInt(this.sigData.length);
        for (i = 0; i < this.sigData.length; ++i) {
            writer.writeVarBytes(Helper.hexToBytes(this.sigData[i]));
        }
        writer.writeInt(this.transactions.length);
        for (i = 0; i < this.transactions.length; ++i) {
            writer.writeSerializable(this.transactions[i]);
        }
    }

    @Override
    public void serializeUnsigned(BinaryWriter writer) throws IOException {
        writer.writeInt(this.version);
        writer.writeSerializable(this.prevBlockHash);
        writer.writeSerializable(this.transactionsRoot);
        writer.writeSerializable(this.blockRoot);
        writer.writeInt(this.timestamp);
        writer.writeInt(this.height);
        writer.writeLong(this.consensusData);
        writer.writeVarBytes(this.consensusPayload);
        writer.writeSerializable(this.nextBookkeeper);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        return this.hash().equals(((Block)obj).hash());
    }

    public int hashCode() {
        return this.hash().hashCode();
    }

    @Override
    public Address[] getAddressU160ForVerifying() {
        return null;
    }

    public Object json() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, Object> head = new HashMap<String, Object>();
        json.put("Hash", this.hash().toString());
        head.put("Version", this.version);
        head.put("PrevBlockHash", this.prevBlockHash.toString());
        head.put("TransactionsRoot", this.transactionsRoot.toString());
        head.put("BlockRoot", this.blockRoot.toString());
        head.put("Timestamp", this.timestamp);
        head.put("Height", this.height);
        head.put("ConsensusData", this.consensusData & Long.MAX_VALUE);
        head.put("NextBookkeeper", this.nextBookkeeper.toBase58());
        head.put("Hash", this.hash().toString());
        head.put("SigData", Arrays.stream(this.sigData).toArray(Object[]::new));
        head.put("Bookkeepers", Arrays.stream(this.bookkeepers).map(p -> Helper.toHexString(p)).toArray(Object[]::new));
        json.put("Header", head);
        json.put("Transactions", Arrays.stream(this.transactions).map(p -> {
            if (p instanceof InvokeCode) {
                return ((InvokeCode)p).json();
            }
            if (p instanceof DeployCode) {
                return ((DeployCode)p).json();
            }
            if (p instanceof Bookkeeping) {
                return ((Bookkeeping)p).json();
            }
            return p.json();
        }).toArray(Object[]::new));
        return JSON.toJSONString(json);
    }

    /*
     * Exception decompiling
     */
    public byte[] trim() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Block fromTrimmedData(byte[] data, int index, Function<UInt256, Transaction> txSelector) throws IOException {
        Block block = new Block();
        try (ByteArrayInputStream ms = new ByteArrayInputStream(data, index, data.length - index);){
            try (BinaryReader reader = new BinaryReader(ms);){
                block.deserializeUnsigned(reader);
                reader.readByte();
                if (txSelector == null) {
                    block.transactions = new Transaction[0];
                } else {
                    block.transactions = new Transaction[(int)reader.readVarInt(0x10000000L)];
                    for (int i = 0; i < block.transactions.length; ++i) {
                        block.transactions[i] = txSelector.apply(reader.readSerializable(UInt256.class));
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IOException(ex);
            }
        }
        return block;
    }

    @Override
    public boolean verify() {
        return true;
    }

    private static /* synthetic */ Serializable[] lambda$trim$6(int x$0) {
        return new Serializable[x$0];
    }

    private static /* synthetic */ UInt256 lambda$trim$5(Transaction p) {
        return p.hash();
    }
}

