/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.payload;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.payload.BookkeeperAction;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.core.transaction.TransactionType;
import com.github.DNAProject.crypto.ECC;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;

public class Bookkeeper
extends Transaction {
    public ECPoint issuer;
    public BookkeeperAction action;
    public byte[] cert;

    public Bookkeeper() {
        super(TransactionType.Bookkeeper);
    }

    @Override
    protected void deserializeExclusiveData(BinaryReader reader) throws IOException {
        this.issuer = ECC.secp256r1.getCurve().createPoint(new BigInteger(1, reader.readVarBytes()), new BigInteger(1, reader.readVarBytes()));
        this.action = BookkeeperAction.valueOf(reader.readByte());
        this.cert = reader.readVarBytes();
    }

    @Override
    public Address[] getAddressU160ForVerifying() {
        return null;
    }

    @Override
    protected void serializeExclusiveData(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(Helper.removePrevZero(this.issuer.getXCoord().toBigInteger().toByteArray()));
        writer.writeVarBytes(Helper.removePrevZero(this.issuer.getYCoord().toBigInteger().toByteArray()));
        writer.writeByte(this.action.value());
        writer.writeVarBytes(this.cert);
    }
}

