/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto;

import com.github.DNAProject.crypto.Digest;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AES {
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS7Padding";

    public static byte[] decrypt(byte[] encryptedData, byte[] key, byte[] iv) throws IllegalBlockSizeException, BadPaddingException {
        if (key.length != 32 || iv.length != 16) {
            throw new IllegalArgumentException();
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
            AlgorithmParameters params = AlgorithmParameters.getInstance(KEY_ALGORITHM);
            params.init(new IvParameterSpec(iv));
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM, "BC");
            cipher.init(2, (Key)secretKey, params);
            return cipher.doFinal(encryptedData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidParameterSpecException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] encrypt(byte[] data, byte[] key, byte[] iv) {
        if (key.length != 32 || iv.length != 16) {
            throw new IllegalArgumentException();
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
            AlgorithmParameters params = AlgorithmParameters.getInstance(KEY_ALGORITHM);
            params.init(new IvParameterSpec(iv));
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM, "BC");
            cipher.init(1, (Key)secretKey, params);
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] generateIV() {
        byte[] iv = new byte[16];
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(iv);
        return iv;
    }

    public static byte[] generateKey() {
        Destroyable key = null;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
            keyGenerator.init(256);
            key = keyGenerator.generateKey();
            byte[] byArray = key.getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (key != null) {
                try {
                    key.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {}
            }
        }
    }

    public static byte[] generateKey(String password) {
        byte[] passwordBytes = null;
        byte[] passwordHash = null;
        try {
            passwordBytes = password.getBytes("UTF-8");
            byte[] byArray = Digest.hash256(passwordBytes);
            return byArray;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (passwordBytes != null) {
                Arrays.fill(passwordBytes, (byte)0);
            }
            if (passwordHash != null) {
                Arrays.fill(passwordHash, (byte)0);
            }
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

