/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.crypto.SignatureScheme;
import com.github.DNAProject.sdk.exception.SDKException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;

public class Signature {
    private SignatureScheme scheme;
    private AlgorithmParameterSpec param;
    private byte[] value;

    public Signature(SignatureScheme scheme, AlgorithmParameterSpec param, byte[] signature) {
        this.scheme = scheme;
        this.param = param;
        this.value = signature;
    }

    public Signature(byte[] data) throws Exception {
        if (data == null) {
            throw new SDKException(ErrorCode.ParamError);
        }
        if (data.length < 2) {
            throw new Exception(ErrorCode.InvalidSignatureDataLen);
        }
        this.scheme = SignatureScheme.values()[data[0]];
        if (this.scheme == SignatureScheme.SM3WITHSM2) {
            int i;
            for (i = 0; i < data.length && data[i] != 0; ++i) {
            }
            if (i >= data.length) {
                throw new Exception(ErrorCode.InvalidSignatureData);
            }
            this.param = new SM2ParameterSpec(Arrays.copyOfRange(data, 1, i));
            this.value = Arrays.copyOfRange(data, i + 1, data.length);
        } else {
            this.value = Arrays.copyOfRange(data, 1, data.length);
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            bs.write((byte)this.scheme.ordinal());
            if (this.scheme == SignatureScheme.SM3WITHSM2) {
                bs.write(((SM2ParameterSpec)this.param).getID());
                bs.write(0);
            }
            bs.write(this.value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bs.toByteArray();
    }

    public SignatureScheme getScheme() {
        return this.scheme;
    }

    public byte[] getValue() {
        return this.value;
    }
}

