/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto.bip32;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.crypto.Digest;
import com.github.DNAProject.crypto.bip32.Network;
import com.github.DNAProject.crypto.bip32.Secp256r1SC;
import com.github.DNAProject.crypto.bip32.Serializer;
import com.github.DNAProject.sdk.exception.SDKException;
import io.github.novacrypto.hashing.Sha256;
import java.math.BigInteger;
import java.util.Arrays;

public class HdKey {
    private final boolean neutered;
    private final Network network;
    private final byte[] chainCode;
    private final byte[] key;
    private final Serializer serializer;
    private final int parentFingerprint;
    private final int childNumber;
    private final int depth;

    private HdKey(Builder builder) {
        this.neutered = builder.neutered;
        this.network = builder.network;
        this.key = builder.key;
        this.parentFingerprint = builder.parentFingerprint;
        this.childNumber = builder.childNumber;
        this.chainCode = builder.chainCode;
        this.depth = builder.depth;
        this.serializer = new Serializer.Builder().network(builder.network).neutered(builder.neutered).depth(builder.depth).childNumber(builder.childNumber).fingerprint(builder.parentFingerprint).build();
    }

    static BigInteger parse256(byte[] bytes) {
        return new BigInteger(1, bytes);
    }

    static void ser256(byte[] target, BigInteger integer) {
        if (integer.bitLength() > target.length * 8) {
            throw new RuntimeException("ser256 failed, cannot fit integer in buffer");
        }
        byte[] modArr = integer.toByteArray();
        Arrays.fill(target, (byte)0);
        HdKey.copyTail(modArr, target);
        Arrays.fill(modArr, (byte)0);
    }

    private static void copyTail(byte[] src, byte[] dest) {
        if (src.length < dest.length) {
            System.arraycopy(src, 0, dest, dest.length - src.length, src.length);
        } else {
            System.arraycopy(src, src.length - dest.length, dest, 0, dest.length);
        }
    }

    byte[] serialize() {
        return this.serializer.serialize(this.key, this.chainCode);
    }

    byte[] getPoint() {
        return Secp256r1SC.pointSerP_gMultiply(HdKey.parse256(this.key));
    }

    byte[] getKey() {
        return this.key;
    }

    boolean getNeutered() {
        return this.neutered;
    }

    int getParentFingerprint() {
        return this.parentFingerprint;
    }

    int calculateFingerPrint() {
        byte[] point = this.getPublicBuffer();
        byte[] o = Digest.hash160(point);
        return (o[0] & 0xFF) << 24 | (o[1] & 0xFF) << 16 | (o[2] & 0xFF) << 8 | o[3] & 0xFF;
    }

    static void confirmHdKeyChecksum(byte[] extendedKeyData) throws SDKException {
        byte[] checkSum = HdKey.checksum(extendedKeyData);
        for (int i = 0; i < 4; ++i) {
            if (extendedKeyData[78 + i] == checkSum[i]) continue;
            throw new SDKException(ErrorCode.OtherError("Checksum error"));
        }
    }

    static byte[] checksum(byte[] privateKey) {
        return Sha256.sha256Twice((byte[])privateKey, (int)0, (int)78);
    }

    private byte[] getPublicBuffer() {
        return this.neutered ? this.key : this.getPoint();
    }

    public int depth() {
        return this.depth;
    }

    Network getNetwork() {
        return this.network;
    }

    byte[] getChainCode() {
        return this.chainCode;
    }

    int getChildNumber() {
        return this.childNumber;
    }

    Builder toBuilder() {
        return new Builder().neutered(this.neutered).chainCode(this.chainCode).key(this.key).depth(this.depth).childNumber(this.childNumber).parentFingerprint(this.parentFingerprint);
    }

    static class Builder {
        private Network network;
        private boolean neutered;
        private byte[] chainCode;
        private byte[] key;
        private int depth;
        private int childNumber;
        private int parentFingerprint;

        Builder() {
        }

        Builder network(Network network) {
            this.network = network;
            return this;
        }

        Builder neutered(boolean neutered) {
            this.neutered = neutered;
            return this;
        }

        Builder key(byte[] key) {
            this.key = key;
            return this;
        }

        Builder chainCode(byte[] chainCode) {
            this.chainCode = chainCode;
            return this;
        }

        Builder depth(int depth) {
            this.depth = depth;
            return this;
        }

        Builder childNumber(int childNumber) {
            this.childNumber = childNumber;
            return this;
        }

        Builder parentFingerprint(int parentFingerprint) {
            this.parentFingerprint = parentFingerprint;
            return this;
        }

        HdKey build() {
            return new HdKey(this);
        }
    }
}

