/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto.bip32;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.crypto.Base58;
import com.github.DNAProject.crypto.Curve;
import com.github.DNAProject.crypto.Digest;
import com.github.DNAProject.crypto.bip32.Bitcoin;
import com.github.DNAProject.crypto.bip32.ByteArrayWriter;
import com.github.DNAProject.crypto.bip32.CKDpriv;
import com.github.DNAProject.crypto.bip32.CKDpub;
import com.github.DNAProject.crypto.bip32.Deserializer;
import com.github.DNAProject.crypto.bip32.HdKey;
import com.github.DNAProject.crypto.bip32.HdPrivateKeyDeserializer;
import com.github.DNAProject.crypto.bip32.HdPublicKey;
import com.github.DNAProject.crypto.bip32.Network;
import com.github.DNAProject.crypto.bip32.Secp256r1SC;
import com.github.DNAProject.crypto.bip32.derivation.CharSequenceDerivation;
import com.github.DNAProject.crypto.bip32.derivation.CkdFunction;
import com.github.DNAProject.crypto.bip32.derivation.CkdFunctionDerive;
import com.github.DNAProject.crypto.bip32.derivation.Derivation;
import com.github.DNAProject.crypto.bip32.derivation.Derive;
import com.github.DNAProject.sdk.exception.SDKException;
import io.github.novacrypto.bip39.SeedCalculator;
import io.github.novacrypto.bip39.WordList;
import io.github.novacrypto.bip39.wordlists.English;
import io.github.novacrypto.toruntime.CheckedExceptionToRuntime;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;

public class HdPrivateKey
implements Derive<HdPrivateKey>,
CKDpriv,
CKDpub {
    private static final byte[] BITCOIN_SEED = "Bitcoin seed".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SEED_NAME = "Nist256p1 seed".getBytes(StandardCharsets.UTF_8);
    private static final CkdFunction<HdPrivateKey> CKD_FUNCTION = HdPrivateKey::cKDpriv;
    private final HdKey hdKey;

    private static Deserializer<HdPrivateKey> deserializer() {
        return HdPrivateKeyDeserializer.DEFAULT;
    }

    public static Deserializer<HdPrivateKey> deserializer(Network network) {
        return new HdPrivateKeyDeserializer(network);
    }

    public static HdPrivateKey masterKeyFromMnemonic(String code, String passphrase) {
        byte[] seed = new SeedCalculator().withWordsFromWordList((WordList)English.INSTANCE).calculateSeed(Arrays.asList(code.split(" ")), passphrase);
        return HdPrivateKey.fromSeed(seed, SEED_NAME, Bitcoin.MAIN_NET);
    }

    public static HdPrivateKey masterKeyFromMnemonic(String code) {
        return HdPrivateKey.masterKeyFromMnemonic(code, "");
    }

    public String toHexString() {
        return Helper.toHexString(this.hdKey.getKey());
    }

    public byte[] getPrivateKey() {
        return this.hdKey.getKey();
    }

    public Address getAddress() throws Exception {
        return this.getHdPublicKey().getAddress();
    }

    public HdPublicKey getHdPublicKey() throws Exception {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)((String)(new Object[]{Curve.P256.toString()})[0]));
        ECPoint Q = spec.getG().multiply(new BigInteger(1, this.getPrivateKey())).normalize();
        if (Q == null || Q.getAffineXCoord() == null || Q.getAffineYCoord() == null) {
            throw new SDKException(ErrorCode.OtherError("normalize error"));
        }
        return new HdPublicKey(new HdKey.Builder().network(this.hdKey.getNetwork()).neutered(true).key(Q.getEncoded(true)).parentFingerprint(this.hdKey.getParentFingerprint()).depth(this.hdKey.depth()).childNumber(this.hdKey.getChildNumber()).chainCode(this.hdKey.getChainCode()).build());
    }

    private HdPrivateKey(Network network, byte[] key, byte[] chainCode) {
        this(new HdKey.Builder().network(network).neutered(false).key(key).chainCode(chainCode).depth(0).childNumber(0).parentFingerprint(0).build());
    }

    public HdPrivateKey(HdKey hdKey) {
        this.hdKey = hdKey;
    }

    public static HdPrivateKey fromSeed(byte[] seed, Network network) {
        byte[] I = Digest.hmacSha512(BITCOIN_SEED, seed);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        return new HdPrivateKey(network, Il, Ir);
    }

    public static HdPrivateKey fromSeed(byte[] seed, byte[] byteKey, Network network) {
        byte[] I = Digest.hmacSha512(byteKey, seed);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        return new HdPrivateKey(network, Il, Ir);
    }

    private static byte[] getBytes(final String seed) {
        return (byte[])CheckedExceptionToRuntime.toRuntime((CheckedExceptionToRuntime.Func)new CheckedExceptionToRuntime.Func<byte[]>(){

            public byte[] run() throws Exception {
                return seed.getBytes(StandardCharsets.UTF_8);
            }
        });
    }

    public static HdPrivateKey base58Decode(String key) throws SDKException {
        return HdPrivateKey.deserializer().deserialize(Base58.decode(key));
    }

    @Override
    public HdPrivateKey cKDpriv(int index) {
        byte[] data = new byte[37];
        ByteArrayWriter writer = new ByteArrayWriter(data);
        HdKey parent = this.hdKey;
        if (CharSequenceDerivation.isHardened(index)) {
            writer.concat((byte)0);
            writer.concat(parent.getKey(), 32);
        } else {
            writer.concat(parent.getPoint());
        }
        writer.concatSer32(index);
        byte[] I = Digest.hmacSha512(parent.getChainCode(), data);
        Arrays.fill(data, (byte)0);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        byte[] key = parent.getKey();
        BigInteger parse256_Il = HdKey.parse256(Il);
        BigInteger ki = parse256_Il.add(HdKey.parse256(key)).mod(Secp256r1SC.n());
        if (parse256_Il.compareTo(Secp256r1SC.n()) >= 0 || ki.equals(BigInteger.ZERO)) {
            return this.cKDpriv(index + 1);
        }
        HdKey.ser256(Il, ki);
        return new HdPrivateKey(new HdKey.Builder().network(parent.getNetwork()).neutered(false).key(Il).chainCode(Ir).depth(parent.depth() + 1).childNumber(index).parentFingerprint(parent.calculateFingerPrint()).build());
    }

    @Override
    public HdPublicKey cKDpub(int index) {
        return this.cKDpriv(index).neuter();
    }

    public HdPublicKey neuter() {
        return HdPublicKey.from(this.hdKey);
    }

    private Derive<HdPrivateKey> derive() {
        return new CkdFunctionDerive<HdPrivateKey>(CKD_FUNCTION, this);
    }

    @Override
    public HdPrivateKey fromPath(CharSequence derivationPath) {
        int length = derivationPath.length();
        if (length == 0) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        if (length == 1) {
            return this;
        }
        if (derivationPath.charAt(0) == 'm' && this.depth() == 0) {
            if (derivationPath.charAt(1) != '/') {
                throw new IllegalArgumentException("Root key must be a master key if the path start with m/");
            }
            return this.derive().fromPath(derivationPath.subSequence(2, derivationPath.length()));
        }
        return this.derive().fromPath(derivationPath);
    }

    public HdPrivateKey fromPath() {
        return this.fromPath("m/44'/1024'/0'");
    }

    @Override
    public <Path> HdPrivateKey fromPath(Path derivationPath, Derivation<Path> derivation) {
        return this.derive().fromPath(derivationPath, derivation);
    }

    public byte[] toByteArray() {
        return this.hdKey.serialize();
    }

    public Network network() {
        return this.hdKey.getNetwork();
    }

    public int depth() {
        return this.hdKey.depth();
    }

    public int childNumber() {
        return this.hdKey.getChildNumber();
    }

    public String base58Encode() {
        return Base58.encode(this.toByteArray());
    }
}

