/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto.bip32;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.crypto.Base58;
import com.github.DNAProject.crypto.Digest;
import com.github.DNAProject.crypto.bip32.ByteArrayWriter;
import com.github.DNAProject.crypto.bip32.CKDpub;
import com.github.DNAProject.crypto.bip32.Deserializer;
import com.github.DNAProject.crypto.bip32.HdKey;
import com.github.DNAProject.crypto.bip32.HdPublicKeyDeserializer;
import com.github.DNAProject.crypto.bip32.Network;
import com.github.DNAProject.crypto.bip32.Secp256r1SC;
import com.github.DNAProject.crypto.bip32.derivation.CharSequenceDerivation;
import com.github.DNAProject.crypto.bip32.derivation.CkdFunction;
import com.github.DNAProject.crypto.bip32.derivation.CkdFunctionDerive;
import com.github.DNAProject.crypto.bip32.derivation.Derivation;
import com.github.DNAProject.crypto.bip32.derivation.Derive;
import com.github.DNAProject.sdk.exception.SDKException;
import java.math.BigInteger;
import org.spongycastle.math.ec.ECPoint;

public final class HdPublicKey
implements Derive<HdPublicKey>,
CKDpub {
    private static final CkdFunction<HdPublicKey> CKD_FUNCTION = HdPublicKey::cKDpub;
    private final HdKey hdKey;

    private static Deserializer<HdPublicKey> deserializer() {
        return HdPublicKeyDeserializer.DEFAULT;
    }

    public static Deserializer<HdPublicKey> deserializer(Network network) {
        return new HdPublicKeyDeserializer(network);
    }

    static HdPublicKey from(HdKey hdKey) {
        return new HdPublicKey(new HdKey.Builder().network(hdKey.getNetwork()).neutered(true).key(hdKey.getPoint()).parentFingerprint(hdKey.getParentFingerprint()).depth(hdKey.depth()).childNumber(hdKey.getChildNumber()).chainCode(hdKey.getChainCode()).build());
    }

    HdPublicKey(HdKey hdKey) {
        this.hdKey = hdKey;
    }

    @Override
    public HdPublicKey cKDpub(int index) {
        if (CharSequenceDerivation.isHardened(index)) {
            return null;
        }
        HdKey parent = this.hdKey;
        byte[] kPar = parent.getKey();
        byte[] data = new byte[37];
        ByteArrayWriter writer = new ByteArrayWriter(data);
        writer.concat(kPar, 33);
        writer.concatSer32(index);
        byte[] I = Digest.hmacSha512(parent.getChainCode(), data);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        BigInteger parse256_Il = HdKey.parse256(Il);
        ECPoint ki = Secp256r1SC.gMultiplyAndAddPoint(parse256_Il, kPar);
        if (parse256_Il.compareTo(Secp256r1SC.n()) >= 0 || ki.isInfinity()) {
            return this.cKDpub(index + 1);
        }
        byte[] key = Secp256r1SC.pointSerP(ki);
        return new HdPublicKey(new HdKey.Builder().network(parent.getNetwork()).neutered(true).depth(parent.depth() + 1).parentFingerprint(parent.calculateFingerPrint()).key(key).chainCode(Ir).childNumber(index).build());
    }

    public static HdPublicKey base58Decode(String key) throws SDKException {
        return HdPublicKey.deserializer().deserialize(Base58.decode(key));
    }

    public Address getAddress() {
        return Address.addressFromPubKey(this.hdKey.getKey());
    }

    private Derive<HdPublicKey> derive() {
        return new CkdFunctionDerive<HdPublicKey>(CKD_FUNCTION, this);
    }

    @Override
    public HdPublicKey fromPath(CharSequence derivationPath) {
        int length = derivationPath.length();
        if (length == 0) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        if (length == 1) {
            return this;
        }
        if (derivationPath.charAt(0) == 'm' && this.depth() == 0) {
            if (derivationPath.charAt(1) != '/') {
                throw new IllegalArgumentException("Root key must be a master key if the path start with m/");
            }
            return this.derive().fromPath(derivationPath.subSequence(2, derivationPath.length()));
        }
        return this.derive().fromPath(derivationPath);
    }

    @Override
    public <Path> HdPublicKey fromPath(Path derivationPath, Derivation<Path> derivation) {
        return this.derive().fromPath(derivationPath, derivation);
    }

    public byte[] toByteArray() {
        return this.hdKey.serialize();
    }

    public Network network() {
        return this.hdKey.getNetwork();
    }

    public int depth() {
        return this.hdKey.depth();
    }

    public int childNumber() {
        return this.hdKey.getChildNumber();
    }

    public String toHexString() {
        return Helper.toHexString(this.hdKey.getKey());
    }

    public String base58Encode() {
        return Base58.encode(this.toByteArray());
    }
}

