/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto.bip32.derivation;

import com.github.DNAProject.crypto.bip32.derivation.CkdFunction;
import com.github.DNAProject.crypto.bip32.derivation.Derivation;

public enum CharSequenceDerivation implements Derivation<CharSequence>
{
    INSTANCE;


    public static int hard(int index) {
        return index | Integer.MIN_VALUE;
    }

    public static boolean isHardened(int i) {
        return (i & Integer.MIN_VALUE) != 0;
    }

    @Override
    public <T> T derive(T rootKey, CharSequence derivationPath, CkdFunction<T> ckdFunction) {
        int length = derivationPath.length();
        T currentKey = rootKey;
        int buffer = 0;
        block4: for (int i = 0; i < length; ++i) {
            char c = derivationPath.charAt(i);
            switch (c) {
                case '\'': {
                    buffer = CharSequenceDerivation.hard(buffer);
                    continue block4;
                }
                case '/': {
                    currentKey = ckdFunction.deriveChildKey(currentKey, buffer);
                    buffer = 0;
                    continue block4;
                }
                default: {
                    buffer *= 10;
                    if (c < '0' || c > '9') {
                        throw new IllegalArgumentException("Illegal character in path: " + c);
                    }
                    if (!CharSequenceDerivation.isHardened(buffer += c - 48)) continue block4;
                    throw new IllegalArgumentException("Index number too large");
                }
            }
        }
        return ckdFunction.deriveChildKey(currentKey, buffer);
    }
}

