/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.network.websocket;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.core.block.Block;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.network.connect.AbstractConnector;
import com.github.DNAProject.network.exception.ConnectorException;
import com.github.DNAProject.network.websocket.MsgQueue;
import com.github.DNAProject.network.websocket.Result;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class WebsocketClient
extends AbstractConnector {
    private WebSocket mWebSocket = null;
    private Object lock;
    private boolean logFlag;
    private long reqId = 0L;
    public static String wsUrl = "";
    private WebsocketClient wsClient = null;

    public WebsocketClient(String url, Object lock) {
        wsUrl = url;
        this.lock = lock;
        this.wsClient = this;
    }

    public void setLog(boolean b) {
        this.logFlag = b;
    }

    public void startWebsocketThread(boolean log) {
        this.logFlag = log;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                WebsocketClient.this.wsClient.wsStart();
            }
        });
        thread.start();
    }

    @Override
    public String getUrl() {
        return wsUrl;
    }

    public void sendHeartBeat() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "heartbeat");
        map.put("Version", "V1.0.0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
    }

    public void sendSubscribe(Map map) {
        map.put("Action", "subscribe");
        map.put("Version", "V1.0.0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString((Object)map));
    }

    public void send(Map map) {
        this.mWebSocket.send(JSON.toJSONString((Object)map));
    }

    public void setReqId(long reqId) {
        this.reqId = reqId;
    }

    private long generateReqId() {
        if (this.reqId == 0L) {
            return new Random().nextInt() & Integer.MAX_VALUE;
        }
        return this.reqId;
    }

    @Override
    public Object sendRawTransaction(boolean preExec, String userid, String hexData) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "sendrawtransaction");
        map.put("Version", "1.0.0");
        map.put("Data", hexData);
        map.put("Id", this.generateReqId());
        if (preExec) {
            map.put("PreExec", "1");
        }
        this.mWebSocket.send(JSON.toJSONString(map));
        if (preExec) {
            return "0";
        }
        return "";
    }

    @Override
    public Object sendRawTransaction(String hexData) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "sendrawtransaction");
        map.put("Version", "1.0.0");
        map.put("Data", hexData);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return "";
    }

    @Override
    public Transaction getRawTransaction(String txhash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "gettransaction");
        map.put("Version", "1.0.0");
        map.put("Hash", txhash);
        map.put("Raw", "1");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return null;
    }

    @Override
    public Object getRawTransactionJson(String txhash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "gettransaction");
        map.put("Version", "1.0.0");
        map.put("Hash", txhash);
        map.put("Raw", "0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return null;
    }

    @Override
    public int getNodeCount() throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getconnectioncount");
        map.put("Version", "1.0.0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return 0;
    }

    @Override
    public int getBlockHeight() throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getblockheight");
        map.put("Version", "1.0.0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return 0;
    }

    @Override
    public Block getBlock(int height) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getblockbyheight");
        map.put("Version", "1.0.0");
        map.put("Height", height);
        map.put("Raw", "1");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return null;
    }

    @Override
    public Block getBlock(String hash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getblockbyhash");
        map.put("Version", "1.0.0");
        map.put("Hash", hash);
        map.put("Raw", "1");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return null;
    }

    @Override
    public Block getBlockJson(int height) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getblockbyheight");
        map.put("Version", "1.0.0");
        map.put("Height", height);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return null;
    }

    @Override
    public Block getBlockJson(String hash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getblockbyhash");
        map.put("Version", "1.0.0");
        map.put("Hash", hash);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return null;
    }

    @Override
    public Object getBalance(String address) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getbalance");
        map.put("Version", "1.0.0");
        map.put("Addr", address);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return null;
    }

    @Override
    public Object getContract(String hash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getcontract");
        map.put("Version", "1.0.0");
        map.put("Raw", "1");
        map.put("Hash", hash);
        map.put("Id", this.generateReqId());
        return this.mWebSocket.send(JSON.toJSONString(map));
    }

    @Override
    public Object getContractJson(String hash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getcontract");
        map.put("Version", "1.0.0");
        map.put("Raw", "0");
        map.put("Hash", hash);
        map.put("Id", this.generateReqId());
        return this.mWebSocket.send(JSON.toJSONString(map));
    }

    @Override
    public Object getSmartCodeEvent(int height) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getsmartcodeeventbyheight");
        map.put("Version", "1.0.0");
        map.put("Height", height);
        map.put("Id", this.generateReqId());
        return this.mWebSocket.send(JSON.toJSONString(map));
    }

    @Override
    public Object getSmartCodeEvent(String hash) throws ConnectorException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Action", "getsmartcodeeventbyhash");
        map.put("Version", "1.0.0");
        map.put("Hash", hash);
        return this.mWebSocket.send(JSON.toJSONString(map));
    }

    @Override
    public int getBlockHeightByTxHash(String hash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getblockheightbytxhash");
        map.put("Version", "1.0.0");
        map.put("Hash", hash);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return 0;
    }

    @Override
    public String getStorage(String codehash, String key) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getstorage");
        map.put("Version", "1.0.0");
        map.put("Hash", codehash);
        map.put("Key", key);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return "";
    }

    @Override
    public Object getMerkleProof(String hash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getmerkleproof");
        map.put("Version", "1.0.0");
        map.put("Hash", hash);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return "";
    }

    @Override
    public String getAllowance(String asset, String from, String to) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getallowance");
        map.put("Version", "1.0.0");
        map.put("Asset", asset);
        map.put("From", from);
        map.put("To", to);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return "";
    }

    @Override
    public Object getMemPoolTxCount() throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getmempooltxcount");
        map.put("Version", "1.0.0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return "";
    }

    @Override
    public Object getMemPoolTxState(String hash) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getmempooltxstate");
        map.put("Version", "1.0.0");
        map.put("Hash", hash);
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return "";
    }

    @Override
    public String getVersion() throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getversion");
        map.put("Version", "1.0.0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return "";
    }

    @Override
    public String getGrantOng(String address) throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getgrantong");
        map.put("Version", "1.0.0");
        map.put("Id", this.generateReqId());
        map.put("Addr", address);
        this.mWebSocket.send(JSON.toJSONString(map));
        return "";
    }

    @Override
    public int getNetworkId() throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getnetworkid");
        map.put("Version", "1.0.0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return 0;
    }

    @Override
    public Object getNodeSyncStatus() throws ConnectorException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", "getsyncstatus");
        map.put("Version", "1.0.0");
        map.put("Id", this.generateReqId());
        this.mWebSocket.send(JSON.toJSONString(map));
        return 0;
    }

    @Override
    public String getSideChainData(String sideChainID) throws ConnectorException, IOException {
        return null;
    }

    public void wsStart() {
        String httpUrl = null;
        httpUrl = wsUrl.contains("wss") ? "https://" + wsUrl.split("://")[1] : "http://" + wsUrl.split("://")[1];
        Request request = new Request.Builder().url(wsUrl).addHeader("Origin", httpUrl).build();
        OkHttpClient mClient = new OkHttpClient.Builder().build();
        this.mWebSocket = mClient.newWebSocket(request, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                System.out.println("opened websocket connection");
                WebsocketClient.this.sendHeartBeat();
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        WebsocketClient.this.sendHeartBeat();
                    }
                }, 1000L, 30000L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(WebSocket webSocket, String s) {
                if (WebsocketClient.this.logFlag) {
                    System.out.println("websoket onMessage:" + s);
                }
                Result result = (Result)JSON.parseObject((String)s, Result.class);
                try {
                    Object object = WebsocketClient.this.lock;
                    synchronized (object) {
                        MsgQueue.addResult(result);
                        WebsocketClient.this.lock.notify();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                System.out.println(reason);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                System.out.println("close:" + reason);
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                System.out.println("onFailure:" + response);
                WebsocketClient.this.wsStart();
            }
        });
    }
}

