/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.sdk.manager;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Common;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.crypto.Curve;
import com.github.DNAProject.crypto.ECC;
import com.github.DNAProject.crypto.SignatureScheme;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.sdk.info.AccountInfo;
import com.github.DNAProject.sdk.info.IdentityInfo;
import com.github.DNAProject.sdk.wallet.Control;
import com.github.DNAProject.sdk.wallet.Identity;
import com.github.DNAProject.sdk.wallet.Wallet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;

public class WalletMgr {
    private Wallet walletInMem;
    private Wallet walletFile;
    private SignatureScheme scheme = null;
    private String filePath = null;

    public WalletMgr(Wallet wallet, SignatureScheme scheme) throws Exception {
        this.scheme = scheme;
        this.walletInMem = wallet;
        this.walletFile = wallet;
    }

    public WalletMgr(String path, SignatureScheme scheme) throws Exception {
        this.scheme = scheme;
        this.filePath = path;
        File file = new File(this.filePath);
        if (!file.exists()) {
            this.walletInMem = new Wallet();
            this.walletInMem.setCreateTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
            this.walletFile = new Wallet();
            file.createNewFile();
            this.writeWallet();
        }
        FileInputStream inputStream = new FileInputStream(this.filePath);
        byte[] bytes = new byte[((InputStream)inputStream).available()];
        ((InputStream)inputStream).read(bytes);
        String text = new String(bytes);
        this.walletInMem = (Wallet)JSON.parseObject((String)text, Wallet.class);
        this.walletFile = (Wallet)JSON.parseObject((String)text, Wallet.class);
        if (this.walletInMem.getIdentities() == null) {
            this.walletInMem.setIdentities(new ArrayList<Identity>());
        }
        if (this.walletInMem.getAccounts() == null) {
            this.walletInMem.setAccounts(new ArrayList<com.github.DNAProject.sdk.wallet.Account>());
        }
        this.writeWallet();
    }

    private WalletMgr(String path, String label, String password, SignatureScheme scheme) throws Exception {
        this.scheme = scheme;
        this.filePath = path;
        File file = new File(this.filePath);
        if (!file.exists()) {
            this.walletInMem = new Wallet();
            this.walletInMem.setCreateTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
            this.walletFile = new Wallet();
            file.createNewFile();
            this.createIdentity(label, password);
            this.writeWallet();
        }
        FileInputStream inputStream = new FileInputStream(this.filePath);
        byte[] bytes = new byte[((InputStream)inputStream).available()];
        ((InputStream)inputStream).read(bytes);
        String text = new String(bytes);
        this.walletInMem = (Wallet)JSON.parseObject((String)text, Wallet.class);
        this.walletFile = (Wallet)JSON.parseObject((String)text, Wallet.class);
        if (this.walletInMem.getIdentities() == null) {
            this.walletInMem.setIdentities(new ArrayList<Identity>());
        }
        if (this.walletInMem.getAccounts() == null) {
            this.walletInMem.setAccounts(new ArrayList<com.github.DNAProject.sdk.wallet.Account>());
        }
        if (this.walletInMem.getIdentities().size() == 0) {
            this.createIdentity(label, password);
            this.writeWallet();
        }
    }

    private static void writeFile(String filePath, String sets) throws IOException {
        FileWriter fw = new FileWriter(filePath);
        PrintWriter out = new PrintWriter(fw);
        out.write(sets);
        out.println();
        fw.close();
        out.close();
    }

    public Wallet getWalletFile() {
        return this.walletFile;
    }

    public Wallet getWallet() {
        return this.walletInMem;
    }

    public Wallet resetWallet() {
        this.walletInMem = this.walletFile.clone();
        return this.walletInMem;
    }

    public Wallet saveWallet() throws Exception {
        return this.writeWallet();
    }

    public Wallet writeWallet() throws Exception {
        WalletMgr.writeFile(this.filePath, JSON.toJSONString((Object)this.walletInMem));
        this.walletFile = this.walletInMem.clone();
        return this.walletFile;
    }

    public SignatureScheme getSignatureScheme() {
        return this.scheme;
    }

    public void setSignatureScheme(SignatureScheme scheme) {
        this.scheme = scheme;
    }

    public Identity importIdentity(String encryptedPrikey, String password, byte[] salt, String address) throws Exception {
        return this.importIdentity("", encryptedPrikey, password, salt, address);
    }

    public Identity importIdentity(String label, String encryptedPrikey, String password, byte[] salt, String address) throws Exception {
        String prikey = Account.getGcmDecodedPrivateKey(encryptedPrikey, password, address, salt, this.walletFile.getScrypt().getN(), this.scheme);
        IdentityInfo info = this.createIdentity(label, password, salt, Helper.hexToBytes(prikey));
        prikey = null;
        return this.getWallet().getIdentity(info.dnaid);
    }

    public Identity createIdentity(String password) throws Exception {
        return this.createIdentity("", password);
    }

    public Identity createIdentity(String label, String password) throws Exception {
        IdentityInfo info = this.createIdentity(label, password, ECC.generateKey());
        return this.getWallet().getIdentity(info.dnaid);
    }

    public Identity createIdentityFromPriKey(String label, String password, String prikey) throws Exception {
        IdentityInfo info = this.createIdentity(label, password, Helper.hexToBytes(prikey));
        return this.getWallet().getIdentity(info.dnaid);
    }

    public Identity createIdentityFromPriKey(String password, String prikey) throws Exception {
        IdentityInfo info = this.createIdentity("", password, Helper.hexToBytes(prikey));
        prikey = null;
        return this.getWallet().getIdentity(info.dnaid);
    }

    public IdentityInfo createIdentityInfo(String password) throws Exception {
        return this.createIdentityInfo("", password);
    }

    public IdentityInfo createIdentityInfo(String label, String password) throws Exception {
        IdentityInfo info = this.createIdentity(label, password, ECC.generateKey());
        return info;
    }

    public IdentityInfo getIdentityInfo(String dnaid, String password, byte[] salt) throws Exception {
        Account acct = this.getAccountByAddressOrDnaId(dnaid, password, salt);
        IdentityInfo info = new IdentityInfo();
        info.dnaid = Common.diddna + Address.addressFromPubKey(acct.serializePublicKey()).toBase58();
        info.pubkey = Helper.toHexString(acct.serializePublicKey());
        info.setPrikey(Helper.toHexString(acct.serializePrivateKey()));
        info.setPriwif(acct.exportWif());
        info.encryptedPrikey = acct.exportGcmEncryptedPrikey(password, salt, this.walletFile.getScrypt().getN());
        info.addressU160 = acct.getAddressU160().toString();
        return info;
    }

    private IdentityInfo createIdentity(String label, String password, byte[] prikey) throws Exception {
        byte[] salt = ECC.generateKey(16);
        return this.createIdentity(label, password, salt, prikey);
    }

    private IdentityInfo createIdentity(String label, String password, byte[] salt, byte[] prikey) throws Exception {
        Account acct = this.createAccount(label, password, salt, prikey, false);
        IdentityInfo info = new IdentityInfo();
        info.dnaid = Common.diddna + Address.addressFromPubKey(acct.serializePublicKey()).toBase58();
        info.pubkey = Helper.toHexString(acct.serializePublicKey());
        info.setPrikey(Helper.toHexString(acct.serializePrivateKey()));
        info.setPriwif(acct.exportWif());
        info.encryptedPrikey = acct.exportGcmEncryptedPrikey(password, salt, this.walletFile.getScrypt().getN());
        info.addressU160 = acct.getAddressU160().toHexString();
        return info;
    }

    public com.github.DNAProject.sdk.wallet.Account importAccount(String encryptedPrikey, String password, String address, byte[] salt) throws Exception {
        return this.importAccount("", encryptedPrikey, password, address, salt);
    }

    public com.github.DNAProject.sdk.wallet.Account importAccount(String label, String encryptedPrikey, String password, String address, byte[] salt) throws Exception {
        String prikey = Account.getGcmDecodedPrivateKey(encryptedPrikey, password, address, salt, this.walletFile.getScrypt().getN(), this.scheme);
        AccountInfo info = this.createAccountInfo(label, password, salt, Helper.hexToBytes(prikey));
        prikey = null;
        password = null;
        return this.getWallet().getAccount(info.addressBase58);
    }

    public void createAccounts(int count, String password) throws Exception {
        for (int i = 0; i < count; ++i) {
            this.createAccount("", password);
        }
    }

    public com.github.DNAProject.sdk.wallet.Account createAccount(String password) throws Exception {
        com.github.DNAProject.sdk.wallet.Account account = this.createAccount("", password);
        return account;
    }

    public com.github.DNAProject.sdk.wallet.Account createAccount(String label, String password) throws Exception {
        AccountInfo info = this.createAccountInfo(label, password, ECC.generateKey());
        return this.getWallet().getAccount(info.addressBase58);
    }

    private AccountInfo createAccountInfo(String label, String password, byte[] prikey) throws Exception {
        byte[] salt = ECC.generateKey(16);
        return this.createAccountInfo(label, password, salt, prikey);
    }

    private AccountInfo createAccountInfo(String label, String password, byte[] salt, byte[] prikey) throws Exception {
        Account acct = this.createAccount(label, password, salt, prikey, true);
        new SecureRandom().nextBytes(prikey);
        AccountInfo info = new AccountInfo();
        info.addressBase58 = Address.addressFromPubKey(acct.serializePublicKey()).toBase58();
        info.pubkey = Helper.toHexString(acct.serializePublicKey());
        info.setPrikey(Helper.toHexString(acct.serializePrivateKey()));
        info.setPriwif(acct.exportWif());
        info.encryptedPrikey = acct.exportGcmEncryptedPrikey(password, salt, this.walletFile.getScrypt().getN());
        info.addressU160 = acct.getAddressU160().toHexString();
        return info;
    }

    public com.github.DNAProject.sdk.wallet.Account createAccountFromPriKey(String password, String prikey) throws Exception {
        AccountInfo info = this.createAccountInfo("", password, Helper.hexToBytes(prikey));
        return this.getWallet().getAccount(info.addressBase58);
    }

    public com.github.DNAProject.sdk.wallet.Account createAccountFromPriKey(String label, String password, String prikey) throws Exception {
        AccountInfo info = this.createAccountInfo(label, password, Helper.hexToBytes(prikey));
        return this.getWallet().getAccount(info.addressBase58);
    }

    public AccountInfo createAccountInfo(String password) throws Exception {
        return this.createAccountInfo("", password);
    }

    public AccountInfo createAccountInfo(String label, String password) throws Exception {
        AccountInfo info = this.createAccountInfo(label, password, ECC.generateKey());
        return info;
    }

    public AccountInfo createAccountInfoFromPriKey(String password, String prikey) throws Exception {
        return this.createAccountInfo("", password, Helper.hexToBytes(prikey));
    }

    public AccountInfo createAccountInfoFromPriKey(String label, String password, String prikey) throws Exception {
        return this.createAccountInfo(label, password, Helper.hexToBytes(prikey));
    }

    public IdentityInfo createIdentityInfoFromPriKey(String label, String password, String prikey) throws Exception {
        return this.createIdentity(label, password, Helper.hexToBytes(prikey));
    }

    public String privateKeyToWif(String privateKey) throws Exception {
        Account act = new Account(Helper.hexToBytes(privateKey), this.scheme);
        return act.exportWif();
    }

    public Account getAccount(String address, String password) throws Exception {
        return this.getAccount(address, password, this.getWallet().getAccount(address).getSalt());
    }

    public Account getAccount(String addressOrDnaId, String password, byte[] salt) throws Exception {
        return this.getAccountByAddressOrDnaId(addressOrDnaId, password, salt);
    }

    public AccountInfo getAccountInfo(String addressOrDnaId, String password, byte[] salt) throws Exception {
        AccountInfo info = new AccountInfo();
        Account acc = this.getAccountByAddressOrDnaId(addressOrDnaId, password, salt);
        info.addressBase58 = addressOrDnaId.replace(Common.diddna, "");
        info.pubkey = Helper.toHexString(acc.serializePublicKey());
        info.setPrikey(Helper.toHexString(acc.serializePrivateKey()));
        info.encryptedPrikey = acc.exportGcmEncryptedPrikey(password, salt, this.walletFile.getScrypt().getN());
        info.setPriwif(acc.exportWif());
        info.addressU160 = acc.getAddressU160().toString();
        return info;
    }

    private Account createAccount(String label, String password, byte[] salt, byte[] privateKey, boolean accountFlag) throws Exception {
        com.github.DNAProject.sdk.wallet.Account acct;
        Account account = new Account(privateKey, this.scheme);
        switch (this.scheme) {
            case SHA256WITHECDSA: {
                acct = new com.github.DNAProject.sdk.wallet.Account("ECDSA", new Object[]{Curve.P256.toString()}, "aes-256-gcm", "SHA256withECDSA", "sha256");
                break;
            }
            case SM3WITHSM2: {
                acct = new com.github.DNAProject.sdk.wallet.Account("SM2", new Object[]{Curve.SM2P256V1.toString()}, "aes-256-gcm", "SM3withSM2", "sha256");
                break;
            }
            default: {
                throw new SDKException(ErrorCode.OtherError("scheme type error"));
            }
        }
        if (password != null) {
            acct.key = account.exportGcmEncryptedPrikey(password, salt, this.walletFile.getScrypt().getN());
            password = null;
        } else {
            acct.key = Helper.toHexString(account.serializePrivateKey());
        }
        acct.address = Address.addressFromPubKey(account.serializePublicKey()).toBase58();
        if (label == null || label.equals("")) {
            Iterator<Identity> uuidStr = UUID.randomUUID().toString();
            label = ((String)((Object)uuidStr)).substring(0, 8);
        }
        if (accountFlag) {
            for (com.github.DNAProject.sdk.wallet.Account e : this.walletInMem.getAccounts()) {
                if (!e.address.equals(acct.address)) continue;
                throw new SDKException(ErrorCode.ParamErr("wallet account exist"));
            }
            if (this.walletInMem.getAccounts().size() == 0) {
                acct.isDefault = true;
                this.walletInMem.setDefaultAccountAddress(acct.address);
            }
            acct.label = label;
            acct.setSalt(salt);
            acct.setPublicKey(Helper.toHexString(account.serializePublicKey()));
            this.walletInMem.getAccounts().add(acct);
        } else {
            for (Identity e : this.walletInMem.getIdentities()) {
                if (!e.dnaid.equals(Common.diddna + acct.address)) continue;
                throw new SDKException(ErrorCode.ParamErr("wallet Identity exist"));
            }
            Identity idt = new Identity();
            idt.dnaid = Common.diddna + acct.address;
            idt.label = label;
            if (this.walletInMem.getIdentities().size() == 0) {
                idt.isDefault = true;
                this.walletInMem.setDefaultDnaid(idt.dnaid);
            }
            idt.controls = new ArrayList<Control>();
            Control ctl = new Control(acct.key, "keys-1", Helper.toHexString(account.serializePublicKey()));
            ctl.setSalt(salt);
            ctl.setAddress(acct.address);
            idt.controls.add(ctl);
            this.walletInMem.getIdentities().add(idt);
        }
        return account;
    }

    private Account getAccountByAddressOrDnaId(String addressOrDnaId, String password, byte[] salt) throws Exception {
        try {
            if (addressOrDnaId.startsWith(Common.diddna)) {
                for (Identity e : this.walletInMem.getIdentities()) {
                    if (!e.dnaid.equals(addressOrDnaId)) continue;
                    String addr = e.dnaid.replace(Common.diddna, "");
                    String prikey = Account.getGcmDecodedPrivateKey(e.controls.get((int)0).key, password, addr, salt, this.walletFile.getScrypt().getN(), this.scheme);
                    return new Account(Helper.hexToBytes(prikey), this.scheme);
                }
            } else {
                for (com.github.DNAProject.sdk.wallet.Account e : this.walletInMem.getAccounts()) {
                    if (!e.address.equals(addressOrDnaId)) continue;
                    String prikey = Account.getGcmDecodedPrivateKey(e.key, password, e.address, salt, this.walletFile.getScrypt().getN(), this.scheme);
                    return new Account(Helper.hexToBytes(prikey), this.scheme);
                }
            }
        }
        catch (Exception e) {
            throw new SDKException(ErrorCode.OtherError(e.getMessage()));
        }
        throw new SDKException(ErrorCode.OtherError("Account null"));
    }

    public Identity getDefaultIdentity() {
        for (Identity e : this.getWallet().getIdentities()) {
            if (!e.isDefault) continue;
            return e;
        }
        return null;
    }

    public com.github.DNAProject.sdk.wallet.Account getDefaultAccount() {
        for (com.github.DNAProject.sdk.wallet.Account e : this.getWallet().getAccounts()) {
            if (!e.isDefault) continue;
            return e;
        }
        return null;
    }
}

