/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm;

import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.IOException;

class DnaIDsToRoleParam
implements Serializable {
    byte[] contractAddr;
    byte[] adminDnaID;
    byte[] role;
    byte[][] persons;
    long keyNo;

    DnaIDsToRoleParam(byte[] contractAddr, byte[] adminDnaID, byte[] role, byte[][] persons, long keyNo) {
        this.contractAddr = contractAddr;
        this.adminDnaID = adminDnaID;
        this.role = role;
        this.persons = persons;
        this.keyNo = keyNo;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        this.contractAddr = reader.readVarBytes();
        this.adminDnaID = reader.readVarBytes();
        this.role = reader.readVarBytes();
        int length = (int)reader.readVarInt();
        this.persons = new byte[length][];
        for (int i = 0; i < length; ++i) {
            this.persons[i] = reader.readVarBytes();
        }
        this.keyNo = reader.readVarInt();
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(this.contractAddr);
        writer.writeVarBytes(this.adminDnaID);
        writer.writeVarBytes(this.role);
        writer.writeVarInt(this.persons.length);
        for (byte[] p : this.persons) {
            writer.writeVarBytes(p);
        }
        writer.writeVarInt(this.keyNo);
    }
}

