/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Common;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.common.UInt256;
import com.github.DNAProject.core.DataSignature;
import com.github.DNAProject.core.block.Block;
import com.github.DNAProject.core.dnaid.Attribute;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.crypto.Curve;
import com.github.DNAProject.crypto.KeyType;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.merkle.MerkleVerifier;
import com.github.DNAProject.sdk.claim.Claim;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.sdk.info.AccountInfo;
import com.github.DNAProject.sdk.wallet.Identity;
import com.github.DNAProject.smartcontract.nativevm.abi.NativeBuildParams;
import com.github.DNAProject.smartcontract.nativevm.abi.Struct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DnaId {
    private DnaSdk sdk;
    private String contractAddress = "0000000000000000000000000000000000000003";

    public DnaId(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String sendRegister(Identity ident, String password, Account payerAcct, long gaslimit, long gasprice, boolean isPreExec) throws Exception {
        if (ident == null || password == null || password.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        Transaction tx = this.makeRegister(ident.dnaid, ident.controls.get((int)0).publicKey, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.getWalletMgr().writeWallet();
        this.sdk.signTx(tx, ident.dnaid, password, ident.controls.get(0).getSalt());
        this.sdk.addSign(tx, payerAcct);
        if (isPreExec) {
            Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
            String result = ((JSONObject)obj).getString("Result");
            if (Integer.parseInt(result) == 0) {
                throw new SDKException(ErrorCode.OtherError("sendRawTransaction PreExec error: " + obj));
            }
        } else {
            boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
            if (!b) {
                throw new SDKException(ErrorCode.SendRawTxError);
            }
        }
        return tx.hash().toHexString();
    }

    public String sendRegisterPreExec(Identity ident, String password, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return this.sendRegister(ident, password, payerAcct, gaslimit, gasprice, true);
    }

    public String sendRegister(Identity ident, String password, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return this.sendRegister(ident, password, payerAcct, gaslimit, gasprice, false);
    }

    public Transaction makeRegister(String dnaid, String publickey, String payer, long gaslimit, long gasprice) throws Exception {
        if (payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        byte[] pk = Helper.hexToBytes(publickey);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(dnaid, pk));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "regIDWithPublicKey", args, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendRegisterWithAttrs(Identity ident, String password, Attribute[] attributes, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (ident == null || password == null || password.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        String dnaid = ident.dnaid;
        Transaction tx = this.makeRegisterWithAttrs(dnaid, password, ident.controls.get(0).getSalt(), ident.controls.get((int)0).publicKey, attributes, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, dnaid, password, ident.controls.get(0).getSalt());
        this.sdk.addSign(tx, payerAcct);
        Identity identity = this.sdk.getWalletMgr().getWallet().addDnaIdController(dnaid, ident.controls.get((int)0).key, ident.dnaid, ident.controls.get((int)0).publicKey);
        this.sdk.getWalletMgr().writeWallet();
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        return tx.hash().toHexString();
    }

    public Transaction makeRegisterWithAttrs(String dnaid, String password, byte[] salt, String publickey, Attribute[] attributes, String payer, long gaslimit, long gasprice) throws Exception {
        if (password == null || password.equals("") || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        byte[] pk = Helper.hexToBytes(publickey);
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct().add(dnaid.getBytes(), pk);
        struct.add(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            struct.add(attributes[i].key, attributes[i].valueType, attributes[i].value);
        }
        list.add(struct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "regIDWithAttributes", args, payer, gaslimit, gasprice);
        return tx;
    }

    private byte[] serializeAttributes(Attribute[] attributes) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryWriter bw = new BinaryWriter(baos);
        bw.writeSerializableArray(attributes);
        return baos.toByteArray();
    }

    public String sendGetPublicKeys(String dnaid) throws Exception {
        if (dnaid == null || dnaid.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("dnaid should not be null"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(dnaid.getBytes());
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "getPublicKeys", arg, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        if (res.equals("")) {
            return res;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader br = new BinaryReader(bais);
        ArrayList pubKeyList = new ArrayList();
        try {
            while (true) {
                HashMap<String, Object> publicKeyMap = new HashMap<String, Object>();
                publicKeyMap.put("PubKeyId", dnaid + "#keys-" + String.valueOf(br.readInt()));
                byte[] pubKey = br.readVarBytes();
                if (pubKey.length == 33) {
                    publicKeyMap.put("Type", KeyType.ECDSA.name());
                    publicKeyMap.put("Curve", (Object)Curve.P256);
                    publicKeyMap.put("Value", Helper.toHexString(pubKey));
                } else {
                    publicKeyMap.put("Type", (Object)KeyType.fromLabel(pubKey[0]));
                    publicKeyMap.put("Curve", (Object)Curve.fromLabel(pubKey[1]));
                    publicKeyMap.put("Value", Helper.toHexString(pubKey));
                }
                pubKeyList.add(publicKeyMap);
            }
        }
        catch (Exception e) {
            return JSON.toJSONString(pubKeyList);
        }
    }

    public String sendGetKeyState(String dnaid, int index) throws Exception {
        if (dnaid == null || dnaid.equals("") || index < 0) {
            throw new SDKException(ErrorCode.ParamErr("parameter is wrong"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(dnaid.getBytes(), index));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "getKeyState", arg, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        if (res.equals("")) {
            return res;
        }
        return new String(Helper.hexToBytes(res));
    }

    public String sendGetAttributes(String dnaid) throws Exception {
        if (dnaid == null || dnaid.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("dnaid should not be null"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(dnaid.getBytes());
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "getAttributes", arg, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        if (res.equals("")) {
            return res;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader br = new BinaryReader(bais);
        ArrayList attrsList = new ArrayList();
        try {
            while (true) {
                HashMap<String, String> attributeMap = new HashMap<String, String>();
                attributeMap.put("Key", new String(br.readVarBytes()));
                attributeMap.put("Type", new String(br.readVarBytes()));
                attributeMap.put("Value", new String(br.readVarBytes()));
                attrsList.add(attributeMap);
            }
        }
        catch (Exception e) {
            return JSON.toJSONString(attrsList);
        }
    }

    public String sendAddPubKey(String dnaid, String password, byte[] salt, String newpubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return this.sendAddPubKey(dnaid, null, password, salt, newpubkey, payerAcct, gaslimit, gasprice);
    }

    public String sendAddPubKey(String dnaid, String recovery, String password, byte[] salt, String newpubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        Transaction tx = this.makeAddPubKey(dnaid, recovery, password, salt, newpubkey, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        String addr = recovery != null ? recovery.replace(Common.diddna, "") : dnaid;
        this.sdk.signTx(tx, addr, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String sendAddPubKey(String dnaid, Account controler, String newpubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(dnaid.getBytes(), Helper.hexToBytes(newpubkey), controler.serializePublicKey()));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "addKey", arg, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.addSign(tx, controler);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public Transaction makeAddPubKey(String dnaid, String password, byte[] salt, String newpubkey, String payer, long gaslimit, long gasprice) throws Exception {
        return this.makeAddPubKey(dnaid, null, password, salt, newpubkey, payer, gaslimit, gasprice);
    }

    public Transaction makeAddPubKey(String dnaid, String recovery, String password, byte[] salt, String newpubkey, String payer, long gaslimit, long gasprice) throws Exception {
        byte[] arg;
        if (dnaid == null || dnaid.equals("") || payer == null || payer.equals("") || newpubkey == null || newpubkey.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (recovery == null) {
            AccountInfo info = this.sdk.getWalletMgr().getAccountInfo(dnaid, password, salt);
            byte[] pk = Helper.hexToBytes(info.pubkey);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new Struct().add(dnaid.getBytes(), Helper.hexToBytes(newpubkey), pk));
            arg = NativeBuildParams.createCodeParamsScript(list);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new Struct().add(dnaid.getBytes(), Helper.hexToBytes(newpubkey), Address.decodeBase58(recovery.replace(Common.diddna, "")).toArray()));
            arg = NativeBuildParams.createCodeParamsScript(list);
        }
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "addKey", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendRemovePubKey(String dnaid, String password, byte[] salt, String removePubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return this.sendRemovePubKey(dnaid, null, password, salt, removePubkey, payerAcct, gaslimit, gasprice);
    }

    public String sendRemovePubKey(String dnaid, String recovery, String password, byte[] salt, String removePubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        Transaction tx = this.makeRemovePubKey(dnaid, recovery, password, salt, removePubkey, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        String addr = recovery == null ? dnaid : recovery.replace(Common.diddna, "");
        this.sdk.signTx(tx, addr, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String sendRemovePubKey(String dnaid, Account controler, String removePubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(dnaid.getBytes(), Helper.hexToBytes(removePubkey), controler.serializePublicKey()));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "removeKey", arg, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.addSign(tx, controler);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public Transaction makeRemovePubKey(String dnaid, String password, byte[] salt, String removePubkey, String payer, long gaslimit, long gasprice) throws Exception {
        return this.makeRemovePubKey(dnaid, null, password, salt, removePubkey, payer, gaslimit, gasprice);
    }

    public Transaction makeRemovePubKey(String dnaid, String recoveryAddr, String password, byte[] salt, String removePubkey, String payer, long gaslimit, long gasprice) throws Exception {
        byte[] arg;
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("") || payer == null || payer.equals("") || removePubkey == null || removePubkey.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (recoveryAddr == null) {
            AccountInfo info = this.sdk.getWalletMgr().getAccountInfo(dnaid, password, salt);
            byte[] pk = Helper.hexToBytes(info.pubkey);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new Struct().add(dnaid.getBytes(), Helper.hexToBytes(removePubkey), pk));
            arg = NativeBuildParams.createCodeParamsScript(list);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new Struct().add(dnaid.getBytes(), Helper.hexToBytes(removePubkey), Address.decodeBase58(recoveryAddr.replace(Common.diddna, "")).toArray()));
            arg = NativeBuildParams.createCodeParamsScript(list);
        }
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "removeKey", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendAddRecovery(String dnaid, String password, byte[] salt, String recoveryAddr, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("") || payerAcct == null || recoveryAddr == null || recoveryAddr.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        String addr = dnaid.replace(Common.diddna, "");
        Transaction tx = this.makeAddRecovery(dnaid, password, salt, recoveryAddr, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, dnaid, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public Transaction makeAddRecovery(String dnaid, String password, byte[] salt, String recoveryAddr, String payer, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("") || payer == null || payer.equals("") || recoveryAddr == null || recoveryAddr.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AccountInfo info = this.sdk.getWalletMgr().getAccountInfo(dnaid, password, salt);
        byte[] pk = Helper.hexToBytes(info.pubkey);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(dnaid, Address.decodeBase58(recoveryAddr), pk));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "addRecovery", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendChangeRecovery(String dnaid, String newRecovery, String oldRecovery, String password, byte[] salt, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        Transaction tx = this.makeChangeRecovery(dnaid, newRecovery, oldRecovery, password, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, oldRecovery, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public Transaction makeChangeRecovery(String dnaid, String newRecovery, String oldRecovery, String password, String payer, long gaslimit, long gasprice) throws SDKException {
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("") || newRecovery == null || oldRecovery == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        Address newAddr = Address.decodeBase58(newRecovery.replace(Common.diddna, ""));
        Address oldAddr = Address.decodeBase58(oldRecovery.replace(Common.diddna, ""));
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(dnaid, newAddr, oldAddr));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "changeRecovery", arg, payer, gaslimit, gasprice);
        return tx;
    }

    private String sendChangeRecovery(String dnaid, String newRecovery, String oldRecovery, Account[] accounts, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || accounts == null || accounts.length == 0 || newRecovery == null || oldRecovery == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        Address newAddr = Address.decodeBase58(newRecovery.replace(Common.diddna, ""));
        Address oldAddr = Address.decodeBase58(oldRecovery.replace(Common.diddna, ""));
        byte[] parabytes = NativeBuildParams.buildParams(dnaid.getBytes(), newAddr.toArray(), oldAddr.toArray());
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(this.contractAddress, "changeRecovery", parabytes, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{accounts});
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String sendAddAttributes(String dnaid, String password, byte[] salt, Attribute[] attributes, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || attributes == null || attributes.length == 0 || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        String addr = dnaid.replace(Common.diddna, "");
        Transaction tx = this.makeAddAttributes(dnaid, password, salt, attributes, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, dnaid, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String sendAddAttributes(String dnaid, Account controler, Attribute[] attributes, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || attributes == null || attributes.length == 0 || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct().add(new Object[]{dnaid.getBytes()});
        struct.add(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            struct.add(attributes[i].key, attributes[i].valueType, attributes[i].value);
        }
        struct.add(new Object[]{controler.serializePublicKey()});
        list.add(struct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "addAttributes", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.addSign(tx, controler);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public Transaction makeAddAttributes(String dnaid, String password, byte[] salt, Attribute[] attributes, String payer, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || attributes == null || attributes.length == 0 || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AccountInfo info = this.sdk.getWalletMgr().getAccountInfo(dnaid, password, salt);
        password = null;
        byte[] pk = Helper.hexToBytes(info.pubkey);
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct().add(new Object[]{dnaid.getBytes()});
        struct.add(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            struct.add(attributes[i].key, attributes[i].valueType, attributes[i].value);
        }
        struct.add(new Object[]{pk});
        list.add(struct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "addAttributes", args, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendRemoveAttribute(String dnaid, String password, byte[] salt, String path, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || payerAcct == null || path == null || path.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        String addr = dnaid.replace(Common.diddna, "");
        Transaction tx = this.makeRemoveAttribute(dnaid, password, salt, path, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, dnaid, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String sendRemoveAttribute(String dnaid, Account controler, String path, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || payerAcct == null || path == null || path.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(dnaid.getBytes(), path.getBytes(), controler.serializePublicKey()));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "removeAttribute", arg, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.addSign(tx, controler);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public Transaction makeRemoveAttribute(String dnaid, String password, byte[] salt, String path, String payer, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || payer == null || payer.equals("") || path == null || path.equals("") || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gas or gaslimit should not be less than 0"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AccountInfo info = this.sdk.getWalletMgr().getAccountInfo(dnaid, password, salt);
        byte[] pk = Helper.hexToBytes(info.pubkey);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(dnaid.getBytes(), path.getBytes(), pk));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "removeAttribute", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public Object getMerkleProof(String txhash) throws Exception {
        if (txhash == null || txhash.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("txhash should not be null"));
        }
        HashMap proof = new HashMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int height = this.sdk.getConnect().getBlockHeightByTxHash(txhash);
        map.put("Type", "MerkleProof");
        map.put("TxnHash", txhash);
        map.put("BlockHeight", height);
        Map tmpProof = (Map)this.sdk.getConnect().getMerkleProof(txhash);
        UInt256 txroot = UInt256.parse((String)tmpProof.get("TransactionsRoot"));
        int blockHeight = (Integer)tmpProof.get("BlockHeight");
        UInt256 curBlockRoot = UInt256.parse((String)tmpProof.get("CurBlockRoot"));
        int curBlockHeight = (Integer)tmpProof.get("CurBlockHeight");
        List hashes = (List)tmpProof.get("TargetHashes");
        UInt256[] targetHashes = new UInt256[hashes.size()];
        for (int i = 0; i < hashes.size(); ++i) {
            targetHashes[i] = UInt256.parse((String)hashes.get(i));
        }
        map.put("MerkleRoot", curBlockRoot.toHexString());
        map.put("Nodes", MerkleVerifier.getProof(txroot, blockHeight, targetHashes, curBlockHeight + 1));
        proof.put("Proof", map);
        return proof;
    }

    public boolean verifyMerkleProof(String merkleProof) throws Exception {
        if (merkleProof == null || merkleProof.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("claim should not be null"));
        }
        try {
            JSONObject obj = JSON.parseObject((String)merkleProof);
            JSONObject proof = obj.getJSONObject("Proof");
            String txhash = (String)proof.get("TxnHash");
            int blockHeight = (Integer)proof.get("BlockHeight");
            UInt256 merkleRoot = UInt256.parse((String)proof.get("MerkleRoot"));
            Block block = this.sdk.getConnect().getBlock(blockHeight);
            if (block.height != blockHeight) {
                throw new SDKException("blockHeight not match");
            }
            boolean containTx = false;
            for (int i = 0; i < block.transactions.length; ++i) {
                if (!block.transactions[i].hash().toHexString().equals(txhash)) continue;
                containTx = true;
            }
            if (!containTx) {
                throw new SDKException(ErrorCode.OtherError("not contain this tx"));
            }
            UInt256 txsroot = block.transactionsRoot;
            List nodes = (List)proof.get("Nodes");
            return MerkleVerifier.Verify(txsroot, nodes, merkleRoot);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SDKException(e);
        }
    }

    public String createDnaIdClaim(String signerDnaid, String password, byte[] salt, String context, Map<String, Object> claimMap, Map metaData, Map clmRevMap, long expire) throws Exception {
        if (signerDnaid == null || signerDnaid.equals("") || password == null || password.equals("") || context == null || context.equals("") || claimMap == null || metaData == null || clmRevMap == null || expire <= 0L) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (expire < System.currentTimeMillis() / 1000L) {
            throw new SDKException(ErrorCode.ExpireErr);
        }
        Claim claim = null;
        try {
            String sendDid = (String)metaData.get("Issuer");
            String receiverDid = (String)metaData.get("Subject");
            if (sendDid == null || receiverDid == null) {
                throw new SDKException(ErrorCode.DidNull);
            }
            String issuerDdo = this.sendGetDDO(sendDid);
            JSONArray owners = JSON.parseObject((String)issuerDdo).getJSONArray("Owners");
            if (owners == null) {
                throw new SDKException(ErrorCode.NotExistCliamIssuer);
            }
            String pubkeyId = null;
            Account acct = this.sdk.getWalletMgr().getAccount(signerDnaid, password, salt);
            String pk = Helper.toHexString(acct.serializePublicKey());
            for (int i = 0; i < owners.size(); ++i) {
                JSONObject obj = owners.getJSONObject(i);
                if (!obj.getString("Value").equals(pk)) continue;
                pubkeyId = obj.getString("PubKeyId");
                break;
            }
            if (pubkeyId == null) {
                throw new SDKException(ErrorCode.NotFoundPublicKeyId);
            }
            String[] receiverDidStr = receiverDid.split(":");
            if (receiverDidStr.length != 3) {
                throw new SDKException(ErrorCode.DidError);
            }
            claim = new Claim(this.sdk.getWalletMgr().getSignatureScheme(), acct, context, claimMap, metaData, clmRevMap, pubkeyId, expire);
            return claim.getClaimStr();
        }
        catch (SDKException e) {
            throw new SDKException(ErrorCode.CreateDnaIdClaimErr);
        }
    }

    public boolean verifyDnaIdClaim(String claim) throws Exception {
        if (claim == null) {
            throw new SDKException(ErrorCode.ParamErr("claim should not be null"));
        }
        DataSignature sign = null;
        try {
            String[] obj = claim.split("\\.");
            if (obj.length != 3) {
                throw new SDKException(ErrorCode.ParamError);
            }
            byte[] payloadBytes = Base64.getDecoder().decode(obj[1].getBytes());
            JSONObject payloadObj = JSON.parseObject((String)new String(payloadBytes));
            String issuerDid = payloadObj.getString("iss");
            String[] str = issuerDid.split(":");
            if (str.length != 3) {
                throw new SDKException(ErrorCode.DidError);
            }
            String issuerDdo = this.sendGetDDO(issuerDid);
            JSONArray owners = JSON.parseObject((String)issuerDdo).getJSONArray("Owners");
            if (owners == null) {
                throw new SDKException(ErrorCode.NotExistCliamIssuer);
            }
            byte[] signatureBytes = Base64.getDecoder().decode(obj[2]);
            byte[] headerBytes = Base64.getDecoder().decode(obj[0].getBytes());
            JSONObject header = JSON.parseObject((String)new String(headerBytes));
            String kid = header.getString("kid");
            String id = kid.split("#keys-")[1];
            String pubkeyStr = owners.getJSONObject(Integer.parseInt(id) - 1).getString("Value");
            sign = new DataSignature();
            byte[] data = (obj[0] + "." + obj[1]).getBytes();
            return sign.verifySignature(new Account(false, Helper.hexToBytes(pubkeyStr)), data, signatureBytes);
        }
        catch (Exception e) {
            throw new SDKException(ErrorCode.VerifyDnaIdClaimErr);
        }
    }

    public String sendGetDDO(String dnaid) throws Exception {
        if (dnaid == null) {
            throw new SDKException(ErrorCode.ParamErr("dnaid should not be null"));
        }
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(dnaid.getBytes());
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes(this.contractAddress)), "getDDO", arg, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        if (res.equals("")) {
            return res;
        }
        Map map = this.parseDdoData(dnaid, res);
        if (map.size() == 0) {
            return "";
        }
        return JSON.toJSONString((Object)map);
    }

    private Map parseDdoData(String dnaid, String obj) throws Exception {
        byte[] recoveryBytes;
        byte[] attributeBytes;
        byte[] publickeyBytes;
        byte[] bys = Helper.hexToBytes(obj);
        ByteArrayInputStream bais = new ByteArrayInputStream(bys);
        BinaryReader br = new BinaryReader(bais);
        try {
            publickeyBytes = br.readVarBytes();
        }
        catch (Exception e) {
            publickeyBytes = new byte[]{};
        }
        try {
            attributeBytes = br.readVarBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
            attributeBytes = new byte[]{};
        }
        try {
            recoveryBytes = br.readVarBytes();
        }
        catch (Exception e) {
            recoveryBytes = new byte[]{};
        }
        ArrayList pubKeyList = new ArrayList();
        if (publickeyBytes.length != 0) {
            ByteArrayInputStream bais1 = new ByteArrayInputStream(publickeyBytes);
            BinaryReader br1 = new BinaryReader(bais1);
            try {
                while (true) {
                    HashMap<String, Object> publicKeyMap = new HashMap<String, Object>();
                    publicKeyMap.put("PubKeyId", dnaid + "#keys-" + String.valueOf(br1.readInt()));
                    byte[] pubKey = br1.readVarBytes();
                    if (pubKey.length == 33) {
                        publicKeyMap.put("Type", KeyType.ECDSA.name());
                        publicKeyMap.put("Curve", (Object)Curve.P256);
                        publicKeyMap.put("Value", Helper.toHexString(pubKey));
                    } else {
                        publicKeyMap.put("Type", (Object)KeyType.fromLabel(pubKey[0]));
                        publicKeyMap.put("Curve", (Object)Curve.fromLabel(pubKey[1]));
                        publicKeyMap.put("Value", Helper.toHexString(pubKey));
                    }
                    pubKeyList.add(publicKeyMap);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList attrsList = new ArrayList();
        if (attributeBytes.length != 0) {
            ByteArrayInputStream bais2 = new ByteArrayInputStream(attributeBytes);
            BinaryReader br2 = new BinaryReader(bais2);
            try {
                while (true) {
                    HashMap<String, String> attributeMap = new HashMap<String, String>();
                    attributeMap.put("Key", new String(br2.readVarBytes()));
                    attributeMap.put("Type", new String(br2.readVarBytes()));
                    attributeMap.put("Value", new String(br2.readVarBytes()));
                    attrsList.add(attributeMap);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Owners", pubKeyList);
        map.put("Attributes", attrsList);
        if (recoveryBytes.length != 0) {
            map.put("Recovery", Address.parse(Helper.toHexString(recoveryBytes)).toBase58());
        }
        map.put("DnaId", dnaid);
        return map;
    }
}

