/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.asset.Sig;
import com.github.DNAProject.core.block.Block;
import com.github.DNAProject.core.governance.AuthorizeInfo;
import com.github.DNAProject.core.governance.Configuration;
import com.github.DNAProject.core.governance.GlobalParam;
import com.github.DNAProject.core.governance.GlobalParam1;
import com.github.DNAProject.core.governance.GlobalParam2;
import com.github.DNAProject.core.governance.GovernanceView;
import com.github.DNAProject.core.governance.InputPeerPoolMapParam;
import com.github.DNAProject.core.governance.PeerPoolItem;
import com.github.DNAProject.core.governance.SplitCurve;
import com.github.DNAProject.core.sidechaingovernance.SideChainNodeInfo;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import com.github.DNAProject.network.exception.ConnectorException;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.nativevm.PeerAttributes;
import com.github.DNAProject.smartcontract.nativevm.SplitFeeAddress;
import com.github.DNAProject.smartcontract.nativevm.TotalStake;
import com.github.DNAProject.smartcontract.nativevm.abi.NativeBuildParams;
import com.github.DNAProject.smartcontract.nativevm.abi.Struct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Governance {
    private DnaSdk sdk;
    private final String contractAddress = "0000000000000000000000000000000000000007";
    private final String AUTHORIZE_INFO_POOL = "766f7465496e666f506f6f6c";
    private final String PEER_ATTRIBUTES = "peerAttributes";
    private final String SPLIT_FEE_ADDRESS = "splitFeeAddress";
    private final String TOTAL_STAKE = "totalStake";
    private final String PEER_POOL = "peerPool";
    private final String GLOBAL_PARAM = "globalParam";
    private final String GLOBAL_PARAM2 = "globalParam2";
    private final String SPLIT_CURVE = "splitCurve";
    private final String SIDE_CHAIN_NODE_INFO = "sideChainNodeInfo";
    private final String SIDE_GOVERNANCE_CONTRACT_ADDRESS = "0000000000000000000000000000000000000008";
    private final long[] UNBOUND_GENERATION_AMOUNT = new long[]{5L, 4L, 3L, 3L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L};
    private final int UNBOUND_TIME_INTERVAL = 31536000;
    private final long ONT_TOTAL_SUPPLY = 1000000000L;

    public Governance(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public String getContractAddress() {
        return "0000000000000000000000000000000000000007";
    }

    public String registerCandidate(Account account, String peerPubkey, long initPos, String dnaid, String dnaidpwd, byte[] salt, long keyNo, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey, account.getAddressU160(), initPos, dnaid.getBytes(), keyNo));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "registerCandidate", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        this.sdk.addSign(tx, dnaid, dnaidpwd, salt);
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String unRegisterCandidate(Account account, String peerPubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey, account.getAddressU160()));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "unRegisterCandidate", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String withdrawGas(Account account, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(account.getAddressU160()));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "withdrawOng", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String withdrawFee(Account account, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(account.getAddressU160()));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "withdrawFee", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String getPeerInfo(String peerPubkey) throws ConnectorException, IOException {
        return (String)this.getPeerPoolMap(peerPubkey, false);
    }

    public String getPeerInfoAll() throws ConnectorException, IOException {
        return (String)this.getPeerPoolMap(null, false);
    }

    public Map getPeerPoolMap() throws ConnectorException, IOException {
        return (Map)this.getPeerPoolMap(null, true);
    }

    public GovernanceView getGovernanceView() throws ConnectorException, IOException, SDKException {
        String view = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString("governanceView".getBytes()));
        if (view == null || view.equals("")) {
            throw new SDKException(ErrorCode.OtherError("view is null"));
        }
        GovernanceView governanceView = new GovernanceView();
        ByteArrayInputStream bais = new ByteArrayInputStream(Helper.hexToBytes(view));
        BinaryReader br = new BinaryReader(bais);
        governanceView.deserialize(br);
        return governanceView;
    }

    private Object getPeerPoolMap(String peerPubkey, boolean isResultMap) throws ConnectorException, IOException {
        String view = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString("governanceView".getBytes()));
        GovernanceView governanceView = new GovernanceView();
        ByteArrayInputStream bais = new ByteArrayInputStream(Helper.hexToBytes(view));
        BinaryReader br = new BinaryReader(bais);
        governanceView.deserialize(br);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryWriter bw = new BinaryWriter(baos);
        bw.writeInt(governanceView.view);
        byte[] viewBytes = baos.toByteArray();
        byte[] peerPoolBytes = "peerPool".getBytes();
        byte[] keyBytes = new byte[peerPoolBytes.length + viewBytes.length];
        System.arraycopy(peerPoolBytes, 0, keyBytes, 0, peerPoolBytes.length);
        System.arraycopy(viewBytes, 0, keyBytes, peerPoolBytes.length, viewBytes.length);
        String value = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString(keyBytes));
        ByteArrayInputStream bais2 = new ByteArrayInputStream(Helper.hexToBytes(value));
        BinaryReader reader = new BinaryReader(bais2);
        int length = reader.readInt();
        HashMap<String, Object> peerPoolMap = new HashMap<String, Object>();
        HashMap<String, PeerPoolItem> peerPoolMap2 = new HashMap<String, PeerPoolItem>();
        for (int i = 0; i < length; ++i) {
            PeerPoolItem item = new PeerPoolItem();
            item.deserialize(reader);
            peerPoolMap.put(item.peerPubkey, item.Json());
            peerPoolMap2.put(item.peerPubkey, item);
        }
        if (isResultMap) {
            return peerPoolMap2;
        }
        if (peerPubkey != null) {
            if (!peerPoolMap.containsKey(peerPubkey)) {
                return null;
            }
            return JSON.toJSONString(peerPoolMap.get(peerPubkey));
        }
        return JSON.toJSONString(peerPoolMap);
    }

    public String getAuthorizeInfo(String peerPubkey, Address addr) {
        byte[] peerPubkeyPrefix = Helper.hexToBytes(peerPubkey);
        byte[] address = addr.toArray();
        byte[] authorizeInfoPool = Helper.hexToBytes("766f7465496e666f506f6f6c");
        byte[] key = new byte[authorizeInfoPool.length + peerPubkeyPrefix.length + address.length];
        System.arraycopy(authorizeInfoPool, 0, key, 0, authorizeInfoPool.length);
        System.arraycopy(peerPubkeyPrefix, 0, key, authorizeInfoPool.length, peerPubkeyPrefix.length);
        System.arraycopy(address, 0, key, authorizeInfoPool.length + peerPubkeyPrefix.length, address.length);
        String res = null;
        try {
            res = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString(key));
            if (res != null && !res.equals("")) {
                AuthorizeInfo authorizeInfo = Serializable.from(Helper.hexToBytes(res), AuthorizeInfo.class);
                return authorizeInfo.toJson();
            }
        }
        catch (ConnectorException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String approveCandidate(Account adminAccount, String peerPubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "approveCandidate", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{adminAccount}});
        if (!adminAccount.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String approveCandidate(Address multiAddress, int M, Account[] accounts, byte[][] publicKeys, String peerPubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        int i;
        int i2;
        byte[][] pks = new byte[accounts.length + publicKeys.length][];
        for (i2 = 0; i2 < accounts.length; ++i2) {
            pks[i2] = accounts[i2].serializePublicKey();
        }
        for (i2 = 0; i2 < publicKeys.length; ++i2) {
            pks[i2 + accounts.length] = publicKeys[i2];
        }
        if (!multiAddress.equals(Address.addressFromMultiPubKeys(M, pks))) {
            throw new SDKException(ErrorCode.ParamErr("mutilAddress doesnot match accounts and publicKeys"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "approveCandidate", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        Sig[] sigs = new Sig[]{new Sig()};
        sigs[0].pubKeys = new byte[pks.length][];
        sigs[0].sigData = new byte[M][];
        sigs[0].M = M;
        for (i = 0; i < pks.length; ++i) {
            sigs[0].pubKeys[i] = pks[i];
        }
        for (i = 0; i < sigs[0].M; ++i) {
            byte[] signature = tx.sign(accounts[i], accounts[i].getSignatureScheme());
            sigs[0].sigData[i] = signature;
        }
        tx.sigs = sigs;
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String rejectCandidate(Account adminAccount, String peerPubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "rejectCandidate", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{adminAccount}});
        if (!adminAccount.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String rejectCandidate(Address multiAddress, int M, Account[] accounts, byte[][] publicKeys, String peerPubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        int i;
        int i2;
        byte[][] pks = new byte[accounts.length + publicKeys.length][];
        for (i2 = 0; i2 < accounts.length; ++i2) {
            pks[i2] = accounts[i2].serializePublicKey();
        }
        for (i2 = 0; i2 < publicKeys.length; ++i2) {
            pks[i2 + accounts.length] = publicKeys[i2];
        }
        if (!multiAddress.equals(Address.addressFromMultiPubKeys(M, pks))) {
            throw new SDKException(ErrorCode.ParamErr("mutilAddress doesnot match accounts and publicKeys"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "rejectCandidate", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        Sig[] sigs = new Sig[]{new Sig()};
        sigs[0].pubKeys = new byte[pks.length][];
        sigs[0].sigData = new byte[M][];
        sigs[0].M = M;
        for (i = 0; i < pks.length; ++i) {
            sigs[0].pubKeys[i] = pks[i];
        }
        for (i = 0; i < sigs[0].M; ++i) {
            byte[] signature = tx.sign(accounts[i], accounts[i].getSignatureScheme());
            sigs[0].sigData[i] = signature;
        }
        tx.sigs = sigs;
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String authorizeForPeer(Account account, String[] peerPubkey, long[] posList, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        int i;
        if (peerPubkey.length != posList.length) {
            throw new SDKException(ErrorCode.ParamError);
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i2 = 0; i2 < peerPubkey.length; ++i2) {
            map.put(peerPubkey[i2], posList[i2]);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(account.getAddressU160());
        struct.add(peerPubkey.length);
        for (i = 0; i < peerPubkey.length; ++i) {
            struct.add(peerPubkey[i]);
        }
        struct.add(posList.length);
        for (i = 0; i < peerPubkey.length; ++i) {
            struct.add(posList[i]);
        }
        list.add(struct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "authorizeForPeer", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String unAuthorizeForPeer(Account account, String[] peerPubkey, long[] posList, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        int i;
        if (peerPubkey.length != posList.length) {
            throw new SDKException(ErrorCode.ParamError);
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i2 = 0; i2 < peerPubkey.length; ++i2) {
            map.put(peerPubkey[i2], posList[i2]);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(account.getAddressU160());
        struct.add(peerPubkey.length);
        for (i = 0; i < peerPubkey.length; ++i) {
            struct.add(peerPubkey[i]);
        }
        struct.add(posList.length);
        for (i = 0; i < peerPubkey.length; ++i) {
            struct.add(posList[i]);
        }
        list.add(struct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "unAuthorizeForPeer", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String withdraw(Account account, String[] peerPubkey, long[] withdrawList, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        int i;
        if (peerPubkey.length != withdrawList.length) {
            throw new SDKException(ErrorCode.ParamError);
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i2 = 0; i2 < peerPubkey.length; ++i2) {
            map.put(peerPubkey[i2], withdrawList[i2]);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(account.getAddressU160());
        struct.add(peerPubkey.length);
        for (i = 0; i < peerPubkey.length; ++i) {
            struct.add(peerPubkey[i]);
        }
        struct.add(withdrawList.length);
        for (i = 0; i < peerPubkey.length; ++i) {
            struct.add(withdrawList[i]);
        }
        list.add(struct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "withdraw", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String commitDpos(Account adminAccount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "commitDpos", new byte[]{0}, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{adminAccount}});
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String commitDpos(Address multiAddress, int M, Account[] accounts, byte[][] publicKeys, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        int i;
        int i2;
        byte[][] pks = new byte[accounts.length + publicKeys.length][];
        for (i2 = 0; i2 < accounts.length; ++i2) {
            pks[i2] = accounts[i2].serializePublicKey();
        }
        for (i2 = 0; i2 < publicKeys.length; ++i2) {
            pks[i2 + accounts.length] = publicKeys[i2];
        }
        if (!multiAddress.equals(Address.addressFromMultiPubKeys(M, pks))) {
            throw new SDKException(ErrorCode.ParamErr("mutilAddress doesnot match accounts and publicKeys"));
        }
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "commitDpos", new byte[]{0}, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        Sig[] sigs = new Sig[]{new Sig()};
        sigs[0].pubKeys = new byte[pks.length][];
        sigs[0].sigData = new byte[M][];
        sigs[0].M = M;
        for (i = 0; i < pks.length; ++i) {
            sigs[0].pubKeys[i] = pks[i];
        }
        for (i = 0; i < sigs[0].M; ++i) {
            byte[] signature = tx.sign(accounts[i], accounts[i].getSignatureScheme());
            sigs[0].sigData[i] = signature;
        }
        tx.sigs = sigs;
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String blackNode(String peerPubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "blackNode", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{payerAcct}});
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String whiteNode(String peerPubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "whiteNode", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{payerAcct}});
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String quitNode(Account account, String peerPubkey, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey, account.getAddressU160()));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "quitNode", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String changeMaxAuthorization(Account account, String peerPubkey, int maxAuthorize, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey, account.getAddressU160(), maxAuthorize));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "changeMaxAuthorization", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String addInitPos(Account account, String peerPubkey, int pos, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey, account.getAddressU160().toArray(), pos));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "addInitPos", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String reduceInitPos(Account account, String peerPubkey, int pos, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey, account.getAddressU160().toArray(), pos));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "reduceInitPos", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String setPeerCost(Account account, String peerPubkey, int peerCost, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (account == null || peerPubkey == null || peerPubkey.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("gaslimit and gasprice should not be less than 0"));
        }
        if (peerCost < 0 || peerCost > 100) {
            throw new SDKException(ErrorCode.ParamErr("peerCost is wrong, it should be 0 <= peerCost <= 100"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(peerPubkey, account.getAddressU160(), peerCost));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "setPeerCost", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String getPeerAttributes(String peerPubkey) throws ConnectorException, IOException {
        byte[] peerAttributes = "peerAttributes".getBytes();
        byte[] peerPubkeyBytes = Helper.hexToBytes(peerPubkey);
        byte[] key = new byte[peerPubkeyBytes.length + peerAttributes.length];
        System.arraycopy(peerAttributes, 0, key, 0, peerAttributes.length);
        System.arraycopy(peerPubkeyBytes, 0, key, peerAttributes.length, peerPubkeyBytes.length);
        String res = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString(key));
        if (res == null || res.equals("")) {
            PeerAttributes peerAttributes1 = new PeerAttributes(peerPubkey);
            return peerAttributes1.toJson();
        }
        PeerAttributes peerAttributes2 = new PeerAttributes();
        ByteArrayInputStream bais = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader reader = new BinaryReader(bais);
        peerAttributes2.deserialize(reader);
        return peerAttributes2.toJson();
    }

    public String getSplitFeeAddress(String address) throws Exception {
        byte[] splitFeeAddressBytes = "splitFeeAddress".getBytes();
        byte[] addressBytes = Address.decodeBase58(address).toArray();
        byte[] key = new byte[addressBytes.length + splitFeeAddressBytes.length];
        System.arraycopy(splitFeeAddressBytes, 0, key, 0, splitFeeAddressBytes.length);
        System.arraycopy(addressBytes, 0, key, splitFeeAddressBytes.length, addressBytes.length);
        String res = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString(key));
        if (res == null || res.equals("")) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader reader = new BinaryReader(bais);
        SplitFeeAddress splitFeeAddress = new SplitFeeAddress();
        splitFeeAddress.deserialize(reader);
        return splitFeeAddress.toJson();
    }

    public long getPeerUbindOng(String address) throws ConnectorException, IOException, SDKException {
        int timestamp0 = 1530316800;
        int current_height = this.sdk.getConnect().getBlockHeight();
        Block block = this.sdk.getConnect().getBlock(current_height);
        int timestamp = block.timestamp - timestamp0;
        TotalStake totalStake = this.getTotalStake(address);
        if (totalStake == null) {
            return 0L;
        }
        return this.calcUnbindOng(totalStake.stake, totalStake.timeOffset, timestamp);
    }

    public long calcUnbindOng(long balance, int startOffset, int endOffset) {
        long amount = 0L;
        if (startOffset >= endOffset) {
            return 0L;
        }
        int unboundDeadLine = this.unboundDeadLine();
        if (startOffset < unboundDeadLine) {
            int ustart = startOffset / 31536000;
            int istart = startOffset % 31536000;
            if (endOffset >= unboundDeadLine) {
                endOffset = unboundDeadLine;
            }
            int uend = endOffset / 31536000;
            int iend = endOffset % 31536000;
            while (ustart < uend) {
                amount = (long)(31536000 - istart) * this.UNBOUND_GENERATION_AMOUNT[ustart];
                ++ustart;
                istart = 0;
            }
            amount += (long)(iend - istart) * this.UNBOUND_GENERATION_AMOUNT[ustart];
        }
        return amount * balance;
    }

    private int unboundDeadLine() {
        long count = 0L;
        for (long i : this.UNBOUND_GENERATION_AMOUNT) {
            count += i;
        }
        int numInterval = this.UNBOUND_GENERATION_AMOUNT.length;
        return (int)((long)(31536000 * numInterval) - ((count *= 31536000L) - 1000000000L));
    }

    private TotalStake getTotalStake(String address) throws SDKException, ConnectorException, IOException {
        byte[] totalStakeBytes = "totalStake".getBytes();
        byte[] addressBytes = Address.decodeBase58(address).toArray();
        byte[] key = new byte[totalStakeBytes.length + addressBytes.length];
        System.arraycopy(totalStakeBytes, 0, key, 0, totalStakeBytes.length);
        System.arraycopy(addressBytes, 0, key, totalStakeBytes.length, addressBytes.length);
        String res = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString(key));
        if (res == null) {
            return null;
        }
        TotalStake totalStake = new TotalStake();
        ByteArrayInputStream bais = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader reader = new BinaryReader(bais);
        totalStake.deserialize(reader);
        return totalStake;
    }

    public String updateConfig(Account[] accounts, byte[][] pks, int M, Configuration config, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(config.N, config.C, config.K, config.L, config.BlockMsgDelay, config.HashMsgDelay, config.PeerHandshakeTimeout, config.MaxBlockChangeView));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "updateConfig", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{payerAcct}});
        for (Account account : accounts) {
            this.sdk.addMultiSign(tx, M, pks, account);
        }
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String updateSplitCurve(Account[] accounts, byte[][] pks, int M, SplitCurve curve, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(curve.Yi.length);
        for (int i = 0; i < curve.Yi.length; ++i) {
            struct.add(curve.Yi[i]);
        }
        list.add(struct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "updateSplitCurve", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{payerAcct}});
        for (Account account : accounts) {
            this.sdk.addMultiSign(tx, M, pks, account);
        }
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String updateGlobalParam1(Account[] accounts, byte[][] pks, int M, GlobalParam1 param1, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(param1.candidateFee, param1.minInitStake, param1.candidateNum, param1.posLimit, param1.A, param1.B, param1.yita, param1.penalty));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "updateGlobalParam", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{payerAcct}});
        for (Account account : accounts) {
            this.sdk.addMultiSign(tx, M, pks, account);
        }
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String updateGlobalParam2(Account[] accounts, byte[][] pks, int M, GlobalParam2 param2, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(param2.minAuthorizePos, param2.candidateFeeSplitNum, param2.field1, param2.field2, param2.field3, param2.field4, param2.field5, param2.field6));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "updateGlobalParam2", args, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{payerAcct}});
        for (Account account : accounts) {
            this.sdk.addMultiSign(tx, M, pks, account);
        }
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String callSplit(Account payerAcct, long gaslimit, long gasprice) throws Exception {
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000007")), "callSplit", new byte[0], payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{payerAcct}});
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public Configuration getConfiguration() throws ConnectorException, IOException {
        String res = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString("vbftConfig".getBytes()));
        if (res == null) {
            return null;
        }
        Configuration configuration = new Configuration();
        ByteArrayInputStream in = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader reader = new BinaryReader(in);
        configuration.deserialize(reader);
        return configuration;
    }

    public GlobalParam1 getGlobalParam1() throws ConnectorException, IOException {
        String res = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString("globalParam".getBytes()));
        if (res == null || res.equals("")) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader reader = new BinaryReader(in);
        GlobalParam1 globalParam1 = new GlobalParam1();
        globalParam1.deserialize(reader);
        return globalParam1;
    }

    public GlobalParam2 getGlobalParam2() throws ConnectorException, IOException {
        String res2 = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString("globalParam2".getBytes()));
        if (res2 != null && !res2.equals("")) {
            GlobalParam2 globalParam2 = new GlobalParam2();
            ByteArrayInputStream in2 = new ByteArrayInputStream(Helper.hexToBytes(res2));
            BinaryReader reader2 = new BinaryReader(in2);
            globalParam2.deserialize(reader2);
            return globalParam2;
        }
        return null;
    }

    public GlobalParam getGlobalParam() throws ConnectorException, IOException {
        String res = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString("globalParam".getBytes()));
        if (res == null || res.equals("")) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader reader = new BinaryReader(in);
        GlobalParam1 globalParam1 = new GlobalParam1();
        globalParam1.deserialize(reader);
        String res2 = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString("globalParam2".getBytes()));
        GlobalParam2 globalParam2 = null;
        if (res2 != null && !res2.equals("")) {
            globalParam2 = new GlobalParam2();
            ByteArrayInputStream in2 = new ByteArrayInputStream(Helper.hexToBytes(res2));
            BinaryReader reader2 = new BinaryReader(in);
            globalParam2.deserialize(reader2);
        }
        GlobalParam param = new GlobalParam();
        param.candidateFeeSplitNum = globalParam2 != null ? globalParam2.candidateFeeSplitNum : globalParam1.candidateNum;
        param.A = globalParam1.A;
        param.B = globalParam1.B;
        param.yita = globalParam1.yita;
        return param;
    }

    public SplitCurve getSplitCurve() throws ConnectorException, IOException {
        String res = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000007"), Helper.toHexString("splitCurve".getBytes()));
        SplitCurve curve = new SplitCurve();
        ByteArrayInputStream in = new ByteArrayInputStream(Helper.hexToBytes(res));
        BinaryReader reader = new BinaryReader(in);
        curve.deserialize(reader);
        return curve;
    }

    public InputPeerPoolMapParam getInputPeerPoolMapParam(String sideChainId) throws ConnectorException, IOException, SDKException {
        Map peerPoolMap = this.getPeerPoolMap();
        byte[] sideChainIdBytes = sideChainId.getBytes();
        byte[] sideChainNodeInfoBytes = "sideChainNodeInfo".getBytes();
        byte[] key = new byte[sideChainIdBytes.length + sideChainNodeInfoBytes.length];
        System.arraycopy(sideChainNodeInfoBytes, 0, key, 0, sideChainNodeInfoBytes.length);
        System.arraycopy(sideChainIdBytes, 0, key, sideChainNodeInfoBytes.length, sideChainIdBytes.length);
        String resNode = this.sdk.getConnect().getStorage(Helper.reverse("0000000000000000000000000000000000000008"), Helper.toHexString(key));
        if (resNode == null || resNode.equals("")) {
            throw new SDKException(ErrorCode.OtherError("NodeToSideChainParams is null"));
        }
        SideChainNodeInfo info = new SideChainNodeInfo();
        ByteArrayInputStream in = new ByteArrayInputStream(Helper.hexToBytes(resNode));
        BinaryReader reader = new BinaryReader(in);
        info.deserialize(reader);
        InputPeerPoolMapParam param = new InputPeerPoolMapParam(peerPoolMap, info.nodeInfoMap);
        return param;
    }
}

