/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm.abi;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.nativevm.abi.Struct;
import com.github.DNAProject.smartcontract.nativevm.abi.SubType;
import java.util.List;

public class Parameter {
    public String name;
    public String type;
    public SubType[] subType;
    public String value;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public SubType[] getSubType() {
        return this.subType;
    }

    public boolean setValue(Object value) {
        try {
            if (value == null) {
                this.value = null;
            } else if ("Byte".equals(this.type)) {
                byte tmp = (Byte)value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if ("ByteArray".equals(this.type)) {
                byte[] tmp = (byte[])value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if ("String".equals(this.type)) {
                this.value = (String)value;
            } else if ("Bool".equals(this.type)) {
                boolean tmp = (Boolean)value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if ("Int".equals(this.type)) {
                long tmp = (Long)value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if ("Array".equals(this.type)) {
                List tmp = (List)value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if (!"Uint256".equals(this.type) && !"Address".equals(this.type)) {
                if ("Struct".equals(this.type)) {
                    Struct tmp = (Struct)value;
                    for (int i = 0; i < tmp.list.size(); ++i) {
                        this.subType[i] = new SubType();
                        this.subType[i].setParamsValue(tmp.list);
                    }
                } else {
                    throw new SDKException(ErrorCode.TypeError);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

