/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.neovm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.neovm.abi.AbiFunction;
import com.github.DNAProject.smartcontract.neovm.abi.AbiInfo;
import com.github.DNAProject.smartcontract.neovm.abi.BuildParams;
import com.github.DNAProject.smartcontract.neovm.oep8.Oep8State;
import com.github.DNAProject.smartcontract.neovm.oep8.TransferFrom;
import java.math.BigInteger;
import java.util.ArrayList;

public class Oep8 {
    private DnaSdk sdk;
    private String contractAddress = null;
    private String oep8abi = "{\"contractHash\":\"a2054b2d84a87190ea3a96e122e0710e95da36f3\",\"functions\":[{\"name\":\"Revert\",\"parameters\":[{\"name\":\"\",\"type\":\"\"}],\"returntype\":\"\"},{\"name\":\"Require\",\"parameters\":[{\"name\":\"condition\",\"type\":\"\"}],\"returntype\":\"\"},{\"name\":\"RequireScriptHash\",\"parameters\":[{\"name\":\"key\",\"type\":\"\"}],\"returntype\":\"\"},{\"name\":\"RequireWitness\",\"parameters\":[{\"name\":\"witness\",\"type\":\"\"}],\"returntype\":\"\"},{\"name\":\"Main\",\"parameters\":[{\"name\":\"operation\",\"type\":\"\"},{\"name\":\"args\",\"type\":\"\"}],\"returntype\":\"\"},{\"name\":\"name\",\"parameters\":[{\"name\":\"tokenId\",\"type\":\"ByteArray\"}],\"returntype\":\"\"},{\"name\":\"symbol\",\"parameters\":[{\"name\":\"tokenId\",\"type\":\"ByteArray\"}],\"returntype\":\"\"},{\"name\":\"totalSupply\",\"parameters\":[{\"name\":\"tokenId\",\"type\":\"ByteArray\"}],\"returntype\":\"\"},{\"name\":\"balanceOf\",\"parameters\":[{\"name\":\"acct\",\"type\":\"ByteArray\"},{\"name\":\"tokenId\",\"type\":\"ByteArray\"}],\"returntype\":\"\"},{\"name\":\"transfer\",\"parameters\":[{\"name\":\"fromAcct\",\"type\":\"ByteArray\"},{\"name\":\"toAcct\",\"type\":\"ByteArray\"},{\"name\":\"tokenId\",\"type\":\"ByteArray\"},{\"name\":\"amount\",\"type\":\"Integer\"}],\"returntype\":\"\"},{\"name\":\"transferMulti\",\"parameters\":[{\"name\":\"args\",\"type\":\"\"}],\"returntype\":\"\"},{\"name\":\"approve\",\"parameters\":[{\"name\":\"owner\",\"type\":\"ByteArray\"},{\"name\":\"spender\",\"type\":\"ByteArray\"},{\"name\":\"tokenId\",\"type\":\"ByteArray\"},{\"name\":\"amount\",\"type\":\"Integer\"}],\"returntype\":\"\"},{\"name\":\"approveMulti\",\"parameters\":[{\"name\":\"args\",\"type\":\"ByteArray\"}],\"returntype\":\"\"},{\"name\":\"allowance\",\"parameters\":[{\"name\":\"owner\",\"type\":\"ByteArray\"},{\"name\":\"spender\",\"type\":\"ByteArray\"},{\"name\":\"tokenId\",\"type\":\"ByteArray\"}],\"returntype\":\"\"},{\"name\":\"transferFrom\",\"parameters\":[{\"name\":\"spender\",\"type\":\"ByteArray\"},{\"name\":\"fromAcct\",\"type\":\"ByteArray\"},{\"name\":\"toAcct\",\"type\":\"ByteArray\"},{\"name\":\"tokenId\",\"type\":\"ByteArray\"},{\"name\":\"amount\",\"type\":\"Integer\"}],\"returntype\":\"\"},{\"name\":\"transferFromMulti\",\"parameters\":[{\"name\":\"args\",\"type\":\"Array\"}],\"returntype\":\"\"},{\"name\":\"concatkey\",\"parameters\":[{\"name\":\"str1\",\"type\":\"\"},{\"name\":\"str2\",\"type\":\"\"}],\"returntype\":\"\"},{\"name\":\"init\",\"parameters\":[],\"returntype\":\"\"},{\"name\":\"mint\",\"parameters\":[{\"name\":\"tokenId\",\"type\":\"ByteArray\"},{\"name\":\"tokenAmount\",\"type\":\"Integer\"}],\"returntype\":\"\"},{\"name\":\"createMultiTypeToken\",\"parameters\":[{\"name\":\"\",\"type\":\"Array\"}],\"returntype\":\"\"},{\"name\":\"totalBalanceOf\",\"parameters\":[{\"name\":\"account\",\"type\":\"ByteArray\"}],\"returntype\":\"\"},{\"name\":\"balancesOf\",\"parameters\":[{\"name\":\"account\",\"type\":\"ByteArray\"}],\"returntype\":\"\"},{\"name\":\"compound\",\"parameters\":[{\"name\":\"acct\",\"type\":\"ByteArray\"},{\"name\":\"compoundOneOrAll\",\"type\":\"Integer\"}],\"returntype\":\"\"},{\"name\":\"checkTokenId\",\"parameters\":[{\"name\":\"tokenId\",\"type\":\"ByteArray\"}],\"returntype\":\"\"}]}";

    public Oep8(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public void setContractAddress(String codeHash) {
        this.contractAddress = codeHash.replace("0x", "");
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String sendInit(Account acct, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return (String)this.sendInit(acct, payerAcct, gaslimit, gasprice, false);
    }

    public long sendInitPreExec(Account acct, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return (Long)this.sendInit(acct, payerAcct, gaslimit, gasprice, true);
    }

    private Object sendInit(Account acct, Account payerAcct, long gaslimit, long gasprice, boolean preExec) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("init");
        if (preExec) {
            Object obj;
            byte[] params = BuildParams.serializeAbiFunction(func);
            InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(this.getContractAddress(), null, params, null, 0L, 0L);
            if (acct != null) {
                this.sdk.signTx(tx, new Account[][]{{acct}});
            }
            if (Integer.parseInt(((JSONObject)(obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString()))).getString("Result")) != 1) {
                throw new SDKException(ErrorCode.OtherError("sendRawTransaction PreExec error: " + obj));
            }
            return ((JSONObject)obj).getLong("Gas");
        }
        if (acct == null || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamError);
        }
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), acct, payerAcct, gaslimit, gasprice, func, preExec);
        return obj;
    }

    public String sendTransfer(Account acct, String recvAddr, byte[] tokenId, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return (String)this.sendTransfer(acct, recvAddr, tokenId, amount, payerAcct, gaslimit, gasprice, false);
    }

    public long sendTransferPreExec(Account acct, String recvAddr, byte[] tokenId, long amount) throws Exception {
        return (Long)this.sendTransfer(acct, recvAddr, tokenId, amount, acct, 0L, 0L, true);
    }

    private Object sendTransfer(Account acct, String recvAddr, byte[] tokenId, long amount, Account payerAcct, long gaslimit, long gasprice, boolean preExec) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (acct == null || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        String sendAddr = acct.getAddressU160().toBase58();
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("transfer");
        func.setParamsValue(Address.decodeBase58(sendAddr).toArray(), Address.decodeBase58(recvAddr).toArray(), tokenId, amount);
        if (preExec) {
            byte[] params = BuildParams.serializeAbiFunction(func);
            InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(Helper.reverse(this.contractAddress), null, params, null, 0L, 0L);
            this.sdk.signTx(tx, new Account[][]{{acct}});
            Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
            if (Integer.parseInt(((JSONObject)obj).getString("Result")) != 1) {
                throw new SDKException(ErrorCode.OtherError("sendRawTransaction PreExec error: " + obj));
            }
            return ((JSONObject)obj).getLong("Gas");
        }
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), acct, payerAcct, gaslimit, gasprice, func, preExec);
        return obj;
    }

    public Transaction makeTransfer(String sendAddr, String recvAddr, byte[] tokenId, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (sendAddr == null || sendAddr.equals("") || recvAddr == null || recvAddr.equals("") || amount <= 0L || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("transfer");
        func.setParamsValue(Address.decodeBase58(sendAddr).toArray(), Address.decodeBase58(recvAddr).toArray(), tokenId, amount);
        byte[] params = BuildParams.serializeAbiFunction(func);
        String payer = payerAcct.getAddressU160().toBase58();
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(Helper.reverse(this.contractAddress), null, params, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendTransferMulti(Account[] accounts, Oep8State[] states, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (accounts == null || states == null || payerAcct == null) {
            throw new SDKException("params should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeTransferMulti(states, payerAcct, gaslimit, gasprice);
        boolean haspayer = false;
        for (Account account : accounts) {
            if (account.equals(payerAcct)) {
                haspayer = true;
            }
            this.sdk.addSign(tx, account);
        }
        if (!haspayer) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (!(b = this.sdk.getConnect().sendRawTransaction(tx.toHexString()))) {
            throw new SDKException(ErrorCode.SendRawTxError);
        }
        return tx.hash().toHexString();
    }

    public Transaction makeTransferMulti(Oep8State[] states, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (states == null || payerAcct == null) {
            throw new SDKException("params should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add("transferMulti".getBytes());
        ArrayList tempList = new ArrayList();
        for (Oep8State state : states) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(state.from);
            list.add(state.to);
            list.add(state.tokenId);
            list.add(state.value);
            tempList.add(list);
        }
        paramList.add(tempList);
        byte[] params = BuildParams.createCodeParamsScript(paramList);
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(Helper.reverse(this.contractAddress), null, params, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        return tx;
    }

    public String sendApprove(Account owner, String spender, byte[] tokenId, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (owner == null || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("approve");
        func.setParamsValue(owner.getAddressU160().toArray(), Address.decodeBase58(spender).toArray(), tokenId, amount);
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), owner, payerAcct, gaslimit, gasprice, func, false);
        return (String)obj;
    }

    public Transaction makeApprove(String owner, String spender, byte[] tokenId, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (owner == null || owner.equals("") || spender == null || spender.equals("") || amount <= 0L || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("approve");
        func.setParamsValue(Address.decodeBase58(owner).toArray(), Address.decodeBase58(spender).toArray(), tokenId, amount);
        byte[] params = BuildParams.serializeAbiFunction(func);
        String payer = payerAcct.getAddressU160().toBase58();
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(Helper.reverse(this.contractAddress), null, params, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendApproveMulti(Account[] owner, Oep8State[] states, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (owner == null || owner.equals("") || states == null || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        Transaction tx = this.makeApproveMulti(states, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        boolean haspayer = false;
        for (Account account : owner) {
            if (account.equals(payerAcct)) {
                haspayer = true;
            }
            this.sdk.addSign(tx, account);
        }
        if (!haspayer) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (!(b = this.sdk.getConnect().sendRawTransaction(tx.toHexString()))) {
            throw new SDKException(ErrorCode.SendRawTxError);
        }
        return tx.hash().toHexString();
    }

    public Transaction makeApproveMulti(Oep8State[] states, String payerAcct, long gaslimit, long gasprice) throws Exception {
        if (states == null || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add("approveMulti".getBytes());
        ArrayList tempList = new ArrayList();
        for (Oep8State state : states) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(state.from);
            list.add(state.to);
            list.add(state.tokenId);
            list.add(state.value);
            tempList.add(list);
        }
        paramList.add(tempList);
        byte[] params = BuildParams.createCodeParamsScript(paramList);
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(Helper.reverse(this.contractAddress), null, params, payerAcct, gaslimit, gasprice);
        return tx;
    }

    public String sendTransferFromMulti(Account[] sender, TransferFrom[] states, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (sender == null || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        Transaction tx = this.makeTransferFromMulti(states, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        boolean haspayer = false;
        for (Account account : sender) {
            if (account.equals(payerAcct)) {
                haspayer = true;
            }
            this.sdk.addSign(tx, account);
        }
        if (!haspayer) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (!(b = this.sdk.getConnect().sendRawTransaction(tx.toHexString()))) {
            throw new SDKException(ErrorCode.SendRawTxError);
        }
        return tx.hash().toHexString();
    }

    public Transaction makeTransferFromMulti(TransferFrom[] states, String payerAcct, long gaslimit, long gasprice) throws Exception {
        if (states == null || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add("transferFromMulti".getBytes());
        ArrayList tempList = new ArrayList();
        for (TransferFrom state : states) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(state.spender);
            list.add(state.from);
            list.add(state.to);
            list.add(state.tokenId);
            list.add(state.value);
            tempList.add(list);
        }
        paramList.add(tempList);
        byte[] params = BuildParams.createCodeParamsScript(paramList);
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(Helper.reverse(this.contractAddress), null, params, payerAcct, gaslimit, gasprice);
        return tx;
    }

    public String sendTransferFrom(Account sender, String from, String to, byte[] tokenId, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (sender == null || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("transferFrom");
        func.name = "transferFrom";
        func.setParamsValue(sender.getAddressU160().toArray(), Address.decodeBase58(from).toArray(), Address.decodeBase58(to).toArray(), tokenId, amount);
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), sender, payerAcct, gaslimit, gasprice, func, false);
        return (String)obj;
    }

    public Transaction makeTransferFrom(String sender, String from, String to, byte[] tokenId, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (sender == null || sender.equals("") || from == null || from.equals("") || to == null || to.equals("") || amount <= 0L || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("transferFrom");
        func.name = "transferFrom";
        func.setParamsValue(Address.decodeBase58(sender).toArray(), Address.decodeBase58(from).toArray(), Address.decodeBase58(to).toArray(), tokenId, amount);
        byte[] params = BuildParams.serializeAbiFunction(func);
        String payer = payerAcct.getAddressU160().toBase58();
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(Helper.reverse(this.contractAddress), null, params, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendCompound(Account account, long compoundOneOrAll, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (account == null || payerAcct == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("compound");
        func.setParamsValue(account.getAddressU160().toArray(), compoundOneOrAll);
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), account, payerAcct, gaslimit, gasprice, func, false);
        return (String)obj;
    }

    public String queryAllowance(String owner, String spender, byte[] tokenId) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (owner == null || owner.equals("") || spender == null || spender.equals("")) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("allowance");
        func.name = "allowance";
        func.setParamsValue(Address.decodeBase58(owner).toArray(), Address.decodeBase58(spender).toArray(), tokenId);
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), null, null, 0L, 0L, func, true);
        String balance = ((JSONObject)obj).getString("Result");
        if (balance == null || balance.equals("")) {
            return BigInteger.ZERO.toString();
        }
        return Helper.BigIntFromNeoBytes(Helper.hexToBytes(balance)).toString();
    }

    public String queryBalanceOf(String addr, byte[] tokenId) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (addr == null || addr.equals("")) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("balanceOf");
        func.name = "balanceOf";
        func.setParamsValue(Address.decodeBase58(addr).toArray(), tokenId);
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), null, null, 0L, 0L, func, true);
        String balance = ((JSONObject)obj).getString("Result");
        if (balance.equals("")) {
            balance = BigInteger.ZERO.toString();
        }
        return Helper.BigIntFromNeoBytes(Helper.hexToBytes(balance)).toString();
    }

    public String queryTotalSupply(byte[] tokenId) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("totalSupply");
        func.name = "totalSupply";
        func.setParamsValue(new Object[]{tokenId});
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), null, null, 0L, 0L, func, true);
        String total = ((JSONObject)obj).getString("Result");
        if (total.equals("")) {
            return BigInteger.ZERO.toString();
        }
        return Helper.BigIntFromNeoBytes(Helper.hexToBytes(total)).toString();
    }

    public String queryName(byte[] tokenId) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("name");
        func.setParamsValue(new Object[]{tokenId});
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), null, null, 0L, 0L, func, true);
        return new String(Helper.hexToBytes(((JSONObject)obj).getString("Result")));
    }

    public String querySymbol(byte[] tokenId) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("symbol");
        func.name = "symbol";
        func.setParamsValue(new Object[]{tokenId});
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), null, null, 0L, 0L, func, true);
        return new String(Helper.hexToBytes(((JSONObject)obj).getString("Result")));
    }

    public String balancesOf(String address) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("balancesOf");
        func.setParamsValue(new Object[]{Address.decodeBase58(address).toArray()});
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), null, null, 0L, 0L, func, true);
        JSONArray res = ((JSONObject)obj).getJSONArray("Result");
        ArrayList<String> resList = new ArrayList<String>();
        for (Object i : res) {
            if (!((String)i).equals("")) {
                resList.add(Helper.BigIntFromNeoBytes(Helper.hexToBytes((String)i)).toString());
                continue;
            }
            resList.add(BigInteger.ZERO.toString());
        }
        return JSON.toJSONString(resList);
    }

    public String totalBalanceOf(String address) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("totalBalanceOf");
        func.setParamsValue(new Object[]{Address.decodeBase58(address).toArray()});
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), null, null, 0L, 0L, func, true);
        String totalBalance = ((JSONObject)obj).getString("Result");
        return Helper.BigIntFromNeoBytes(Helper.hexToBytes(totalBalance)).toString();
    }

    public String mint(Account adminAccount, byte[] tokenId, long amount, Account payer, long gaslimit, long gasprice) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (adminAccount == null || payer == null || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.oep8abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("mint");
        func.setParamsValue(tokenId, amount);
        Object obj = this.sdk.neovm().sendTransaction(Helper.reverse(this.contractAddress), adminAccount, payer, gaslimit, gasprice, func, false);
        return (String)obj;
    }
}

