/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.neovm.abi;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.neovm.abi.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AbiFunction {
    public String name;
    public String returntype;
    public List<Parameter> parameters = new ArrayList<Parameter>();

    public AbiFunction() {
    }

    public AbiFunction(String name, Parameter ... parameters) {
        this.name = name;
        this.returntype = "String";
        this.parameters = Arrays.asList(parameters);
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParamsValue(Object ... objs) throws Exception {
        if (objs.length != this.parameters.size()) {
            throw new SDKException(ErrorCode.ParamError);
        }
        for (int i = 0; i < objs.length; ++i) {
            this.parameters.get(i).setValue(objs[i]);
        }
    }

    public Parameter getParameter(String name) {
        for (Parameter e : this.parameters) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public void clearParamsValue() {
        for (Parameter e : this.parameters) {
            e.setValue(null);
        }
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

