/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.neovm.abi;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.neovm.abi.Struct;
import java.util.List;
import java.util.Map;

public class Parameter {
    public String name;
    public String type;
    public String value;

    public Parameter(String name, Type type, Object value) {
        this.name = name;
        this.type = type.name();
        this.setValue(value);
    }

    public Parameter() {
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean setValue(Object value) {
        try {
            if (value == null) {
                this.value = null;
            } else if ("ByteArray".equals(this.type)) {
                byte[] tmp = (byte[])value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if ("String".equals(this.type)) {
                this.value = (String)value;
            } else if ("Boolean".equals(this.type)) {
                boolean tmp = (Boolean)value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if ("Integer".equals(this.type)) {
                long tmp = (Long)value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if ("Array".equals(this.type)) {
                List tmp = (List)value;
                for (int i = 0; i < tmp.size(); ++i) {
                    if (!(tmp.get(i) instanceof String)) continue;
                    tmp.set(i, ((String)tmp.get(i)).getBytes());
                }
                this.value = JSON.toJSONString((Object)tmp);
            } else if ("InteropInterface".equals(this.type)) {
                Object tmp = value;
                this.value = JSON.toJSONString((Object)tmp);
            } else if (!"Void".equals(this.type)) {
                if ("Map".equals(this.type)) {
                    Map tmp = (Map)value;
                    this.value = JSON.toJSONString((Object)tmp);
                } else if ("Struct".equals(this.type)) {
                    Struct tmp = (Struct)value;
                    this.value = JSON.toJSONString((Object)tmp);
                } else {
                    throw new SDKException(ErrorCode.TypeError);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public static enum Type {
        ByteArray,
        String,
        Boolean,
        Integer,
        Array,
        InteropInterface,
        Void,
        Main,
        Struct;

    }
}

