/*
 * Decompiled with CFR 0.152.
 */
package example;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.sdk.manager.ECIES;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;

public class ECIESDemo {
    public static void main(String[] args) {
        try {
            DnaSdk dnaSdk = ECIESDemo.getDnaSdk();
            Account account = new Account(Helper.hexToBytes("9a31d585431ce0aa0aab1f0a432142e98a92afccb7bcbcaff53f758df82acdb3"), dnaSdk.defaultSignScheme);
            System.out.println("PrivateKey:" + Helper.toHexString(account.serializePrivateKey()));
            System.out.println("PublicKey:" + Helper.toHexString(account.serializePublicKey()));
            ECIES.setDigest((Digest)new SHA256Digest());
            byte[] msg = new String("1234567890").getBytes();
            String[] ret = ECIES.Encrypt(Helper.toHexString(account.serializePublicKey()), msg);
            byte[] msg2 = ECIES.Decrypt(Helper.toHexString(account.serializePrivateKey()), ret);
            System.out.println("Msg:" + Helper.toHexString(msg));
            System.out.println("Encrypted:" + JSON.toJSONString((Object)ret));
            System.out.println("Decrypt:" + Helper.toHexString(msg2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.openWalletFile("Demo3.json");
        return wm;
    }
}

