/*
 * Decompiled with CFR 0.152.
 */
package example.dnaid;

import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.sdk.wallet.Identity;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ClaimDemo {
    public static void main(String[] args) {
        try {
            DnaSdk dnaSdk = ClaimDemo.getDnaSdk();
            String privatekey0 = "523c5fcf74823831756f0bcb3634234f10b3beb1c05595058534577752ad2d9f";
            Account acct0 = new Account(Helper.hexToBytes(privatekey0), dnaSdk.defaultSignScheme);
            System.out.println(dnaSdk.getConnect().getBalance(acct0.getAddressU160().toBase58()));
            dnaSdk.getWalletMgr().getWallet().clearIdentity();
            dnaSdk.getWalletMgr().writeWallet();
            List<Identity> dids = dnaSdk.getWalletMgr().getWallet().getIdentities();
            if (dids.size() < 2) {
                Identity identity = dnaSdk.getWalletMgr().createIdentity("passwordtest");
                dnaSdk.nativevm().dnaId().sendRegister(identity, "passwordtest", acct0, 20000L, 500L);
                identity = dnaSdk.getWalletMgr().createIdentity("passwordtest");
                dnaSdk.nativevm().dnaId().sendRegister(identity, "passwordtest", acct0, 20000L, 500L);
                dids = dnaSdk.getWalletMgr().getWallet().getIdentities();
                dnaSdk.getWalletMgr().writeWallet();
                Thread.sleep(6000L);
            }
            HashMap<String, String> metaDataMap = new HashMap<String, String>();
            metaDataMap.put("Issuer", dids.get((int)0).dnaid);
            metaDataMap.put("Subject", dids.get((int)1).dnaid);
            HashMap<String, String> clvMap = new HashMap<String, String>();
            clvMap.put("typ", "AttestContract");
            clvMap.put("addr", "8055b362904715fd84536e754868f4c8d27ca3f6");
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(1, 1);
            long expires = c.getTimeInMillis() / 1000L;
            HashMap<String, Object> claimInfoMap = new HashMap<String, Object>();
            claimInfoMap.put("name", "Bob Dylan");
            claimInfoMap.put("age", "22");
            String claim = dnaSdk.nativevm().dnaId().createDnaIdClaim(dids.get((int)0).dnaid, "passwordtest", dids.get((int)0).controls.get(0).getSalt(), "claim:context", claimInfoMap, metaDataMap, clvMap, expires);
            System.out.println(claim);
            System.out.println(new String(Base64.getDecoder().decode(claim.split("\\.")[1])));
            boolean b = dnaSdk.nativevm().dnaId().verifyDnaIdClaim(claim);
            System.out.println(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.openWalletFile("ClaimDemo.json");
        return wm;
    }
}

