/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.common;

import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.function.Function;

public class Fixed8
implements Comparable<Fixed8>,
Serializable {
    public static final Fixed8 MAX_VALUE = new Fixed8(Long.MAX_VALUE);
    public static final Fixed8 MIN_VALUE = new Fixed8(Long.MIN_VALUE);
    public static final Fixed8 SATOSHI = new Fixed8(1L);
    public static final Fixed8 ZERO = new Fixed8(0L);
    public static int DefaultPrecision = 8;
    private static final long D = (long)Math.pow(10.0, DefaultPrecision);
    public static final Fixed8 ONE = new Fixed8(D);
    private long value;

    public Fixed8() {
        this(0L);
    }

    public Fixed8(long data) {
        this.value = data;
    }

    public static Fixed8 fromDecimal(BigDecimal val) {
        return new Fixed8(val.multiply(new BigDecimal(D)).longValueExact());
    }

    public static Fixed8 fromLong(long val) {
        if (val < 0L || val > Long.MAX_VALUE / D) {
            throw new IllegalArgumentException();
        }
        return new Fixed8(val * D);
    }

    public static Fixed8 parse(String s) {
        return Fixed8.fromDecimal(new BigDecimal(s));
    }

    public static Fixed8 max(Fixed8 first, Fixed8 ... others) {
        for (Fixed8 other : others) {
            if (first.compareTo(other) >= 0) continue;
            first = other;
        }
        return first;
    }

    public static Fixed8 min(Fixed8 first, Fixed8 ... others) {
        for (Fixed8 other : others) {
            if (first.compareTo(other) <= 0) continue;
            first = other;
        }
        return first;
    }

    public static Fixed8 sum(Fixed8[] values) {
        return Fixed8.sum(values, p -> p);
    }

    public static <T> Fixed8 sum(T[] values, Function<T, Fixed8> selector) {
        Fixed8 sum = ZERO;
        for (T item : values) {
            sum = sum.add(selector.apply(item));
        }
        return sum;
    }

    public static boolean tryParse(String s, Fixed8 result) {
        try {
            BigDecimal val = new BigDecimal(s);
            result.value = val.longValueExact();
            return true;
        }
        catch (ArithmeticException | NumberFormatException ex) {
            return false;
        }
    }

    public Fixed8 abs() {
        if (this.value >= 0L) {
            return this;
        }
        return new Fixed8(-this.value);
    }

    @Override
    public int compareTo(Fixed8 other) {
        return Long.compare(this.value, other.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Fixed8)) {
            return false;
        }
        return this.value == ((Fixed8)obj).value;
    }

    public long getData() {
        return this.value;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    public String toString() {
        BigDecimal v = new BigDecimal(this.value);
        v = v.divide(new BigDecimal(D), DefaultPrecision, 7);
        return v.toPlainString();
    }

    public long toLong() {
        return this.value / D;
    }

    public Fixed8 multiply(long other) {
        return new Fixed8(this.value * other);
    }

    public Fixed8 divide(long other) {
        return new Fixed8(this.value / other);
    }

    public Fixed8 add(Fixed8 other) {
        return new Fixed8(Math.addExact(this.value, other.value));
    }

    public Fixed8 subtract(Fixed8 other) {
        return new Fixed8(Math.subtractExact(this.value, other.value));
    }

    public Fixed8 negate() {
        return new Fixed8(-this.value);
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeLong(this.value);
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        this.value = reader.readLong();
    }
}

