/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core;

import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.core.Signable;
import com.github.DNAProject.crypto.SignatureScheme;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import java.io.IOException;

public class DataSignature
implements Signable {
    private Account account;
    private byte[] data;
    private SignatureScheme scheme;

    public DataSignature() {
    }

    public DataSignature(byte[] data) {
        this.data = data;
    }

    public DataSignature(SignatureScheme scheme, Account acct, byte[] data) {
        this.scheme = scheme;
        this.account = acct;
        this.data = data;
    }

    public DataSignature(SignatureScheme scheme, Account acct, String data) {
        this.scheme = scheme;
        this.account = acct;
        this.data = data.getBytes();
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] signature() {
        try {
            byte[] signData = this.sign(this.account, this.scheme);
            return signData;
        }
        catch (Exception e) {
            throw new RuntimeException(ErrorCode.DataSignatureErr);
        }
    }

    @Override
    public byte[] sign(Account account, SignatureScheme scheme) throws Exception {
        return account.generateSignature(this.getHashData(), scheme, null);
    }

    @Override
    public boolean verifySignature(Account account, byte[] data, byte[] signature) throws Exception {
        return account.verifySignature(data, signature);
    }

    @Override
    public Address[] getAddressU160ForVerifying() {
        return null;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
    }

    @Override
    public void deserializeUnsigned(BinaryReader reader) throws IOException {
    }

    @Override
    public void serializeUnsigned(BinaryWriter writer) throws IOException {
        writer.write(this.data);
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
    }
}

