/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.payload;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.core.transaction.TransactionType;
import com.github.DNAProject.crypto.ECC;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;

public class Enrollment
extends Transaction {
    public ECPoint pubKey;

    public Enrollment() {
        super(TransactionType.Enrollment);
    }

    @Override
    protected void deserializeExclusiveData(BinaryReader reader) throws IOException {
        try {
            this.pubKey = ECC.secp256r1.getCurve().createPoint(new BigInteger(1, reader.readVarBytes()), new BigInteger(1, reader.readVarBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Address[] getAddressU160ForVerifying() {
        return null;
    }

    @Override
    protected void serializeExclusiveData(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(Helper.removePrevZero(this.pubKey.getXCoord().toBigInteger().toByteArray()));
        writer.writeVarBytes(Helper.removePrevZero(this.pubKey.getYCoord().toBigInteger().toByteArray()));
    }
}

