/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.program;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.program.ProgramInfo;
import com.github.DNAProject.core.scripts.ScriptBuilder;
import com.github.DNAProject.core.scripts.ScriptOp;
import com.github.DNAProject.crypto.ECC;
import com.github.DNAProject.crypto.KeyType;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.sdk.exception.SDKException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.bouncycastle.math.ec.ECPoint;

public class Program {
    public static byte[] ProgramFromParams(byte[][] sigData) throws IOException {
        ScriptBuilder sb = new ScriptBuilder();
        for (byte[] sig : sigData = (byte[][])Arrays.stream(sigData).sorted((o1, o2) -> Helper.toHexString(o1).compareTo(Helper.toHexString(o2))).toArray(x$0 -> new byte[x$0][])) {
            sb.emitPushByteArray(sig);
        }
        return sb.toArray();
    }

    public static byte[] ProgramFromPubKey(byte[] publicKey) throws Exception {
        ScriptBuilder sb = new ScriptBuilder();
        sb.emitPushByteArray(publicKey);
        sb.add(ScriptOp.OP_CHECKSIG);
        return sb.toArray();
    }

    public static byte[] ProgramFromMultiPubKey(int m, byte[] ... publicKeys) throws Exception {
        int n = publicKeys.length;
        if (m <= 0 || m > n || n > 16) {
            throw new SDKException(ErrorCode.ParamError);
        }
        try (ScriptBuilder sb = new ScriptBuilder();){
            sb.emitPushInteger(BigInteger.valueOf(m));
            for (byte[] publicKey : publicKeys = Program.sortPublicKeys(publicKeys)) {
                sb.emitPushByteArray(publicKey);
            }
            sb.emitPushInteger(BigInteger.valueOf(publicKeys.length));
            sb.add(ScriptOp.OP_CHECKMULTISIG);
            byte[] byArray = sb.toArray();
            return byArray;
        }
    }

    public static byte[][] sortPublicKeys(byte[] ... publicKeys) {
        publicKeys = (byte[][])Arrays.stream(publicKeys).sorted((o1, o2) -> {
            if (KeyType.fromPubkey(o1).getLabel() != KeyType.fromPubkey(o2).getLabel()) {
                return KeyType.fromPubkey(o1).getLabel() >= KeyType.fromPubkey(o2).getLabel() ? 1 : -1;
            }
            switch (KeyType.fromPubkey(o1)) {
                case SM2: {
                    byte[] p = new byte[33];
                    System.arraycopy(o1, 2, p, 0, p.length);
                    o1 = p;
                    byte[] p2 = new byte[33];
                    System.arraycopy(o2, 2, p2, 0, p2.length);
                    o2 = p2;
                    ECPoint smPk1 = ECC.sm2p256v1.getCurve().decodePoint(o1);
                    ECPoint smPk2 = ECC.sm2p256v1.getCurve().decodePoint(o2);
                    return ECC.compare(smPk1, smPk2);
                }
                case ECDSA: {
                    ECPoint pk1 = ECC.secp256r1.getCurve().decodePoint(o1);
                    ECPoint pk2 = ECC.secp256r1.getCurve().decodePoint(o2);
                    return ECC.compare(pk1, pk2);
                }
                case EDDSA: {
                    return Helper.toHexString(o1).compareTo(Helper.toHexString(o1));
                }
            }
            return Helper.toHexString(o1).compareTo(Helper.toHexString(o1));
        }).toArray(x$0 -> new byte[x$0][]);
        return publicKeys;
    }

    public static byte[][] getParamInfo(byte[] program) {
        ByteArrayInputStream bais = new ByteArrayInputStream(program);
        BinaryReader br = new BinaryReader(bais);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        try {
            while (true) {
                list.add(Program.readBytes(br));
            }
        }
        catch (IOException e) {
            byte[][] res = new byte[list.size()][];
            for (int i = 0; i < list.size(); ++i) {
                res[i] = (byte[])list.get(i);
            }
            return res;
        }
    }

    public static byte[] readBytes(BinaryReader br) throws IOException {
        long keyLen;
        int temp;
        byte code = br.readByte();
        if (code == ScriptOp.OP_PUSHDATA4.getByte()) {
            temp = br.readInt();
            keyLen = temp;
        } else if (code == ScriptOp.OP_PUSHDATA2.getByte()) {
            temp = br.readShort();
            keyLen = temp;
        } else if (code == ScriptOp.OP_PUSHDATA1.getByte()) {
            temp = br.readByte();
            keyLen = temp & 0xFF;
        } else {
            keyLen = code <= ScriptOp.OP_PUSHBYTES75.getByte() && code >= ScriptOp.OP_PUSHBYTES1.getByte() ? Long.valueOf(code) - Long.valueOf(ScriptOp.OP_PUSHBYTES1.getByte()) + 1L : 0L;
        }
        byte[] res = br.readBytes((int)keyLen);
        return res;
    }

    public static ProgramInfo getProgramInfo(byte[] program) throws IOException {
        ProgramInfo info = new ProgramInfo();
        if (program.length <= 2) {
            // empty if block
        }
        byte end = program[program.length - 1];
        byte[] temp = new byte[program.length - 1];
        System.arraycopy(program, 0, temp, 0, program.length - 1);
        ByteArrayInputStream bais = new ByteArrayInputStream(temp);
        BinaryReader reader = new BinaryReader(bais);
        if (end == ScriptOp.OP_CHECKSIG.getByte()) {
            try {
                byte[] publicKey = Program.readBytes(reader);
                info.setPublicKey(new byte[][]{publicKey});
                info.setM((short)1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (end == ScriptOp.OP_CHECKMULTISIG.getByte()) {
            short m = 0;
            int len = program[program.length - 2] - ScriptOp.OP_PUSH1.getByte() + 1;
            try {
                m = (byte)(reader.readByte() - ScriptOp.OP_PUSH1.getByte() + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[][] pub = new byte[len][];
            for (int i = 0; i < len; ++i) {
                pub[i] = reader.readVarBytes();
            }
            info.setPublicKey(pub);
            info.setM(m);
        }
        return info;
    }

    public static short readNum(BinaryReader reader) throws IOException, SDKException {
        ScriptOp code = Program.readOpCode(reader);
        if (code == ScriptOp.OP_PUSH0) {
            Program.readOpCode(reader);
            return 0;
        }
        int num = code.getByte() - ScriptOp.OP_PUSH1.getByte() + 1;
        if (num >= 1 && num <= 16) {
            Program.readOpCode(reader);
            return (short)num;
        }
        byte[] buff = Program.readBytes(reader);
        BigInteger bint = Helper.BigIntFromNeoBytes(buff);
        long num2 = bint.longValue();
        if (num2 > 32767L || num2 < 16L) {
            throw new SDKException(ErrorCode.ParamErr("num is wrong"));
        }
        return (short)num2;
    }

    public static ScriptOp readOpCode(BinaryReader reader) throws IOException {
        return ScriptOp.valueOf(reader.readByte());
    }

    public static byte[] programFromParams(byte[][] sigs) {
        ScriptBuilder builder = new ScriptBuilder();
        for (byte[] sigdata : sigs) {
            builder.emitPushByteArray(sigdata);
        }
        return builder.toArray();
    }

    public static byte[] programFromPubKey(byte[] publicKey) {
        ScriptBuilder builder = new ScriptBuilder();
        builder.emitPushByteArray(publicKey);
        builder.emit(ScriptOp.OP_CHECKSIG);
        return builder.toArray();
    }

    public static byte[] programFromMultiPubKey(byte[][] publicKey, short m) throws SDKException {
        int n = publicKey.length;
        if (m >= 1 && m <= n && n <= 1024) {
            throw new SDKException(ErrorCode.ParamErr("m is wrong"));
        }
        ScriptBuilder builder = new ScriptBuilder();
        builder.pushNum(m);
        builder.add(ScriptOp.OP_CHECKSIG);
        return builder.toArray();
    }
}

