/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.scripts;

import com.github.DNAProject.common.Helper;
import com.github.DNAProject.common.UIntBase;
import com.github.DNAProject.core.scripts.ScriptOp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ScriptBuilder
implements AutoCloseable {
    private ByteArrayOutputStream ms = new ByteArrayOutputStream();

    public ScriptBuilder add(ScriptOp op) {
        return this.add(op.getByte());
    }

    public ScriptBuilder add(byte op) {
        this.ms.write(op);
        return this;
    }

    public ScriptBuilder add(byte[] script) {
        this.ms.write(script, 0, script.length);
        return this;
    }

    @Override
    public void close() {
        try {
            this.ms.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ScriptBuilder emitPushBool(boolean b) {
        if (b) {
            return this.add(ScriptOp.OP_PUSH1);
        }
        return this.add(ScriptOp.OP_PUSH0);
    }

    public ScriptBuilder emitPushInteger(BigInteger number) {
        if (number.equals(BigInteger.ONE.negate())) {
            return this.add(ScriptOp.OP_PUSHM1);
        }
        if (number.equals(BigInteger.ZERO)) {
            return this.add(ScriptOp.OP_PUSH0);
        }
        if (number.compareTo(BigInteger.ZERO) > 0 && number.compareTo(BigInteger.valueOf(16L)) <= 0) {
            return this.add((byte)(ScriptOp.OP_PUSH1.getByte() - 1 + number.byteValue()));
        }
        byte[] bytes = Helper.BigIntToNeoBytes(number);
        return this.emitPushByteArray(bytes);
    }

    public ScriptBuilder pushNum(short num) {
        if (num == 0) {
            return this.add(ScriptOp.OP_PUSH0);
        }
        if (num < 16) {
            return this.add(ScriptOp.valueOf(num - 1 + ScriptOp.OP_PUSH1.getByte()));
        }
        BigInteger bint = BigInteger.valueOf(num);
        return this.emitPushByteArray(Helper.BigIntToNeoBytes(bint));
    }

    public ScriptBuilder emitPushByteArray(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (data.length <= ScriptOp.OP_PUSHBYTES75.getByte()) {
            this.ms.write((byte)data.length);
            this.ms.write(data, 0, data.length);
        } else if (data.length < 256) {
            this.add(ScriptOp.OP_PUSHDATA1);
            this.ms.write((byte)data.length);
            this.ms.write(data, 0, data.length);
        } else if (data.length < 65536) {
            this.add(ScriptOp.OP_PUSHDATA2);
            this.ms.write(ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort((short)data.length).array(), 0, 2);
            this.ms.write(data, 0, data.length);
        } else if ((long)data.length < 0x100000000L) {
            this.add(ScriptOp.OP_PUSHDATA4);
            this.ms.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(data.length).array(), 0, 4);
            this.ms.write(data, 0, data.length);
        } else {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public ScriptBuilder emit(ScriptOp op) {
        return this.add(op.getByte());
    }

    public ScriptBuilder push(UIntBase hash) {
        return this.emitPushByteArray(hash.toArray());
    }

    public ScriptBuilder pushPack() {
        return this.add(ScriptOp.OP_PACK);
    }

    public byte[] toArray() {
        return this.ms.toByteArray();
    }
}

