/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.sdk.exception.SDKException;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.math.ec.ECCurve;

public enum Curve {
    P224(1, "P-224"),
    P256(2, "P-256"),
    P384(3, "P-384"),
    P521(4, "P-521"),
    SM2P256V1(20, "sm2p256v1"),
    ED25519(25, "ED25519");

    private int label;
    private String name;

    private Curve(int v0, String v1) {
        this.label = v0;
        this.name = v1;
    }

    public int getLabel() {
        return this.label;
    }

    public String toString() {
        return this.name;
    }

    public static Curve valueOf(ECCurve v) throws Exception {
        for (Curve c : Curve.values()) {
            if (!ECNamedCurveTable.getParameterSpec((String)c.toString()).getCurve().equals(v)) continue;
            return c;
        }
        throw new Exception(ErrorCode.UnknownCurve);
    }

    public static Curve fromLabel(int v) throws Exception {
        for (Curve c : Curve.values()) {
            if (c.label != v) continue;
            return c;
        }
        throw new SDKException(ErrorCode.UnknownCurveLabel);
    }
}

