/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto.bip32;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.crypto.bip32.Bitcoin;
import com.github.DNAProject.crypto.bip32.ByteArrayReader;
import com.github.DNAProject.crypto.bip32.Deserializer;
import com.github.DNAProject.crypto.bip32.HdKey;
import com.github.DNAProject.crypto.bip32.HdPrivateKey;
import com.github.DNAProject.crypto.bip32.Network;
import com.github.DNAProject.sdk.exception.SDKException;
import io.github.novacrypto.base58.Base58;
import java.util.Arrays;

final class HdPrivateKeyDeserializer
implements Deserializer<HdPrivateKey> {
    static final HdPrivateKeyDeserializer DEFAULT = new HdPrivateKeyDeserializer(Bitcoin.MAIN_NET);
    private final Network network;

    HdPrivateKeyDeserializer(Network network) {
        this.network = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HdPrivateKey deserialize(CharSequence extendedBase58Key) throws SDKException {
        byte[] extendedKeyData = Base58.base58Decode((CharSequence)extendedBase58Key);
        try {
            HdPrivateKey hdPrivateKey = this.deserialize(extendedKeyData);
            return hdPrivateKey;
        }
        finally {
            Arrays.fill(extendedKeyData, (byte)0);
        }
    }

    @Override
    public HdPrivateKey deserialize(byte[] extendedKeyData) throws SDKException {
        HdKey.confirmHdKeyChecksum(extendedKeyData);
        ByteArrayReader reader = new ByteArrayReader(extendedKeyData);
        int version = reader.readSer32();
        if (version != Bitcoin.MAIN_NET.getPrivateVersion()) {
            throw new SDKException(ErrorCode.OtherError(String.format("Can't find network that matches private version 0x%x", version)));
        }
        return new HdPrivateKey(new HdKey.Builder().network(Bitcoin.MAIN_NET).depth(reader.read()).parentFingerprint(reader.readSer32()).childNumber(reader.readSer32()).chainCode(reader.readRange(32)).key(this.getKey(reader)).neutered(false).build());
    }

    private byte[] getKey(ByteArrayReader reader) throws SDKException {
        if (reader.read() != 0) {
            throw new SDKException(ErrorCode.OtherError("Expected 0 padding at position 45"));
        }
        return reader.readRange(32);
    }
}

