/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.dnaid;

import com.alibaba.fastjson.annotation.JSONType;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.dnaid.ProofPurpose;
import com.github.DNAProject.dnaid.PubKeyType;

@JSONType(orders={"type", "created", "challenge", "domain", "proofPurpose", "verificationMethod", "hex", "jws"})
public class Proof {
    public PubKeyType type;
    public String created;
    public String challenge;
    public Object domain;
    public ProofPurpose proofPurpose;
    public String verificationMethod;
    public String hex;
    public String jws;

    public Proof() {
    }

    public Proof(String publicKeyURI, String created, PubKeyType type, ProofPurpose proofPurpose) {
        this.type = type;
        this.created = created;
        if (proofPurpose == null) {
            proofPurpose = ProofPurpose.assertionMethod;
        }
        this.proofPurpose = proofPurpose;
        this.verificationMethod = publicKeyURI;
    }

    public Proof(String publicKeyURI, String created, PubKeyType type, ProofPurpose proofPurpose, String challenge, Object domain) {
        this(publicKeyURI, created, type, proofPurpose);
        this.challenge = challenge;
        this.domain = domain;
    }

    public Proof genNeedSignProof() {
        return new Proof(this.verificationMethod, this.created, this.type, this.proofPurpose, this.challenge, this.domain);
    }

    public Proof genJWTProof() {
        Proof proof = new Proof();
        proof.created = this.created;
        proof.proofPurpose = this.proofPurpose;
        proof.hex = this.hex;
        return proof;
    }

    public void fillHexSignature(Account account, byte[] needSignData) throws Exception {
        byte[] sig = account.generateSignature(needSignData, account.getSignatureScheme(), null);
        this.hex = Helper.toHexString(sig);
    }

    public byte[] parseHexSignature() {
        return Helper.hexToBytes(this.hex);
    }
}

