/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.dnaid;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.DNAProject.dnaid.Proof;
import com.github.DNAProject.dnaid.Util;
import com.github.DNAProject.dnaid.VerifiableCredential;
import com.github.DNAProject.dnaid.jwt.JWTCredential;
import java.util.UUID;

@JSONType(orders={"@context", "id", "type", "verifiableCredential", "holder", "proof"})
public class VerifiablePresentation {
    @JSONField(name="@context")
    public String[] context;
    public String id = "urn:uuid:" + UUID.randomUUID().toString();
    public String[] type;
    public VerifiableCredential[] verifiableCredential;
    public Object holder;
    public Proof[] proof;

    public byte[] genNeedSignData(Proof needSignProof) {
        Proof[] proofs = this.proof;
        this.proof = new Proof[]{needSignProof.genNeedSignProof()};
        String jsonStr = JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        this.proof = proofs;
        return jsonStr.getBytes();
    }

    public String fetchHolderDnaId() {
        return Util.fetchId(this.holder);
    }

    public static VerifiablePresentation deserializeFromJWT(JWTCredential jwtCred) throws Exception {
        VerifiablePresentation presentation = new VerifiablePresentation();
        presentation.context = jwtCred.payload.vp.context;
        presentation.id = jwtCred.payload.jti;
        presentation.type = jwtCred.payload.vp.type;
        if (jwtCred.payload.vp.holder == null) {
            presentation.holder = jwtCred.payload.iss;
        } else {
            JSONObject jsonHolder = (JSONObject)JSONObject.toJSON((Object)jwtCred.payload.vp.holder);
            jsonHolder.put("id", (Object)jwtCred.payload.iss);
            presentation.holder = jsonHolder;
        }
        presentation.proof = new Proof[]{jwtCred.parseProof()};
        int vcLength = jwtCred.payload.vp.verifiableCredential.length;
        VerifiableCredential[] credentials = new VerifiableCredential[vcLength];
        for (int i = 0; i < vcLength; ++i) {
            VerifiableCredential credential;
            String vc = jwtCred.payload.vp.verifiableCredential[i];
            JWTCredential vcJWT = JWTCredential.deserializeToJWTCred(vc);
            credentials[i] = credential = VerifiableCredential.deserializeFromJWT(vcJWT);
        }
        presentation.verifiableCredential = credentials;
        return presentation;
    }
}

