/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.dnaid.jwt;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.DNAProject.dnaid.Proof;
import com.github.DNAProject.dnaid.VerifiableCredential;
import com.github.DNAProject.dnaid.VerifiablePresentation;
import com.github.DNAProject.dnaid.jwt.JWTVC;
import com.github.DNAProject.dnaid.jwt.JWTVP;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

@JSONType(orders={"iss", "sub", "aud", "exp", "nbf", "iat", "jti", "nonce", "vc", "vp"})
public class JWTPayload {
    public String iss;
    public String sub;
    public Object aud;
    @JSONField(serialzeFeatures={SerializerFeature.NotWriteDefaultValue})
    public long exp;
    @JSONField(serialzeFeatures={SerializerFeature.NotWriteDefaultValue})
    public long nbf;
    @JSONField(serialzeFeatures={SerializerFeature.NotWriteDefaultValue})
    public long iat;
    public String jti;
    public String nonce;
    public JWTVC vc;
    public JWTVP vp;

    public JWTPayload() {
    }

    public JWTPayload(VerifiableCredential credential) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (credential.expirationDate != null && !credential.expirationDate.isEmpty()) {
            Date exp = formatter.parse(credential.expirationDate);
            this.exp = exp.getTime() / 1000L;
        }
        this.iss = credential.fetchIssuerDnaId();
        if (credential.issuanceDate != null && !credential.issuanceDate.isEmpty()) {
            Date nbf = formatter.parse(credential.issuanceDate);
            this.iat = this.nbf = nbf.getTime() / 1000L;
        }
        this.jti = credential.id;
        String credentialSubjectId = credential.findSubjectId();
        if (!"".equals(credentialSubjectId)) {
            this.sub = credentialSubjectId;
        }
        if (credential.proof != null) {
            this.aud = credential.proof.domain;
            this.nonce = credential.proof.challenge;
        }
        this.vc = new JWTVC(credential);
    }

    public JWTPayload(VerifiablePresentation presentation, Proof proof) throws Exception {
        if (proof != null) {
            this.aud = proof.domain;
            this.nonce = proof.challenge;
        }
        this.iss = presentation.fetchHolderDnaId();
        this.jti = presentation.id;
        this.vp = new JWTVP(presentation, proof);
    }
}

