/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.io;

import com.github.DNAProject.io.Serializable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bouncycastle.math.ec.ECPoint;

public class BinaryWriter
implements AutoCloseable {
    private DataOutputStream writer;
    private byte[] array = new byte[8];
    private ByteBuffer buffer = ByteBuffer.wrap(this.array).order(ByteOrder.LITTLE_ENDIAN);

    public BinaryWriter(OutputStream stream) {
        this.writer = new DataOutputStream(stream);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(byte[] buffer) throws IOException {
        this.writer.write(buffer);
    }

    public void write(byte[] buffer, int index, int length) throws IOException {
        this.writer.write(buffer, index, length);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.writer.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.writer.writeByte(v);
    }

    public void writeDouble(double v) throws IOException {
        this.buffer.putDouble(0, v);
        this.writer.write(this.array, 0, 8);
    }

    public void writeECPoint(ECPoint v) throws IOException {
        this.writer.write(v.getEncoded(true));
    }

    public void writeFixedString(String v, int length) throws IOException {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        if (v.length() > length) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = v.getBytes("UTF-8");
        if (bytes.length > length) {
            throw new IllegalArgumentException();
        }
        this.writer.write(bytes);
        if (bytes.length < length) {
            this.writer.write(new byte[length - bytes.length]);
        }
    }

    public void writeFloat(float v) throws IOException {
        this.buffer.putFloat(0, v);
        this.writer.write(this.array, 0, 4);
    }

    public void writeInt(int v) throws IOException {
        this.buffer.putInt(0, v);
        this.writer.write(this.array, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.buffer.putLong(0, v);
        this.writer.write(this.array, 0, 8);
    }

    public void writeSerializable(Serializable v) throws IOException {
        v.serialize(this);
    }

    public void writeSerializableArray(Serializable[] v) throws IOException {
        this.writeVarInt(v.length);
        for (int i = 0; i < v.length; ++i) {
            v[i].serialize(this);
        }
    }

    public void writeSerializableArray2(Serializable[] v) throws IOException {
        this.writeInt(v.length);
        for (int i = 0; i < v.length; ++i) {
            v[i].serialize(this);
        }
    }

    public void writeShort(short v) throws IOException {
        this.buffer.putShort(0, v);
        this.writer.write(this.array, 0, 2);
    }

    public void writeVarBytes(byte[] v) throws IOException {
        this.writeVarInt(v.length);
        this.writer.write(v);
    }

    public void writeVarInt(long v) throws IOException {
        if (v < 0L) {
            throw new IllegalArgumentException();
        }
        if (v < 253L) {
            this.writeByte((byte)v);
        } else if (v <= 65535L) {
            this.writeByte((byte)-3);
            this.writeShort((short)v);
        } else if (v <= 0xFFFFFFFFL) {
            this.writeByte((byte)-2);
            this.writeInt((int)v);
        } else {
            this.writeByte((byte)-1);
            this.writeLong(v);
        }
    }

    public void writeVarString(String v) throws IOException {
        this.writeVarBytes(v.getBytes("UTF-8"));
    }
}

