/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.network.rest;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.network.exception.RestfulException;
import com.github.DNAProject.network.rest.UrlConsts;
import com.github.DNAProject.network.rest.http;
import java.util.HashMap;

class Interfaces {
    private String url;

    public Interfaces(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String sendTransaction(boolean preExec, String userid, String action, String version, String data) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (userid != null) {
            params.put("userid", userid);
        }
        if (preExec) {
            params.put("preExec", "1");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("Action", action);
        body.put("Version", version);
        body.put("Data", data);
        try {
            return http.post(this.url + UrlConsts.Url_send_transaction, params, body);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr(this.url), e);
        }
    }

    public String getTransaction(String txhash, boolean raw) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (raw) {
            params.put("raw", "1");
        }
        try {
            return http.get(this.url + UrlConsts.Url_get_transaction + txhash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getNodeCount() throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_node_count, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getBlockHeight() throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_block_height, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getBlock(int height, String raw) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("raw", raw);
        try {
            return http.get(this.url + UrlConsts.Url_get_block_by_height + height, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getBlock(String hash, String raw) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("raw", raw);
        try {
            return http.get(this.url + UrlConsts.Url_get_block_by_hash + hash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getContract(String hash) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("raw", "1");
        try {
            return http.get(this.url + UrlConsts.Url_get_contract_state + hash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getContractJson(String hash) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_contract_state + hash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getSmartCodeEvent(int height) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_smartcodeevent_txs_by_height + height, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getSmartCodeEvent(String hash) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_smartcodeevent_by_txhash + hash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getBlockHeightByTxHash(String hash) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_block_height_by_txhash + hash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getStorage(String codehash, String key) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_storage + codehash + "/" + key, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getMerkleProof(String hash) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_merkleproof + hash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getMemPoolTxCount() throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_mem_pool_tx_count, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getMemPoolTxState(String hash) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_mem_pool_tx_state + hash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getBalance(String address) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_account_balance + address, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getTransactionJson(String txhash) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_transaction + txhash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getBlockJson(int height) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_block_by_height + height, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getBlockJson(String hash) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_block_by_hash + hash, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getAllowance(String asset, String from, String to) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_allowance + asset + "/" + from + "/" + to, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getVersion() throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_version, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getGrantOng(String address) throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_grant_ong + "/" + address, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getNetworkId() throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_networkid, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }

    public String getNodeSyncStatus() throws RestfulException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return http.get(this.url + UrlConsts.Url_get_syncstatus, params);
        }
        catch (Exception e) {
            throw new RestfulException(ErrorCode.ConnectUrlErr + this.url, e);
        }
    }
}

