/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.network.rest;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.block.Block;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.io.Serializable;
import com.github.DNAProject.network.connect.AbstractConnector;
import com.github.DNAProject.network.exception.ConnectorException;
import com.github.DNAProject.network.exception.RestfulException;
import com.github.DNAProject.network.rest.Interfaces;
import com.github.DNAProject.network.rest.Result;
import java.io.IOException;

public class RestClient
extends AbstractConnector {
    private Interfaces api;
    private String version = "v1.0.0";
    private String action = "sendrawtransaction";

    public RestClient(String restUrl) {
        this.api = new Interfaces(restUrl);
    }

    @Override
    public String getUrl() {
        return this.api.getUrl();
    }

    @Override
    public String sendRawTransaction(String hexData) throws RestfulException {
        String rs = this.api.sendTransaction(false, null, this.action, this.version, hexData);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rs;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public String sendRawTransaction(boolean preExec, String userid, String hexData) throws RestfulException {
        String rs = this.api.sendTransaction(preExec, userid, this.action, this.version, hexData);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rs;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Transaction getRawTransaction(String txhash) throws RestfulException {
        String rs = this.api.getTransaction(txhash, true);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            try {
                return Transaction.deserializeFrom(Helper.hexToBytes((String)rr.Result));
            }
            catch (IOException e) {
                throw new RestfulException(ErrorCode.TxDeserializeError, e);
            }
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public int getNodeCount() throws RestfulException {
        String rs = this.api.getNodeCount();
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return (Integer)rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public int getBlockHeight() throws RestfulException {
        String rs = this.api.getBlockHeight();
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return (Integer)rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Block getBlock(int height) throws RestfulException {
        String rs = this.api.getBlock(height, "1");
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            try {
                return Serializable.from(Helper.hexToBytes((String)rr.Result), Block.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RestfulException(ErrorCode.BlockDeserializeError, e);
            }
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Block getBlock(String hash) throws RestfulException {
        String rs = this.api.getBlock(hash, "1");
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error != 0L) {
            throw new RestfulException(this.to(rr));
        }
        try {
            return Serializable.from(Helper.hexToBytes((String)rr.Result), Block.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RestfulException(ErrorCode.BlockDeserializeError, e);
        }
    }

    @Override
    public Object getBalance(String address) throws RestfulException {
        String rs = this.api.getBalance(address);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getRawTransactionJson(String txhash) throws RestfulException, IOException {
        String rs = this.api.getTransaction(txhash, true);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return JSON.toJSONString((Object)Transaction.deserializeFrom(Helper.hexToBytes((String)rr.Result)).json());
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getBlockJson(int height) throws RestfulException {
        String rs = this.api.getBlock(height, "0");
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getBlockJson(String hash) throws RestfulException {
        String rs = this.api.getBlock(hash, "0");
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getContract(String hash) throws RestfulException {
        String rs = this.api.getContract(hash);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getContractJson(String hash) throws RestfulException {
        String rs = this.api.getContractJson(hash);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getSmartCodeEvent(int height) throws ConnectorException, IOException {
        String rs = this.api.getSmartCodeEvent(height);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getSmartCodeEvent(String hash) throws ConnectorException, IOException {
        String rs = this.api.getSmartCodeEvent(hash);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public int getBlockHeightByTxHash(String hash) throws ConnectorException, IOException {
        String rs = this.api.getBlockHeightByTxHash(hash);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return (Integer)rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public String getStorage(String codehash, String key) throws ConnectorException, IOException {
        String rs = this.api.getStorage(codehash, key);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return (String)rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getMerkleProof(String hash) throws ConnectorException, IOException {
        String rs = this.api.getMerkleProof(hash);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public String getAllowance(String asset, String from, String to) throws ConnectorException, IOException {
        String rs = this.api.getAllowance(asset, from, to);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return (String)rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getMemPoolTxCount() throws ConnectorException, IOException {
        String rs = this.api.getMemPoolTxCount();
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getMemPoolTxState(String hash) throws ConnectorException, IOException {
        String rs = this.api.getMemPoolTxState(hash);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public String getVersion() throws ConnectorException, IOException {
        String rs = this.api.getVersion();
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return (String)rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public String getGrantOng(String address) throws ConnectorException, IOException {
        String rs = this.api.getGrantOng(address);
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return (String)rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public int getNetworkId() throws ConnectorException, IOException {
        String rs = this.api.getNetworkId();
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return (Integer)rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public Object getNodeSyncStatus() throws ConnectorException, IOException {
        String rs = this.api.getNodeSyncStatus();
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        throw new RestfulException(this.to(rr));
    }

    @Override
    public String getSideChainData(String sideChainID) throws ConnectorException, IOException {
        return null;
    }

    private String to(Result rr) {
        return JSON.toJSONString((Object)rr);
    }
}

