/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.sdk.manager;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.block.Block;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.network.connect.IConnector;
import com.github.DNAProject.network.exception.ConnectorException;
import com.github.DNAProject.network.rest.RestClient;
import com.github.DNAProject.network.rest.Result;
import com.github.DNAProject.network.rpc.RpcClient;
import com.github.DNAProject.network.websocket.WebsocketClient;
import com.github.DNAProject.sdk.exception.SDKException;
import java.io.IOException;
import java.util.Map;

public class ConnectMgr {
    private IConnector connector;

    public ConnectMgr(String url, String type, Object lock) {
        if (type.equals("websocket")) {
            this.setConnector(new WebsocketClient(url, lock));
        }
    }

    public ConnectMgr(String url, String type) {
        url = url.replace("://localhost", "://127.0.0.1");
        if (type.equals("rpc")) {
            this.setConnector(new RpcClient(url));
        } else if (type.equals("restful")) {
            this.setConnector(new RestClient(url));
        }
    }

    public void startWebsocketThread(boolean log) {
        if (this.connector instanceof WebsocketClient) {
            ((WebsocketClient)this.connector).startWebsocketThread(log);
        }
    }

    public void setReqId(long n) {
        if (this.connector instanceof WebsocketClient) {
            ((WebsocketClient)this.connector).setReqId(n);
        }
    }

    public void send(Map map) {
        if (this.connector instanceof WebsocketClient) {
            ((WebsocketClient)this.connector).send(map);
        }
    }

    public void sendHeartBeat() {
        if (this.connector instanceof WebsocketClient) {
            ((WebsocketClient)this.connector).sendHeartBeat();
        }
    }

    public void sendSubscribe(Map map) {
        if (this.connector instanceof WebsocketClient) {
            ((WebsocketClient)this.connector).sendSubscribe(map);
        }
    }

    public ConnectMgr(IConnector connector) {
        this.setConnector(connector);
    }

    public void setConnector(IConnector connector) {
        this.connector = connector;
    }

    private String getUrl() {
        return this.connector.getUrl();
    }

    public boolean sendRawTransaction(Transaction tx) throws ConnectorException, IOException {
        String rs = (String)this.connector.sendRawTransaction(Helper.toHexString(tx.toArray()));
        if (this.connector instanceof RpcClient) {
            return true;
        }
        if (this.connector instanceof WebsocketClient) {
            return true;
        }
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        return rr.Error == 0L;
    }

    public boolean sendRawTransaction(String hexData) throws ConnectorException, IOException {
        String rs = (String)this.connector.sendRawTransaction(hexData);
        if (this.connector instanceof RpcClient) {
            return true;
        }
        if (this.connector instanceof WebsocketClient) {
            return true;
        }
        Result rr = (Result)JSON.parseObject((String)rs, Result.class);
        return rr.Error == 0L;
    }

    public Object sendRawTransactionSync(String hexData) throws ConnectorException, Exception {
        return this.syncSendRawTransaction(hexData);
    }

    public Object syncSendRawTransaction(String hexData) throws ConnectorException, Exception {
        String rs = (String)this.connector.sendRawTransaction(hexData);
        String hash = Transaction.deserializeFrom(Helper.hexToBytes(hexData)).hash().toString();
        System.out.println("Transaction hash is: " + hash + ", Please waitting result... ");
        return this.waitResult(hash);
    }

    public Object sendRawTransactionPreExec(String hexData) throws ConnectorException, IOException {
        Object rs = this.connector.sendRawTransaction(true, null, hexData);
        if (this.connector instanceof RpcClient) {
            return rs;
        }
        if (this.connector instanceof WebsocketClient) {
            return rs;
        }
        Result rr = (Result)JSON.parseObject((String)((String)rs), Result.class);
        if (rr.Error == 0L) {
            return rr.Result;
        }
        return null;
    }

    public Transaction getTransaction(String txhash) throws ConnectorException, IOException {
        txhash = txhash.replace("0x", "");
        return this.connector.getRawTransaction(txhash);
    }

    public Object getTransactionJson(String txhash) throws ConnectorException, IOException {
        txhash = txhash.replace("0x", "");
        return this.connector.getRawTransactionJson(txhash);
    }

    public int getNodeCount() throws ConnectorException, IOException {
        return this.connector.getNodeCount();
    }

    public int getBlockHeight() throws ConnectorException, IOException {
        return this.connector.getBlockHeight();
    }

    public Block getBlock(int height) throws ConnectorException, IOException, SDKException {
        if (height < 0) {
            throw new SDKException(ErrorCode.ParamError);
        }
        return this.connector.getBlock(height);
    }

    public Block getBlock(String hash) throws ConnectorException, IOException {
        return this.connector.getBlock(hash);
    }

    public Object getBalance(String address) throws ConnectorException, IOException {
        return this.connector.getBalance(address);
    }

    public Object getBlockJson(int height) throws ConnectorException, IOException {
        return this.connector.getBlockJson(height);
    }

    public Object getBlockJson(String hash) throws ConnectorException, IOException {
        return this.connector.getBlockJson(hash);
    }

    public Object getContract(String hash) throws ConnectorException, IOException {
        hash = hash.replace("0x", "");
        return this.connector.getContractJson(hash);
    }

    public Object getContractJson(String hash) throws ConnectorException, IOException {
        hash = hash.replace("0x", "");
        return this.connector.getContractJson(hash);
    }

    public Object getSmartCodeEvent(int height) throws ConnectorException, IOException {
        return this.connector.getSmartCodeEvent(height);
    }

    public Object getSmartCodeEvent(String hash) throws ConnectorException, IOException {
        return this.connector.getSmartCodeEvent(hash);
    }

    public int getBlockHeightByTxHash(String hash) throws ConnectorException, IOException {
        hash = hash.replace("0x", "");
        return this.connector.getBlockHeightByTxHash(hash);
    }

    public String getStorage(String codehash, String key) throws ConnectorException, IOException {
        codehash = codehash.replace("0x", "");
        return this.connector.getStorage(codehash, key);
    }

    public Object getMerkleProof(String hash) throws ConnectorException, IOException {
        hash = hash.replace("0x", "");
        return this.connector.getMerkleProof(hash);
    }

    public String getAllowance(String asset, String from, String to) throws ConnectorException, IOException {
        return this.connector.getAllowance(asset, from, to);
    }

    public Object getMemPoolTxCount() throws ConnectorException, IOException {
        return this.connector.getMemPoolTxCount();
    }

    public Object getMemPoolTxState(String hash) throws ConnectorException, IOException {
        hash = hash.replace("0x", "");
        return this.connector.getMemPoolTxState(hash);
    }

    public String getVersion() throws ConnectorException, IOException {
        return this.connector.getVersion();
    }

    public String getGrantOng(String address) throws ConnectorException, IOException {
        return this.connector.getGrantOng(address);
    }

    public int getNetworkId() throws ConnectorException, IOException {
        return this.connector.getNetworkId();
    }

    public Object getNodeSyncStatus() throws ConnectorException, IOException {
        return this.connector.getNodeSyncStatus();
    }

    public String getSideChainData(String sideChianId) throws ConnectorException, IOException {
        return this.connector.getSideChainData(sideChianId);
    }

    public Object waitResult(String hash) throws Exception {
        Object objEvent = null;
        Object objTxState = null;
        int notInpool = 0;
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(3000L);
                objEvent = this.connector.getSmartCodeEvent(hash);
                if (objEvent == null || objEvent.equals("")) {
                    Thread.sleep(1000L);
                    objTxState = this.connector.getMemPoolTxState(hash);
                    continue;
                }
                if (((Map)objEvent).get("Notify") == null) continue;
                return objEvent;
            }
            catch (Exception e) {
                if (!e.getMessage().contains("UNKNOWN TRANSACTION") || !e.getMessage().contains("getmempooltxstate") || !objEvent.equals("") && objEvent != null || ++notInpool <= 1) continue;
                throw new SDKException(e.getMessage());
            }
        }
        throw new SDKException(ErrorCode.OtherError("time out"));
    }
}

