/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.sdk.wallet;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.sdk.wallet.Account;
import com.github.DNAProject.sdk.wallet.Control;
import com.github.DNAProject.sdk.wallet.Identity;
import com.github.DNAProject.sdk.wallet.Scrypt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Wallet
implements Cloneable {
    private String name = "com.github.DNAProject";
    private String version = "1.0";
    private String createTime = "";
    private String defaultDnaid = "";
    private String defaultAccountAddress = "";
    private Scrypt scrypt = new Scrypt();
    private Object extra = null;
    private List<Identity> identities = new ArrayList<Identity>();
    private List<Account> accounts = new ArrayList<Account>();

    public Wallet() {
        this.identities.clear();
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultDnaid() {
        return this.defaultDnaid;
    }

    public void setDefaultDnaid(String defaultDnaid) {
        this.defaultDnaid = defaultDnaid;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getDefaultAccountAddress() {
        return this.defaultAccountAddress;
    }

    public void setDefaultAccountAddress(String defaultAccountAddress) {
        this.defaultAccountAddress = defaultAccountAddress;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Scrypt getScrypt() {
        return this.scrypt;
    }

    public void setScrypt(Scrypt scrypt) {
        this.scrypt = scrypt;
    }

    public List<Identity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<Identity> identityList) {
        this.identities = identityList;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accountList) {
        this.accounts = accountList;
    }

    public boolean removeAccount(String address) {
        for (Account e : this.accounts) {
            if (!e.address.equals(address)) continue;
            this.accounts = new ArrayList<Account>(this.accounts);
            this.accounts.remove(e);
            return true;
        }
        return false;
    }

    public boolean clearAccount() {
        this.accounts = new ArrayList<Account>();
        return true;
    }

    public Account getAccount(String address) {
        for (Account e : this.accounts) {
            if (!e.address.equals(address)) continue;
            return e;
        }
        return null;
    }

    public boolean removeIdentity(String dnaid) {
        for (Identity e : this.identities) {
            if (!e.dnaid.equals(dnaid)) continue;
            this.identities = new ArrayList<Identity>(this.identities);
            this.identities.remove(e);
            return true;
        }
        return false;
    }

    public boolean clearIdentity() {
        this.identities = new ArrayList<Identity>();
        return true;
    }

    public Identity getIdentity(String dnaid) {
        for (Identity e : this.identities) {
            if (!e.dnaid.equals(dnaid)) continue;
            return e;
        }
        return null;
    }

    public void setDefaultAccount(int index) throws Exception {
        if (index >= this.accounts.size()) {
            throw new SDKException(ErrorCode.ParamError);
        }
        for (Account e : this.accounts) {
            e.isDefault = false;
        }
        this.accounts.get((int)index).isDefault = true;
        this.defaultAccountAddress = this.accounts.get((int)index).address;
    }

    public void setDefaultAccount(String address) {
        for (Account e : this.accounts) {
            if (e.address.equals(address)) {
                e.isDefault = true;
                this.defaultAccountAddress = address;
                continue;
            }
            e.isDefault = false;
        }
    }

    public void setDefaultIdentity(int index) throws Exception {
        if (index >= this.identities.size()) {
            throw new SDKException(ErrorCode.ParamError);
        }
        for (Identity e : this.identities) {
            e.isDefault = false;
        }
        this.identities.get((int)index).isDefault = true;
        this.defaultDnaid = this.identities.get((int)index).dnaid;
    }

    public void setDefaultIdentity(String dnaid) {
        for (Identity e : this.identities) {
            if (e.dnaid.equals(dnaid)) {
                e.isDefault = true;
                this.defaultDnaid = dnaid;
                continue;
            }
            e.isDefault = false;
        }
    }

    private Identity addIdentity(String dnaid) {
        for (Identity e : this.getIdentities()) {
            if (!e.dnaid.equals(dnaid)) continue;
            return e;
        }
        Identity identity = new Identity();
        identity.dnaid = dnaid;
        identity.controls = new ArrayList<Control>();
        this.getIdentities().add(identity);
        return identity;
    }

    private void addIdentity(Identity idt) {
        for (Identity e : this.getIdentities()) {
            if (!e.dnaid.equals(idt.dnaid)) continue;
            return;
        }
        this.getIdentities().add(idt);
    }

    public Identity addDnaIdController(String dnaid, String key, String id, String pubkey) {
        Identity identity = this.getIdentity(dnaid);
        if (identity == null) {
            identity = this.addIdentity(dnaid);
        }
        for (Control e : identity.controls) {
            if (!e.key.equals(key)) continue;
            return identity;
        }
        Control control = new Control(key, id, pubkey);
        identity.controls.add(control);
        return identity;
    }

    public Wallet clone() {
        Wallet o = null;
        try {
            o = (Wallet)super.clone();
            Account[] srcAccounts = o.accounts.toArray(new Account[0]);
            Account[] destAccounts = new Account[srcAccounts.length];
            System.arraycopy(srcAccounts, 0, destAccounts, 0, srcAccounts.length);
            o.accounts = Arrays.asList(destAccounts);
            Identity[] srcIdentitys = o.identities.toArray(new Identity[0]);
            Identity[] destIdentitys = new Identity[srcIdentitys.length];
            System.arraycopy(srcIdentitys, 0, destIdentitys, 0, srcIdentitys.length);
            o.identities = Arrays.asList(destIdentitys);
            o.scrypt = o.scrypt.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

