/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm.abi;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.UInt256;
import com.github.DNAProject.core.dnaid.Attribute;
import com.github.DNAProject.core.scripts.ScriptBuilder;
import com.github.DNAProject.core.scripts.ScriptOp;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.nativevm.abi.AbiFunction;
import com.github.DNAProject.smartcontract.nativevm.abi.Parameter;
import com.github.DNAProject.smartcontract.nativevm.abi.Struct;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class NativeBuildParams {
    public static byte[] buildParams(Object ... params) throws SDKException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryWriter bw = new BinaryWriter(baos);
        try {
            for (Object param : params) {
                if (param instanceof Integer) {
                    bw.writeInt((Integer)param);
                    continue;
                }
                if (param instanceof byte[]) {
                    bw.writeVarBytes((byte[])param);
                    continue;
                }
                if (param instanceof String) {
                    bw.writeVarString((String)param);
                    continue;
                }
                if (param instanceof Attribute[]) {
                    bw.writeSerializableArray((Attribute[])param);
                    continue;
                }
                if (param instanceof Attribute) {
                    bw.writeSerializable((Attribute)param);
                    continue;
                }
                if (param instanceof Address) {
                    bw.writeSerializable((Address)param);
                    continue;
                }
                throw new SDKException(ErrorCode.WriteVarBytesError);
            }
        }
        catch (IOException e) {
            throw new SDKException(ErrorCode.WriteVarBytesError);
        }
        return baos.toByteArray();
    }

    private static byte[] createCodeParamsScript(ScriptBuilder builder, List<Object> list) {
        try {
            for (int i = list.size() - 1; i >= 0; --i) {
                ArrayList<Object> tmpList;
                Object val = list.get(i);
                if (val instanceof byte[]) {
                    builder.emitPushByteArray((byte[])val);
                    continue;
                }
                if (val instanceof Boolean) {
                    builder.emitPushBool((Boolean)val);
                    continue;
                }
                if (val instanceof Integer) {
                    builder.emitPushInteger(BigInteger.valueOf(((Integer)val).intValue()));
                    continue;
                }
                if (val instanceof Long) {
                    builder.emitPushInteger(BigInteger.valueOf((Long)val));
                    continue;
                }
                if (val instanceof Address) {
                    builder.emitPushByteArray(((Address)val).toArray());
                    continue;
                }
                if (val instanceof UInt256) {
                    builder.emitPushByteArray(((UInt256)val).toArray());
                    continue;
                }
                if (val instanceof String) {
                    builder.emitPushByteArray(((String)val).getBytes());
                    continue;
                }
                if (val instanceof Struct) {
                    builder.emitPushInteger(BigInteger.valueOf(0L));
                    builder.add(ScriptOp.OP_NEWSTRUCT);
                    builder.add(ScriptOp.OP_TOALTSTACK);
                    for (int k = 0; k < ((Struct)val).list.size(); ++k) {
                        Object o = ((Struct)val).list.get(k);
                        tmpList = new ArrayList();
                        tmpList.add(o);
                        NativeBuildParams.createCodeParamsScript(builder, tmpList);
                        builder.add(ScriptOp.OP_DUPFROMALTSTACK);
                        builder.add(ScriptOp.OP_SWAP);
                        builder.add(ScriptOp.OP_APPEND);
                    }
                    builder.add(ScriptOp.OP_FROMALTSTACK);
                    continue;
                }
                if (val instanceof List) {
                    List tmp = (List)val;
                    for (int k = tmp.size() - 1; k >= 0; --k) {
                        tmpList = new ArrayList<Object>();
                        tmpList.add(tmp.get(k));
                        NativeBuildParams.createCodeParamsScript(builder, tmpList);
                    }
                    builder.emitPushInteger(new BigInteger(String.valueOf(tmp.size())));
                    builder.pushPack();
                    continue;
                }
                throw new SDKException(ErrorCode.OtherError("not this type"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.toArray();
    }

    public static byte[] createCodeParamsScript(List<Object> list) {
        ScriptBuilder sb = new ScriptBuilder();
        return NativeBuildParams.createCodeParamsScript(sb, list);
    }

    public static byte[] serializeAbiFunction(AbiFunction abiFunction) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(abiFunction.getName().getBytes());
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (Parameter obj : abiFunction.getParameters()) {
            if ("Byte".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Byte.TYPE));
                continue;
            }
            if ("ByteArray".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), byte[].class));
                continue;
            }
            if ("String".equals(obj.getType())) {
                tmp.add(obj.getValue());
                continue;
            }
            if ("Bool".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Boolean.TYPE));
                continue;
            }
            if ("Int".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Long.class));
                continue;
            }
            if ("Array".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Array.class));
                continue;
            }
            if ("Struct".equals(obj.getType()) || "Uint256".equals(obj.getType()) || "Address".equals(obj.getType())) continue;
            throw new SDKException(ErrorCode.TypeError);
        }
        if (list.size() > 0) {
            list.add(tmp);
        }
        byte[] params = NativeBuildParams.createCodeParamsScript(list);
        return params;
    }
}

