/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.neovm;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.common.Common;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.crypto.KeyType;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.sdk.info.AccountInfo;
import com.github.DNAProject.smartcontract.neovm.abi.BuildParams;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class Record {
    private DnaSdk sdk;
    private String contractAddress = null;

    public Record(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public void setContractAddress(String codeHash) {
        this.contractAddress = codeHash.replace("0x", "");
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String sendPut(String addr, String password, byte[] salt, String key, String value, long gaslimit, long gas) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (key == null || value == null || key == "" || value == "") {
            throw new SDKException(ErrorCode.NullKeyOrValue);
        }
        addr = addr.replace(Common.diddna, "");
        byte[] did = (Common.diddna + addr).getBytes();
        AccountInfo info = this.sdk.getWalletMgr().getAccountInfo(Common.diddna + addr, password, salt);
        byte[] pk = Helper.hexToBytes(info.pubkey);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("Put".getBytes());
        ArrayList<byte[]> tmp = new ArrayList<byte[]>();
        tmp.add(key.getBytes());
        tmp.add(JSON.toJSONString(this.constructRecord(value)).getBytes());
        list.add(tmp);
        Transaction tx = this.makeInvokeTransaction(list, info.addressBase58, gaslimit, gas);
        this.sdk.signTx(tx, addr, password, salt);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String sendGet(String addr, String password, byte[] salt, String key) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (key == null || key == "") {
            throw new SDKException(ErrorCode.NullKey);
        }
        byte[] did = (Common.diddna + addr).getBytes();
        AccountInfo info = this.sdk.getWalletMgr().getAccountInfo(addr, password, salt);
        byte[] pk = Helper.hexToBytes(info.pubkey);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("Get".getBytes());
        ArrayList<byte[]> tmp = new ArrayList<byte[]>();
        tmp.add(key.getBytes());
        list.add(tmp);
        Transaction tx = this.makeInvokeTransaction(list, null, 0L, 0L);
        this.sdk.signTx(tx, addr, password, salt);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        return new String(Helper.hexToBytes((String)obj));
    }

    public Transaction makeInvokeTransaction(List<Object> list, String payer, long gaslimit, long gas) throws Exception {
        byte[] params = BuildParams.createCodeParamsScript(list);
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(this.contractAddress, null, params, payer, gaslimit, gas);
        return tx;
    }

    public LinkedHashMap<String, Object> constructRecord(String text) {
        LinkedHashMap<String, Object> recordData = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("Algrithem", KeyType.SM2.name());
        data.put("Hash", "");
        data.put("Text", text);
        data.put("Signature", "");
        recordData.put("Data", data);
        recordData.put("CAkey", "");
        recordData.put("SeqNo", "");
        recordData.put("Timestamp", 0);
        return recordData;
    }
}

