/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.neovm.abi;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.scripts.ScriptBuilder;
import com.github.DNAProject.core.scripts.ScriptOp;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.neovm.abi.AbiFunction;
import com.github.DNAProject.smartcontract.neovm.abi.Parameter;
import com.github.DNAProject.smartcontract.neovm.abi.Struct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildParams {
    private static byte[] createCodeParamsScript(ScriptBuilder builder, List<Object> list) {
        try {
            for (int i = list.size() - 1; i >= 0; --i) {
                Object val = list.get(i);
                if (val instanceof byte[]) {
                    builder.emitPushByteArray((byte[])val);
                    continue;
                }
                if (val instanceof Address) {
                    builder.emitPushByteArray(((Address)val).toArray());
                    continue;
                }
                if (val instanceof String) {
                    builder.emitPushByteArray(((String)val).getBytes());
                    continue;
                }
                if (val instanceof Boolean) {
                    builder.emitPushBool((Boolean)val);
                    continue;
                }
                if (val instanceof Integer) {
                    builder.emitPushByteArray(Helper.BigIntToNeoBytes(BigInteger.valueOf(((Integer)val).intValue())));
                    continue;
                }
                if (val instanceof Long) {
                    builder.emitPushByteArray(Helper.BigIntToNeoBytes(BigInteger.valueOf((Long)val)));
                    continue;
                }
                if (val instanceof Map) {
                    BuildParams.pushMap(builder, val);
                    continue;
                }
                if (val instanceof Struct) {
                    BuildParams.pushStruct(builder, val);
                    continue;
                }
                if (!(val instanceof List)) continue;
                List tmp = (List)val;
                BuildParams.createCodeParamsScript(builder, tmp);
                builder.emitPushInteger(new BigInteger(String.valueOf(tmp.size())));
                builder.pushPack();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.toArray();
    }

    public static Object deserializeItem(byte[] mBytes) {
        ByteArrayInputStream ms = new ByteArrayInputStream(mBytes);
        BinaryReader reader = new BinaryReader(ms);
        return BuildParams.deserializeItem(reader);
    }

    public static Object deserializeItem(BinaryReader reader) {
        try {
            byte t = reader.readByte();
            if (t == Type.ByteArrayType.getValue()) {
                return reader.readVarBytes();
            }
            if (t == Type.BooleanType.getValue()) {
                return reader.readBoolean();
            }
            if (t == Type.IntegerType.getValue()) {
                long v = Helper.BigIntFromNeoBytes(reader.readVarBytes()).longValue();
                return v;
            }
            if (t == Type.ArrayType.getValue() || t == Type.StructType.getValue()) {
                int count = (int)reader.readVarInt();
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = count; i > 0; --i) {
                    Object ele = BuildParams.deserializeItem(reader);
                    if (ele instanceof byte[]) {
                        ele = new String((byte[])ele);
                    }
                    list.add(ele);
                    --count;
                }
                return list;
            }
            if (t == Type.MapType.getValue()) {
                int count = (int)reader.readVarInt();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = count; i > 0; --i) {
                    byte[] key = (byte[])BuildParams.deserializeItem(reader);
                    Object value = BuildParams.deserializeItem(reader);
                    if (value instanceof byte[]) {
                        value = Helper.toHexString((byte[])value);
                    } else if (value instanceof Long) {
                        value = (Long)value == 0L ? "00" : Helper.toHexString(Helper.BigIntToNeoBytes(BigInteger.valueOf((Long)value)));
                    }
                    map.put(new String(key), value);
                    --count;
                }
                return map;
            }
            throw new SDKException(ErrorCode.ParamError);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void pushParam(ScriptBuilder sb, Object eValue) {
        block12: {
            try {
                if (eValue instanceof byte[]) {
                    sb.emitPushByteArray((byte[])eValue);
                    break block12;
                }
                if (eValue instanceof String) {
                    sb.emitPushByteArray(((String)eValue).getBytes());
                    break block12;
                }
                if (eValue instanceof Boolean) {
                    sb.emitPushBool((Boolean)eValue);
                    sb.add(ScriptOp.OP_PUSH0);
                    sb.add(ScriptOp.OP_BOOLOR);
                    break block12;
                }
                if (eValue instanceof Map) {
                    BuildParams.pushMap(sb, eValue);
                    break block12;
                }
                if (eValue instanceof Struct) {
                    List list = ((Struct)eValue).list;
                    for (int i = list.size() - 1; i >= 0; --i) {
                        Object val = list.get(i);
                        BuildParams.pushParam(sb, val);
                    }
                    sb.emitPushInteger(new BigInteger(String.valueOf(list.size())));
                    sb.pushPack();
                    break block12;
                }
                if (eValue instanceof List) {
                    List list = (List)eValue;
                    for (int i = list.size() - 1; i >= 0; --i) {
                        Object val = list.get(i);
                        BuildParams.pushParam(sb, val);
                    }
                    sb.emitPushInteger(new BigInteger(String.valueOf(list.size())));
                    sb.pushPack();
                    break block12;
                }
                if (eValue instanceof Integer) {
                    sb.emitPushByteArray(Helper.BigIntToNeoBytes(BigInteger.valueOf(((Integer)eValue).intValue())));
                    sb.add(ScriptOp.OP_PUSH0);
                    sb.add(ScriptOp.OP_ADD);
                    break block12;
                }
                if (eValue instanceof Long) {
                    sb.emitPushByteArray(Helper.BigIntToNeoBytes(BigInteger.valueOf((Long)eValue)));
                    sb.add(ScriptOp.OP_PUSH0);
                    sb.add(ScriptOp.OP_ADD);
                    break block12;
                }
                throw new SDKException(ErrorCode.ParamError);
            }
            catch (SDKException e) {
                e.printStackTrace();
            }
        }
    }

    public static void pushStruct(ScriptBuilder sb, Object val) {
        Struct struct = (Struct)val;
        sb.add(ScriptOp.OP_NEWSTRUCT);
        sb.add(ScriptOp.OP_TOALTSTACK);
        for (int i = 0; i < struct.list.size(); ++i) {
            BuildParams.pushParam(sb, struct.list.get(i));
            sb.add(ScriptOp.OP_DUPFROMALTSTACK);
            sb.add(ScriptOp.OP_SWAP);
            sb.add(ScriptOp.OP_APPEND);
        }
        sb.add(ScriptOp.OP_FROMALTSTACK);
    }

    public static void pushMap(ScriptBuilder sb, Object val) {
        Map map = (Map)val;
        sb.add(ScriptOp.OP_NEWMAP);
        sb.add(ScriptOp.OP_TOALTSTACK);
        for (Map.Entry e : map.entrySet()) {
            sb.add(ScriptOp.OP_DUPFROMALTSTACK);
            BuildParams.pushParam(sb, e.getKey());
            BuildParams.pushParam(sb, e.getValue());
            sb.add(ScriptOp.OP_SETITEM);
        }
        sb.add(ScriptOp.OP_FROMALTSTACK);
    }

    public static void serializeStackItem(BinaryWriter bw, Object eValue) {
        block11: {
            try {
                if (eValue instanceof byte[]) {
                    bw.writeByte(Type.ByteArrayType.getValue());
                    bw.writeVarBytes((byte[])eValue);
                    break block11;
                }
                if (eValue instanceof String) {
                    bw.writeByte(Type.ByteArrayType.getValue());
                    bw.writeVarBytes(((String)eValue).getBytes());
                    break block11;
                }
                if (eValue instanceof Boolean) {
                    bw.writeByte(Type.BooleanType.getValue());
                    bw.writeBoolean((Boolean)eValue);
                    break block11;
                }
                if (eValue instanceof Map) {
                    bw.write(BuildParams.getMapBytes(eValue));
                    break block11;
                }
                if (eValue instanceof Struct) {
                    bw.writeVarBytes(BuildParams.getStructBytes(eValue));
                    break block11;
                }
                if (eValue instanceof List) {
                    List tmp = (List)eValue;
                    bw.writeByte(Type.ArrayType.getValue());
                    bw.writeVarInt(tmp.size());
                    for (int i = 0; i < tmp.size(); ++i) {
                        BuildParams.serializeStackItem(bw, tmp.get(i));
                    }
                    break block11;
                }
                if (eValue instanceof Integer) {
                    bw.writeByte(Type.IntegerType.getValue());
                    bw.writeVarBytes(Helper.BigIntToNeoBytes(BigInteger.valueOf(((Integer)eValue).intValue())));
                    break block11;
                }
                if (eValue instanceof Long) {
                    bw.writeByte(Type.IntegerType.getValue());
                    bw.writeVarBytes(Helper.BigIntToNeoBytes(BigInteger.valueOf((Long)eValue)));
                    break block11;
                }
                throw new SDKException(ErrorCode.ParamError);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] getStructBytes(Object val) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryWriter bw = new BinaryWriter(baos);
        try {
            List list = ((Struct)val).list;
            bw.writeByte(Type.StructType.getValue());
            bw.writeVarInt(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object eValue = list.get(i);
                BuildParams.serializeStackItem(bw, eValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static byte[] getMapBytes(Object val) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryWriter bw = new BinaryWriter(baos);
        try {
            Map map = (Map)val;
            bw.writeByte(Type.MapType.getValue());
            bw.writeVarInt(map.size());
            for (Map.Entry e : map.entrySet()) {
                bw.writeByte(Type.ByteArrayType.getValue());
                bw.writeVarBytes(((String)e.getKey()).getBytes());
                Object eValue = e.getValue();
                BuildParams.serializeStackItem(bw, eValue);
            }
            bw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static byte[] createCodeParamsScript(List<Object> list) {
        ScriptBuilder sb = new ScriptBuilder();
        try {
            BuildParams.createCodeParamsScript(sb, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toArray();
    }

    public static byte[] serializeAbiFunction(AbiFunction abiFunction) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(abiFunction.getName().getBytes());
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (Parameter obj : abiFunction.getParameters()) {
            if ("ByteArray".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), byte[].class));
                continue;
            }
            if ("String".equals(obj.getType())) {
                tmp.add(obj.getValue());
                continue;
            }
            if ("Boolean".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Boolean.TYPE));
                continue;
            }
            if ("Integer".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Long.class));
                continue;
            }
            if ("Array".equals(obj.getType())) {
                List l = (List)JSON.parseObject((String)obj.getValue(), List.class);
                l = BuildParams.listConvert(l);
                tmp.add(l);
                continue;
            }
            if ("InteropInterface".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Object.class));
                continue;
            }
            if ("Void".equals(obj.getType())) continue;
            if ("Map".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Map.class));
                continue;
            }
            if ("Struct".equals(obj.getType())) {
                tmp.add(JSON.parseObject((String)obj.getValue(), Struct.class));
                continue;
            }
            throw new SDKException(ErrorCode.TypeError);
        }
        if (list.size() > 0) {
            list.add(tmp);
        }
        byte[] params = BuildParams.createCodeParamsScript(list);
        return params;
    }

    private static List listConvert(List l) {
        for (int i = 0; i < l.size(); ++i) {
            if (l.get(i) instanceof String) {
                if (!(l.get(i) instanceof String)) continue;
                l.set(i, Base64.getDecoder().decode((String)l.get(i)));
                continue;
            }
            if (!(l.get(i) instanceof List)) continue;
            l.set(i, BuildParams.listConvert((List)l.get(i)));
        }
        return l;
    }

    public static enum Type {
        ByteArrayType(0),
        BooleanType(1),
        IntegerType(2),
        InterfaceType(64),
        ArrayType(128),
        StructType(129),
        MapType(130);

        private byte type;

        private Type(int t) {
            this.type = (byte)t;
        }

        public byte getValue() {
            return this.type;
        }
    }
}

