/*
 * Decompiled with CFR 0.152.
 */
package example.dnaid;

import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.dnaid.Attribute;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.crypto.SignatureScheme;
import com.github.DNAProject.sdk.info.IdentityInfo;
import com.github.DNAProject.sdk.wallet.Identity;
import java.util.List;

public class DnaIdDemo {
    public static void main(String[] args) {
        String password = "111111";
        try {
            DnaSdk dnaSdk = DnaIdDemo.getDnaSdk();
            com.github.DNAProject.sdk.wallet.Account payer = dnaSdk.getWalletMgr().createAccount(password);
            Account payerAcct = dnaSdk.getWalletMgr().getAccount(payer.address, password, dnaSdk.getWalletMgr().getWallet().getAccount(payer.address).getSalt());
            String privatekey0 = "c19f16785b8f3543bbaf5e1dbb5d398dfa6c85aaad54fc9d71203ce83e505c07";
            String privatekey1 = "2ab720ff80fcdd31a769925476c26120a879e235182594fbb57b67c0743558d7";
            Account account1 = new Account(Helper.hexToBytes(privatekey1), SignatureScheme.SHA256WITHECDSA);
            if (dnaSdk.getWalletMgr().getWallet().getIdentities().size() < 1) {
                Identity identity = dnaSdk.getWalletMgr().createIdentityFromPriKey(password, privatekey0);
                dnaSdk.nativevm().dnaId().sendRegister(identity, password, payerAcct, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
                dnaSdk.getWalletMgr().writeWallet();
                Thread.sleep(6000L);
                return;
            }
            Identity identity = dnaSdk.getWalletMgr().getWallet().getIdentities().get(0);
            Attribute[] attributes = new Attribute[]{new Attribute("key1".getBytes(), "String".getBytes(), "value1".getBytes())};
            byte[] salt = identity.controls.get(0).getSalt();
            dnaSdk.nativevm().dnaId().sendAddRecovery(identity.dnaid, password, salt, account1.getAddressU160().toBase58(), payerAcct, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
            Thread.sleep(6000L);
            String ddo2 = dnaSdk.nativevm().dnaId().sendGetDDO(identity.dnaid);
            System.out.println(ddo2);
            System.out.println(account1.getAddressU160().toBase58());
            System.exit(0);
            com.github.DNAProject.sdk.wallet.Account account = dnaSdk.getWalletMgr().createAccountFromPriKey(password, privatekey0);
            if (dnaSdk.getWalletMgr().getWallet().getIdentities().size() < 3) {
                Identity identity2 = dnaSdk.getWalletMgr().createIdentity(password);
                Transaction tx = dnaSdk.nativevm().dnaId().makeRegister(identity2.dnaid, identity2.controls.get((int)0).publicKey, payer.address, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
                dnaSdk.signTx(tx, identity2.dnaid, password, new byte[0]);
                dnaSdk.addSign(tx, payerAcct);
                dnaSdk.getConnect().sendRawTransaction(tx);
                Identity identity22 = dnaSdk.getWalletMgr().createIdentity(password);
                dnaSdk.nativevm().dnaId().sendRegister(identity22, password, payerAcct, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
                Identity identity3 = dnaSdk.getWalletMgr().createIdentity(password);
                Attribute[] attributes2 = new Attribute[]{new Attribute("key1".getBytes(), "String".getBytes(), "value1".getBytes())};
                dnaSdk.nativevm().dnaId().sendRegisterWithAttrs(identity3, password, attributes2, payerAcct, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
                dnaSdk.getWalletMgr().writeWallet();
                Thread.sleep(6000L);
            }
            List<Identity> dids = dnaSdk.getWalletMgr().getWallet().getIdentities();
            System.out.println("dids.get(0).dnaid:" + dids.get((int)0).dnaid);
            String ddo1 = dnaSdk.nativevm().dnaId().sendGetDDO(dids.get((int)0).dnaid);
            System.out.println("ddo1:" + ddo1);
            IdentityInfo info2 = dnaSdk.getWalletMgr().getIdentityInfo(dids.get((int)1).dnaid, password, new byte[0]);
            IdentityInfo info3 = dnaSdk.getWalletMgr().getIdentityInfo(dids.get((int)2).dnaid, password, new byte[0]);
            Account acct = new Account(Helper.hexToBytes(privatekey0), SignatureScheme.SHA256WITHECDSA);
            Account acct2 = new Account(Helper.hexToBytes(privatekey1), SignatureScheme.SHA256WITHECDSA);
            Address address = Address.addressFromMultiPubKeys(2, acct.serializePublicKey(), acct2.serializePublicKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.openWalletFile("DnaIdDemo.json");
        return wm;
    }
}

