/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.template.config;

import com.github.adminfaces.template.config.ControlSidebarConfig;
import com.github.adminfaces.template.util.Assert;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@Named
@ApplicationScoped
public class AdminConfig
implements Serializable {
    private static final long serialVersionUID = 834212776758014169L;
    private static final Logger log = Logger.getLogger(AdminConfig.class.getName());
    private Properties adminConfigFile;
    private Properties userConfigFile;
    private String loginPage;
    private String indexPage;
    private String dateFormat;
    private String templatePath;
    private Integer breadCrumbMaxSize;
    private boolean renderMessages;
    private boolean skipMessageDetailIfEqualsSummary;
    private boolean renderAjaxStatus;
    private boolean disableFilter;
    private boolean enableRipple;
    private boolean renderBreadCrumb;
    private boolean extensionLessUrls;
    private boolean enableSlideMenu;
    private String rippleElements;
    private String skin;
    private boolean autoShowNavbar;
    private String ignoredResources;
    private String loadingImage;
    private boolean renderControlSidebar;
    private boolean leftMenuTemplate;
    private boolean renderMenuSearch;
    private boolean renderFormAsterisks;
    private boolean closableLoading;
    private boolean enableMobileHeader;
    private ControlSidebarConfig controlSidebar;
    private String pageSuffix;
    private boolean rippleMobileOnly;
    private String messagesHideTimeout;
    private boolean autoHideMessages;
    private boolean iconsEffect;

    @PostConstruct
    public void init() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.adminConfigFile = new Properties();
        this.userConfigFile = new Properties();
        try (InputStream is = cl.getResourceAsStream("admin-config.properties");){
            if (is != null) {
                this.userConfigFile.load(is);
            }
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Could not load user defined admin template properties. Falling back to default properties.");
        }
        try (InputStream isDefault = cl.getResourceAsStream("config/admin-config.properties");){
            this.adminConfigFile.load(isDefault);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "Could not load admin template default properties.", ex);
        }
        this.loadDefaults();
    }

    protected void loadDefaults() {
        this.loginPage = this.getProperty("admin.loginPage");
        this.indexPage = this.getProperty("admin.indexPage");
        this.dateFormat = this.getProperty("admin.dateFormat");
        if (!Assert.has(this.dateFormat)) {
            this.dateFormat = ((SimpleDateFormat)DateFormat.getDateTimeInstance()).toLocalizedPattern();
        }
        this.templatePath = this.getProperty("admin.templatePath");
        this.breadCrumbMaxSize = Integer.parseInt(this.getProperty("admin.breadcrumbSize"));
        this.renderMessages = Boolean.parseBoolean(this.getProperty("admin.renderMessages"));
        this.skipMessageDetailIfEqualsSummary = Boolean.parseBoolean(this.getProperty("admin.skipMessageDetailIfEqualsSummary"));
        this.renderAjaxStatus = Boolean.parseBoolean(this.getProperty("admin.renderAjaxStatus"));
        this.disableFilter = Boolean.parseBoolean(this.getProperty("admin.disableFilter"));
        this.enableRipple = Boolean.parseBoolean(this.getProperty("admin.enableRipple"));
        this.renderBreadCrumb = Boolean.parseBoolean(this.getProperty("admin.renderBreadCrumb"));
        this.extensionLessUrls = Boolean.parseBoolean(this.getProperty("admin.extensionLessUrls"));
        this.rippleElements = this.getProperty("admin.rippleElements");
        this.enableSlideMenu = Boolean.parseBoolean(this.getProperty("admin.enableSlideMenu"));
        this.skin = this.getProperty("admin.skin");
        this.autoShowNavbar = Boolean.parseBoolean(this.getProperty("admin.autoShowNavbar"));
        this.autoHideMessages = Boolean.parseBoolean(this.getProperty("admin.autoHideMessages"));
        this.iconsEffect = Boolean.parseBoolean(this.getProperty("admin.iconsEffect"));
        this.ignoredResources = this.getProperty("admin.ignoredResources");
        this.loadingImage = this.getProperty("admin.loadingImage");
        this.renderControlSidebar = Boolean.parseBoolean(this.getProperty("admin.renderControlSidebar"));
        this.rippleMobileOnly = Boolean.parseBoolean(this.getProperty("admin.rippleMobileOnly"));
        this.renderMenuSearch = Boolean.parseBoolean(this.getProperty("admin.renderMenuSearch"));
        this.renderFormAsterisks = Boolean.parseBoolean(this.getProperty("admin.renderFormAsterisks"));
        this.enableMobileHeader = Boolean.parseBoolean(this.getProperty("admin.enableMobileHeader"));
        this.closableLoading = Boolean.parseBoolean(this.getProperty("admin.closableLoading"));
        this.messagesHideTimeout = this.getProperty("admin.messagesHideTimeout");
        this.leftMenuTemplate = Boolean.parseBoolean(this.getProperty("admin.controlSidebar.leftMenuTemplate"));
        boolean controlSidebarShowOnMobile = Boolean.parseBoolean(this.getProperty("admin.controlSidebar.showOnMobile"));
        boolean fixedLayout = Boolean.parseBoolean(this.getProperty("admin.controlSidebar.fixedLayout"));
        boolean boxedLayout = Boolean.parseBoolean(this.getProperty("admin.controlSidebar.boxedLayout"));
        boolean expandOnHover = Boolean.parseBoolean(this.getProperty("admin.controlSidebar.expandOnHover"));
        boolean sidebarCollapsed = Boolean.parseBoolean(this.getProperty("admin.controlSidebar.sidebarCollapsed"));
        boolean fixedControlSidebar = Boolean.parseBoolean(this.getProperty("admin.controlSidebar.fixed"));
        boolean darkControlSidebarSkin = Boolean.parseBoolean(this.getProperty("admin.controlSidebar.darkSkin"));
        this.controlSidebar = new ControlSidebarConfig(controlSidebarShowOnMobile, fixedLayout, boxedLayout, expandOnHover, sidebarCollapsed, fixedControlSidebar, darkControlSidebarSkin);
    }

    private String getProperty(String property) {
        return Assert.has(System.getProperty(property)) ? System.getProperty(property) : (Assert.has(this.userConfigFile.getProperty(property)) ? this.userConfigFile.getProperty(property) : this.adminConfigFile.getProperty(property));
    }

    public String getPageSufix() {
        if (Assert.has(this.pageSuffix)) {
            return this.pageSuffix;
        }
        if (!Assert.has(this.indexPage) && !Assert.has(this.loginPage)) {
            this.pageSuffix = "xhtml";
        }
        this.pageSuffix = Assert.has(this.indexPage) ? this.indexPage.substring(this.indexPage.lastIndexOf(46) + 1) : this.indexPage.substring(this.loginPage.lastIndexOf(46) + 1);
        return this.pageSuffix;
    }

    public void restoreDefaults() {
        this.loadDefaults();
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public String getIndexPage() {
        return this.indexPage;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean isIconsEffect() {
        return this.iconsEffect;
    }

    public void setIconsEffect(boolean iconsEffect) {
        this.iconsEffect = iconsEffect;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public void setIndexPage(String indexPage) {
        this.indexPage = indexPage;
    }

    public boolean isDisableFilter() {
        return this.disableFilter;
    }

    public void setDisableFilter(boolean disableFilter) {
        this.disableFilter = disableFilter;
    }

    public boolean isLeftMenuTemplate() {
        return this.leftMenuTemplate;
    }

    public boolean isRenderMenuSearch() {
        return this.renderMenuSearch;
    }

    public void setRenderMenuSearch(boolean renderMenuSearch) {
        this.renderMenuSearch = renderMenuSearch;
    }

    public boolean isAutoHideMessages() {
        return this.autoHideMessages;
    }

    public void setAutoHideMessages(boolean autoHideMessages) {
        this.autoHideMessages = autoHideMessages;
    }

    public boolean isRenderFormAsterisks() {
        return this.renderFormAsterisks;
    }

    public void setRenderFormAsterisks(boolean renderFormAsterisks) {
        this.renderFormAsterisks = renderFormAsterisks;
    }

    public String getMessagesHideTimeout() {
        return this.messagesHideTimeout;
    }

    public void setMessagesHideTimeout(String messagesHideTimeout) {
        this.messagesHideTimeout = messagesHideTimeout;
    }

    public void setLeftMenuTemplate(boolean leftMenuTemplate) {
        this.leftMenuTemplate = leftMenuTemplate;
    }

    public ControlSidebarConfig getControlSidebar() {
        return this.controlSidebar;
    }

    public void setControlSidebar(ControlSidebarConfig controlSidebarConfig) {
        this.controlSidebar = controlSidebarConfig;
    }

    public boolean isEnableMobileHeader() {
        return this.enableMobileHeader;
    }

    public void setEnableMobileHeader(boolean enableMobileHeader) {
        this.enableMobileHeader = enableMobileHeader;
    }

    public boolean isRippleMobileOnly() {
        return this.rippleMobileOnly;
    }

    public void setRippleMobileOnly(boolean rippleEffectMobileOnly) {
        this.rippleMobileOnly = rippleEffectMobileOnly;
    }

    @Deprecated
    public String getTemplatePath() {
        return this.templatePath;
    }

    public Integer getBreadCrumbMaxSize() {
        return this.breadCrumbMaxSize;
    }

    public void setBreadCrumbMaxSize(Integer breadCrumbMaxSize) {
        this.breadCrumbMaxSize = breadCrumbMaxSize;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public boolean isRenderMessages() {
        return this.renderMessages;
    }

    public void setRenderMessages(boolean renderMessages) {
        this.renderMessages = renderMessages;
    }

    public boolean isSkipMessageDetailIfEqualsSummary() {
        return this.skipMessageDetailIfEqualsSummary;
    }

    public void setSkipMessageDetailIfEqualsSummary(boolean skipMessageDetailIfEqualsSummary) {
        this.skipMessageDetailIfEqualsSummary = skipMessageDetailIfEqualsSummary;
    }

    public boolean isRenderAjaxStatus() {
        return this.renderAjaxStatus;
    }

    public void setRenderAjaxStatus(boolean renderAjaxStatus) {
        this.renderAjaxStatus = renderAjaxStatus;
    }

    public boolean isEnableRipple() {
        return this.enableRipple;
    }

    public void setEnableRipple(boolean enableRipple) {
        this.enableRipple = enableRipple;
    }

    public boolean isRenderBreadCrumb() {
        return this.renderBreadCrumb;
    }

    public void setRenderBreadCrumb(boolean renderBreadCrumb) {
        this.renderBreadCrumb = renderBreadCrumb;
    }

    public boolean isExtensionLessUrls() {
        return this.extensionLessUrls;
    }

    public void setExtensionLessUrls(boolean extensionLessUrls) {
        this.extensionLessUrls = extensionLessUrls;
    }

    public String getRippleElements() {
        return this.rippleElements;
    }

    public void setRippleElements(String rippleElements) {
        this.rippleElements = rippleElements;
    }

    public boolean isEnableSlideMenu() {
        return this.enableSlideMenu;
    }

    public void setEnableSlideMenu(boolean enableSlideMenu) {
        this.enableSlideMenu = enableSlideMenu;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public boolean isAutoShowNavbar() {
        return this.autoShowNavbar;
    }

    public void setAutoShowNavbar(boolean autoShowNavbar) {
        this.autoShowNavbar = autoShowNavbar;
    }

    public String getIgnoredResources() {
        return this.ignoredResources;
    }

    public void setIgnoredResources(String ignoredResources) {
        this.ignoredResources = ignoredResources;
    }

    public String getLoadingImage() {
        return this.loadingImage;
    }

    public void setLoadingImage(String loadingImage) {
        this.loadingImage = loadingImage;
    }

    public boolean isRenderControlSidebar() {
        return this.renderControlSidebar;
    }

    public void setRenderControlSidebar(boolean renderControlSidebar) {
        this.renderControlSidebar = renderControlSidebar;
    }

    public boolean isClosableLoading() {
        return this.closableLoading;
    }

    public void setClosableLoading(boolean closableLoading) {
        this.closableLoading = closableLoading;
    }
}

