/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.template.util;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;
import org.omnifaces.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public enum WebXml {
    INSTANCE;

    private static final Logger logger;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String WEB_FRAGMENT_XML = "META-INF/web-fragment.xml";
    private static final String XPATH_WELCOME_FILE = "welcome-file-list/welcome-file";
    private static final String XPATH_EXCEPTION_TYPE = "error-page/exception-type";
    private static final String XPATH_LOCATION = "location";
    private static final String XPATH_ERROR_PAGE_500_LOCATION = "error-page[error-code=500]/location";
    private static final String XPATH_ERROR_PAGE_DEFAULT_LOCATION = "error-page[not(error-code) and not(exception-type)]/location";
    private static final String XPATH_FORM_LOGIN_PAGE = "login-config[auth-method='FORM']/form-login-config/form-login-page";
    private static final String XPATH_FORM_ERROR_PAGE = "login-config[auth-method='FORM']/form-login-config/form-error-page";
    private static final String XPATH_SECURITY_CONSTRAINT = "security-constraint";
    private static final String XPATH_WEB_RESOURCE_URL_PATTERN = "web-resource-collection/url-pattern";
    private static final String XPATH_AUTH_CONSTRAINT = "auth-constraint";
    private static final String XPATH_AUTH_CONSTRAINT_ROLE_NAME = "auth-constraint/role-name";
    private static final String XPATH_SESSION_TIMEOUT = "session-config/session-timeout";
    private static final String ERROR_NOT_INITIALIZED = "WebXml is not initialized yet. Please use #init(ServletContext) method to manually initialize it.";
    private static final String ERROR_URL_MUST_START_WITH_SLASH = "URL must start with '/': '%s'";
    private static final String LOG_INITIALIZATION_ERROR = "WebXml failed to initialize. Perhaps your web.xml contains a typo?";
    private final AtomicBoolean initialized = new AtomicBoolean();
    private List<String> welcomeFiles;
    private Map<Class<Throwable>, String> errorPageLocations;
    private String formLoginPage;
    private String formErrorPage;
    private Map<String, Set<String>> securityConstraints;
    private int sessionTimeout;

    private void init() {
        if (!this.initialized.get() && Faces.hasContext()) {
            this.init(Faces.getServletContext());
        }
    }

    public WebXml init(ServletContext servletContext) {
        if (servletContext != null && !this.initialized.getAndSet(true)) {
            try {
                Element webXml = WebXml.loadWebXml(servletContext).getDocumentElement();
                XPath xpath = XPathFactory.newInstance().newXPath();
                this.welcomeFiles = WebXml.parseWelcomeFiles(webXml, xpath);
                this.errorPageLocations = WebXml.parseErrorPageLocations(webXml, xpath);
                this.formLoginPage = WebXml.parseFormLoginPage(webXml, xpath);
                this.formErrorPage = WebXml.parseFormErrorPage(webXml, xpath);
                this.securityConstraints = WebXml.parseSecurityConstraints(webXml, xpath);
                this.sessionTimeout = WebXml.parseSessionTimeout(webXml, xpath);
            }
            catch (Exception e) {
                this.initialized.set(false);
                logger.log(Level.SEVERE, LOG_INITIALIZATION_ERROR, e);
                throw new UnsupportedOperationException(e);
            }
        }
        return this;
    }

    public String findErrorPageLocation(Throwable exception) {
        this.checkInitialized();
        for (Map.Entry<Class<Throwable>, String> entry : this.errorPageLocations.entrySet()) {
            if (entry.getKey() != exception.getClass()) continue;
            return entry.getValue();
        }
        for (Map.Entry<Class<Throwable>, String> entry : this.errorPageLocations.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().isInstance(exception)) continue;
            return entry.getValue();
        }
        return this.errorPageLocations.get(null);
    }

    public boolean isAccessAllowed(String url, String role) {
        Set<String> roles;
        this.checkInitialized();
        if (url.charAt(0) != '/') {
            throw new IllegalArgumentException(String.format(ERROR_URL_MUST_START_WITH_SLASH, url));
        }
        String uri = url;
        if (url.length() > 1 && url.charAt(url.length() - 1) == '/') {
            uri = url.substring(0, url.length() - 1);
        }
        if ((roles = this.findExactMatchRoles(uri)) == null) {
            roles = this.findPrefixMatchRoles(uri);
        }
        if (roles == null) {
            roles = this.findSuffixMatchRoles(uri);
        }
        return WebXml.isRoleMatch(roles, role);
    }

    private Set<String> findExactMatchRoles(String url) {
        for (Map.Entry<String, Set<String>> entry : this.securityConstraints.entrySet()) {
            if (!WebXml.isExactMatch(entry.getKey(), url)) continue;
            return entry.getValue();
        }
        return null;
    }

    private Set<String> findPrefixMatchRoles(String url) {
        String path = url;
        String urlMatch = "";
        while (!path.isEmpty()) {
            Set<String> roles = null;
            for (Map.Entry<String, Set<String>> entry : this.securityConstraints.entrySet()) {
                if (urlMatch.length() >= entry.getKey().length() || !WebXml.isPrefixMatch(entry.getKey(), path)) continue;
                urlMatch = entry.getKey();
                roles = entry.getValue();
            }
            if (roles != null) {
                return roles;
            }
            path = path.substring(0, path.lastIndexOf(47));
        }
        return null;
    }

    private Set<String> findSuffixMatchRoles(String url) {
        if (url.contains(".")) {
            for (Map.Entry<String, Set<String>> entry : this.securityConstraints.entrySet()) {
                if (!WebXml.isSuffixMatch(url, entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private static boolean isExactMatch(String urlPattern, String url) {
        return url.equals(urlPattern.endsWith("/*") ? urlPattern.substring(0, urlPattern.length() - 2) : urlPattern);
    }

    private static boolean isPrefixMatch(String urlPattern, String url) {
        return urlPattern.endsWith("/*") ? url.startsWith(urlPattern.substring(0, urlPattern.length() - 2)) : false;
    }

    private static boolean isSuffixMatch(String urlPattern, String url) {
        return urlPattern.startsWith("*.") ? url.endsWith(urlPattern.substring(1)) : false;
    }

    private static boolean isRoleMatch(Set<String> roles, String role) {
        return roles == null || roles.contains(role) || role != null && roles.contains("*");
    }

    public List<String> getWelcomeFiles() {
        this.checkInitialized();
        return this.welcomeFiles;
    }

    public Map<Class<Throwable>, String> getErrorPageLocations() {
        this.checkInitialized();
        return this.errorPageLocations;
    }

    public String getFormLoginPage() {
        this.checkInitialized();
        return this.formLoginPage;
    }

    public String getFormErrorPage() {
        this.checkInitialized();
        return this.formErrorPage;
    }

    public Map<String, Set<String>> getSecurityConstraints() {
        this.checkInitialized();
        return this.securityConstraints;
    }

    public int getSessionTimeout() {
        this.checkInitialized();
        return this.sessionTimeout;
    }

    private void checkInitialized() {
        this.init();
        if (!this.initialized.get()) {
            throw new IllegalStateException(ERROR_NOT_INITIALIZED);
        }
    }

    private static Document loadWebXml(ServletContext context) throws IOException, SAXException {
        ArrayList<URL> webXmlURLs = new ArrayList<URL>();
        webXmlURLs.add(context.getResource(WEB_XML));
        webXmlURLs.addAll(Collections.list(Thread.currentThread().getContextClassLoader().getResources(WEB_FRAGMENT_XML)));
        return Xml.createDocument(webXmlURLs);
    }

    private static List<String> parseWelcomeFiles(Element webXml, XPath xpath) throws XPathExpressionException {
        NodeList welcomeFileList = Xml.getNodeList((Node)webXml, (XPath)xpath, (String)XPATH_WELCOME_FILE);
        ArrayList<String> welcomeFiles = new ArrayList<String>(welcomeFileList.getLength());
        for (int i = 0; i < welcomeFileList.getLength(); ++i) {
            welcomeFiles.add(Xml.getTextContent((Node)welcomeFileList.item(i)));
        }
        return Collections.unmodifiableList(welcomeFiles);
    }

    private static Map<Class<Throwable>, String> parseErrorPageLocations(Element webXml, XPath xpath) throws XPathExpressionException, ClassNotFoundException {
        LinkedHashMap errorPageLocations = new LinkedHashMap();
        NodeList exceptionTypes = Xml.getNodeList((Node)webXml, (XPath)xpath, (String)XPATH_EXCEPTION_TYPE);
        for (int i = 0; i < exceptionTypes.getLength(); ++i) {
            Class<?> key;
            Node node = exceptionTypes.item(i);
            Class<?> exceptionClass = Class.forName(Xml.getTextContent((Node)node));
            String exceptionLocation = xpath.compile(XPATH_LOCATION).evaluate(node.getParentNode()).trim();
            Class<?> clazz = key = exceptionClass == Throwable.class ? null : exceptionClass;
            if (errorPageLocations.containsKey(key)) continue;
            errorPageLocations.put(key, exceptionLocation);
        }
        if (!errorPageLocations.containsKey(null)) {
            String defaultLocation = xpath.compile(XPATH_ERROR_PAGE_500_LOCATION).evaluate(webXml).trim();
            if (Utils.isEmpty((String)defaultLocation)) {
                defaultLocation = xpath.compile(XPATH_ERROR_PAGE_DEFAULT_LOCATION).evaluate(webXml).trim();
            }
            if (!Utils.isEmpty((String)defaultLocation)) {
                errorPageLocations.put(null, defaultLocation);
            }
        }
        return Collections.unmodifiableMap(errorPageLocations);
    }

    private static String parseFormLoginPage(Element webXml, XPath xpath) throws XPathExpressionException {
        String formLoginPage = xpath.compile(XPATH_FORM_LOGIN_PAGE).evaluate(webXml).trim();
        return Utils.isEmpty((String)formLoginPage) ? null : formLoginPage;
    }

    private static String parseFormErrorPage(Element webXml, XPath xpath) throws XPathExpressionException {
        String formErrorPage = xpath.compile(XPATH_FORM_ERROR_PAGE).evaluate(webXml).trim();
        return Utils.isEmpty((String)formErrorPage) ? null : formErrorPage;
    }

    private static Map<String, Set<String>> parseSecurityConstraints(Element webXml, XPath xpath) throws XPathExpressionException {
        LinkedHashMap securityConstraints = new LinkedHashMap();
        NodeList constraints = Xml.getNodeList((Node)webXml, (XPath)xpath, (String)XPATH_SECURITY_CONSTRAINT);
        for (int i = 0; i < constraints.getLength(); ++i) {
            int j;
            Node constraint = constraints.item(i);
            Set<String> roles = null;
            NodeList auth = Xml.getNodeList((Node)constraint, (XPath)xpath, (String)XPATH_AUTH_CONSTRAINT);
            if (auth.getLength() > 0) {
                NodeList authRoles = Xml.getNodeList((Node)constraint, (XPath)xpath, (String)XPATH_AUTH_CONSTRAINT_ROLE_NAME);
                roles = new HashSet<String>(authRoles.getLength());
                for (j = 0; j < authRoles.getLength(); ++j) {
                    roles.add(Xml.getTextContent((Node)authRoles.item(j)));
                }
                roles = Collections.unmodifiableSet(roles);
            }
            NodeList urlPatterns = Xml.getNodeList((Node)constraint, (XPath)xpath, (String)XPATH_WEB_RESOURCE_URL_PATTERN);
            for (j = 0; j < urlPatterns.getLength(); ++j) {
                String urlPattern = Xml.getTextContent((Node)urlPatterns.item(j));
                securityConstraints.put(urlPattern, roles);
            }
        }
        return Collections.unmodifiableMap(securityConstraints);
    }

    private static int parseSessionTimeout(Element webXml, XPath xpath) throws XPathExpressionException {
        String sessionTimeout = xpath.compile(XPATH_SESSION_TIMEOUT).evaluate(webXml).trim();
        return Utils.isNumber((String)sessionTimeout) ? Integer.parseInt(sessionTimeout) : -1;
    }

    static {
        logger = Logger.getLogger(WebXml.class.getName());
    }
}

