/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.functions.Func1;

public final class FlatMapIterable<U, T>
implements Iterable<U> {
    private final Func1<? super T, ? extends Iterable<? extends U>> selector;
    private final Iterable<? extends T> source;

    public FlatMapIterable(Func1<? super T, ? extends Iterable<? extends U>> selector, Iterable<? extends T> source) {
        this.selector = selector;
        this.source = source;
    }

    @Override
    public Iterator<U> iterator() {
        final Iterator<? extends T> it = this.source.iterator();
        return new Iterator<U>(){
            Iterator<? extends U> sel;

            @Override
            public boolean hasNext() {
                if (this.sel == null || !this.sel.hasNext()) {
                    while (!Thread.currentThread().isInterrupted() && it.hasNext()) {
                        this.sel = ((Iterable)FlatMapIterable.this.selector.call(it.next())).iterator();
                        if (!this.sel.hasNext()) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public U next() {
                if (this.hasNext()) {
                    return this.sel.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.sel == null) {
                    throw new IllegalStateException();
                }
                this.sel.remove();
            }
        };
    }
}

