/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ConcatIterable<T>
implements Iterable<T> {
    private final Iterable<? extends Iterable<? extends T>> sources;

    public ConcatIterable(Iterable<? extends Iterable<? extends T>> sources) {
        this.sources = sources;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Iterable<T>> si = this.sources.iterator();
        if (si.hasNext()) {
            return new Iterator<T>(){
                Iterator<? extends T> iter;
                Iterator<? extends T> itForRemove;
                {
                    this.iter = ((Iterable)si.next()).iterator();
                }

                @Override
                public boolean hasNext() {
                    while (!this.iter.hasNext()) {
                        if (!si.hasNext()) {
                            return false;
                        }
                        this.iter = ((Iterable)si.next()).iterator();
                    }
                    return true;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.itForRemove = this.iter;
                    return this.iter.next();
                }

                @Override
                public void remove() {
                    if (this.itForRemove == null) {
                        throw new IllegalStateException();
                    }
                    this.itForRemove.remove();
                    this.itForRemove = null;
                }
            };
        }
        return Interactive.empty().iterator();
    }
}

