/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.Enumerator;
import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;

public final class EnumerationToIterator<T>
implements Iterator<T> {
    private final Enumerator<? extends T> en;
    final SingleContainer<Notification<? extends T>> peek = new SingleContainer();
    boolean done;

    public EnumerationToIterator(Enumerator<? extends T> en) {
        this.en = en;
    }

    @Override
    public boolean hasNext() {
        if (!this.done && this.peek.isEmpty()) {
            try {
                if (this.en.next()) {
                    this.peek.add(Interactive.some(this.en.current()));
                } else {
                    this.done = true;
                }
            }
            catch (Throwable t) {
                this.done = true;
                this.peek.add(Interactive.err(t));
            }
        }
        return this.peek.isEmpty();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return Interactive.value(this.peek.take());
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

