/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import rx.Notification;
import rx.functions.Func1;

public final class MinMaxIterable<T, U>
implements Iterable<List<T>> {
    private final Func1<? super T, ? extends U> keySelector;
    private final Iterable<? extends T> source;
    private final boolean max;
    private final Comparator<? super U> keyComparator;

    public MinMaxIterable(Func1<? super T, ? extends U> keySelector, Iterable<? extends T> source, boolean max, Comparator<? super U> keyComparator) {
        this.keySelector = keySelector;
        this.source = source;
        this.max = max;
        this.keyComparator = keyComparator;
    }

    @Override
    public Iterator<List<T>> iterator() {
        return new Iterator<List<T>>(){
            final Iterator<? extends T> it;
            final SingleContainer<Notification<? extends List<T>>> result;
            boolean done;
            {
                this.it = MinMaxIterable.this.source.iterator();
                this.result = new SingleContainer();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (!this.done) {
                    this.done = true;
                    if (this.result.isEmpty()) {
                        try {
                            ArrayList intermediate = null;
                            Object lastKey = null;
                            try {
                                while (this.it.hasNext()) {
                                    Object value = this.it.next();
                                    Object key = MinMaxIterable.this.keySelector.call(value);
                                    if (intermediate == null) {
                                        intermediate = new ArrayList();
                                        lastKey = key;
                                        intermediate.add(value);
                                        continue;
                                    }
                                    int c = MinMaxIterable.this.keyComparator.compare(lastKey, key);
                                    if (c < 0 && MinMaxIterable.this.max || c > 0 && !MinMaxIterable.this.max) {
                                        intermediate = new ArrayList();
                                        lastKey = key;
                                        c = 0;
                                    }
                                    if (c != 0) continue;
                                    intermediate.add(value);
                                }
                            }
                            finally {
                                Interactive.unsubscribe(this.it);
                            }
                            if (intermediate != null) {
                                this.result.add(Interactive.some(intermediate));
                            }
                        }
                        catch (Throwable t) {
                            this.result.add(Interactive.err(t));
                        }
                    }
                }
                return !this.result.isEmpty();
            }

            @Override
            public List<T> next() {
                if (this.hasNext()) {
                    return Interactive.value(this.result.take());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

