/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.util.ObservableToIterableAdapter;
import ix.internal.util.ObserverToIteratorSink;
import ix.internal.util.SingleOption;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import rx.Notification;
import rx.Observable;
import rx.Subscription;

public final class ToIterable<T>
extends ObservableToIterableAdapter<T, T> {
    public ToIterable(Observable<? extends T> observable) {
        super(observable);
    }

    @Override
    protected ObserverToIteratorSink<T, T> run(Subscription handle) {
        return new ObserverToIteratorSink<T, T>(handle){
            final BlockingQueue<Notification<T>> queue;
            {
                this.queue = new LinkedBlockingQueue();
            }

            public void onNext(T value) {
                this.queue.add(Notification.createOnNext(value));
            }

            public void onError(Throwable ex) {
                this.done();
                this.queue.add(Notification.createOnError((Throwable)ex));
            }

            public void onCompleted() {
                this.done();
                this.queue.add(Notification.createOnCompleted());
            }

            @Override
            public boolean tryNext(SingleOption<? super T> out) {
                try {
                    Notification o = this.queue.take();
                    if (o.isOnCompleted()) {
                        return false;
                    }
                    out.addOption(o);
                }
                catch (InterruptedException ex) {
                    out.addError(ex);
                }
                return true;
            }
        };
    }
}

