/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

public final class IxHelperFunctions {
    private static final Func2<Object, Object, Object> IDENTITY_FIRST = new Func2<Object, Object, Object>(){

        public Object call(Object param1, Object param2) {
            return param1;
        }
    };
    private static final Func2<Object, Object, Object> IDENTITY_SECOND = new Func2<Object, Object, Object>(){

        public Object call(Object param1, Object param2) {
            return param2;
        }
    };
    static final Func2<Integer, Integer, Integer> SUM_INTEGER = new Func2<Integer, Integer, Integer>(){

        public Integer call(Integer param1, Integer param2) {
            return param1 != null ? param1 + param2 : param2;
        }
    };
    static final Func2<Float, Float, Float> SUM_FLOAT = new Func2<Float, Float, Float>(){

        public Float call(Float param1, Float param2) {
            return Float.valueOf(param1 != null ? param1.floatValue() + param2.floatValue() : param2.floatValue());
        }
    };
    static final Func2<Double, Double, Double> SUM_DOUBLE = new Func2<Double, Double, Double>(){

        public Double call(Double param1, Double param2) {
            return param1 != null ? param1 + param2 : param2;
        }
    };
    static final Func2<Long, Long, Long> SUM_LONG = new Func2<Long, Long, Long>(){

        public Long call(Long param1, Long param2) {
            return param1 != null ? param1 + param2 : param2;
        }
    };
    static final Func2<BigInteger, BigInteger, BigInteger> SUM_BIGINTEGER = new Func2<BigInteger, BigInteger, BigInteger>(){

        public BigInteger call(BigInteger param1, BigInteger param2) {
            return param1 != null ? param1.add(param2) : param2;
        }
    };
    static final Func2<BigDecimal, BigDecimal, BigDecimal> SUM_BIGDECIMAL = new Func2<BigDecimal, BigDecimal, BigDecimal>(){

        public BigDecimal call(BigDecimal param1, BigDecimal param2) {
            return param1 != null ? param1.add(param2) : param2;
        }
    };
    private static final Func1<Object, Object> IDENTITY = new Func1<Object, Object>(){

        public Object call(Object t1) {
            return t1;
        }
    };

    public static <Param1, Result> Func1<Param1, Result> constant(final Result value) {
        return new Func1<Param1, Result>(){

            public Result call(Param1 param1) {
                return value;
            }
        };
    }

    public static <T> Func0<T> constant0(final T value) {
        return new Func0<T>(){

            public T call() {
                return value;
            }
        };
    }

    public static <T extends Comparable<? super T>> Func2<T, T, T> max() {
        return new Func2<T, T, T>(){

            public T call(T param1, T param2) {
                if (param1 == null || param2 == null) {
                    if (param2 == null) {
                        return param1;
                    }
                    return param2;
                }
                return param1.compareTo(param2) < 0 ? param2 : param1;
            }
        };
    }

    public static <T extends Comparable<? super T>> Func2<T, T, T> min() {
        return new Func2<T, T, T>(){

            public T call(T param1, T param2) {
                if (param1 == null || param2 == null) {
                    if (param2 == null) {
                        return param1;
                    }
                    return param2;
                }
                return param1.compareTo(param2) > 0 ? param2 : param1;
            }
        };
    }

    public static <T, U> Func2<T, U, T> identityFirst() {
        return IDENTITY_FIRST;
    }

    public static <T, U> Func2<T, U, U> identitySecond() {
        return IDENTITY_SECOND;
    }

    public static <T> Func2<T, T, T> max(final Comparator<? super T> comparator) {
        return new Func2<T, T, T>(){

            public T call(T param1, T param2) {
                if (param1 == null || param2 == null) {
                    if (param2 == null) {
                        return param1;
                    }
                    return param2;
                }
                return comparator.compare(param1, param2) < 0 ? param2 : param1;
            }
        };
    }

    public static <T> Func2<T, T, T> min(final Comparator<? super T> comparator) {
        return new Func2<T, T, T>(){

            public T call(T param1, T param2) {
                if (param1 == null || param2 == null) {
                    if (param2 == null) {
                        return param1;
                    }
                    return param2;
                }
                return comparator.compare(param1, param2) > 0 ? param2 : param1;
            }
        };
    }

    public static <T extends Comparable<? super T>> Comparator<T> comparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        };
    }

    public static <T extends Comparable<? super T>> Comparator<T> comparator0() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        };
    }

    public static <T extends Comparable<? super T>> Comparator<T> comparatorReverse() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o2.compareTo(o1);
            }
        };
    }

    public static <T> Comparator<T> comparatorReverse(final Comparator<? super T> normal) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return normal.compare(o2, o1);
            }
        };
    }

    public static Func2<BigDecimal, BigDecimal, BigDecimal> sumBigDecimal() {
        return SUM_BIGDECIMAL;
    }

    public static Func2<BigInteger, BigInteger, BigInteger> sumBigInteger() {
        return SUM_BIGINTEGER;
    }

    public static Func2<Double, Double, Double> sumDouble() {
        return SUM_DOUBLE;
    }

    public static Func2<Float, Float, Float> sumFloat() {
        return SUM_FLOAT;
    }

    public static Func2<Integer, Integer, Integer> sumInteger() {
        return SUM_INTEGER;
    }

    public static Func2<Long, Long, Long> sumLong() {
        return SUM_LONG;
    }

    public static <T> Func0<ArrayList<T>> arrayListProvider() {
        return new Func0<ArrayList<T>>(){

            public ArrayList<T> call() {
                return new ArrayList();
            }
        };
    }

    public static <T, U> Func1<U, ArrayList<T>> arrayListProvider1() {
        return new Func1<U, ArrayList<T>>(){

            public ArrayList<T> call(U ignored) {
                return new ArrayList();
            }
        };
    }

    public static <T> Func0<LinkedList<T>> linkedListProvider() {
        return new Func0<LinkedList<T>>(){

            public LinkedList<T> call() {
                return new LinkedList();
            }
        };
    }

    public static <K, V> Func0<HashMap<K, V>> hashMapProvider() {
        return new Func0<HashMap<K, V>>(){

            public HashMap<K, V> call() {
                return new HashMap();
            }
        };
    }

    public static <K, V> Func0<TreeMap<K, V>> treeMapProvider() {
        return new Func0<TreeMap<K, V>>(){

            public TreeMap<K, V> call() {
                return new TreeMap();
            }
        };
    }

    public static <K, V> Func0<TreeMap<K, V>> treeMapProvider(final Comparator<? super K> keyComparator) {
        return new Func0<TreeMap<K, V>>(){

            public TreeMap<K, V> call() {
                return new TreeMap(keyComparator);
            }
        };
    }

    public static <K, V> Func0<LinkedHashMap<K, V>> linkedHashMapProvider() {
        return new Func0<LinkedHashMap<K, V>>(){

            public LinkedHashMap<K, V> call() {
                return new LinkedHashMap();
            }
        };
    }

    public static <K, V> Func0<ConcurrentHashMap<K, V>> concurrentHashMapProvider() {
        return new Func0<ConcurrentHashMap<K, V>>(){

            public ConcurrentHashMap<K, V> call() {
                return new ConcurrentHashMap();
            }
        };
    }

    public static <T> Func0<HashSet<T>> hashSetProvider() {
        return new Func0<HashSet<T>>(){

            public HashSet<T> call() {
                return new HashSet();
            }
        };
    }

    public static <T> Func0<TreeSet<T>> treeSetProvider() {
        return new Func0<TreeSet<T>>(){

            public TreeSet<T> call() {
                return new TreeSet();
            }
        };
    }

    public static <T> Func0<TreeSet<T>> treeSetProvider(final Comparator<? super T> elementComparator) {
        return new Func0<TreeSet<T>>(){

            public TreeSet<T> call() {
                return new TreeSet(elementComparator);
            }
        };
    }

    public static Func1<Boolean, Boolean> negate() {
        return new Func1<Boolean, Boolean>(){

            public Boolean call(Boolean param1) {
                return param1 == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE;
            }
        };
    }

    public static <T> Func1<T, T> identity() {
        return IDENTITY;
    }

    private IxHelperFunctions() {
    }
}

