/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class SubsequentCountIterable<T>
implements Iterable<Iterable<T>> {
    private final Iterable<? extends T> source;
    private final int count;

    public SubsequentCountIterable(Iterable<? extends T> source, int count) {
        this.source = source;
        this.count = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Iterable<T>> iterator() {
        int cnt;
        final LinkedList<T> ll = new LinkedList<T>();
        final Iterator<T> it = this.source.iterator();
        try {
            for (cnt = 0; it.hasNext() && cnt < this.count - 1; ++cnt) {
                ll.add(it.next());
            }
        }
        finally {
            Interactive.unsubscribe(it);
        }
        if (cnt < this.count - 1) {
            return Interactive.empty().iterator();
        }
        return new Iterator<Iterable<T>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Iterable<T> next() {
                if (this.hasNext()) {
                    ll.add(it.next());
                    ll.removeFirst();
                    return new ArrayList(ll);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

