/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.CircularBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;

public final class TakeLastIterable<T>
implements Iterable<T> {
    private final Iterable<? extends T> source;
    private final int num;

    public TakeLastIterable(Iterable<? extends T> source, int num) {
        this.source = source;
        this.num = num;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<? extends T> it;
            final CircularBuffer<Notification<? extends T>> buffer;
            {
                this.it = TakeLastIterable.this.source.iterator();
                this.buffer = new CircularBuffer(TakeLastIterable.this.num);
            }

            @Override
            public boolean hasNext() {
                try {
                    while (this.it.hasNext()) {
                        this.buffer.add(Interactive.some(this.it.next()));
                    }
                }
                catch (Throwable t) {
                    this.buffer.add(Interactive.err(t));
                }
                finally {
                    Interactive.unsubscribe(this.it);
                }
                return !this.buffer.isEmpty();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return Interactive.value(this.buffer.take());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

